/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.lzf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xbib.io.compress.lzf.BufferRecycler;
import org.xbib.io.compress.lzf.ChunkDecoder;
import org.xbib.io.compress.lzf.ChunkDecoderFactory;

public class LZFInputStream
extends InputStream {
    protected final ChunkDecoder _decoder;
    protected final BufferRecycler _recycler;
    protected final InputStream _inputStream;
    protected boolean _inputStreamClosed;
    protected boolean _cfgFullReads = false;
    protected byte[] _inputBuffer;
    protected byte[] _decodedBytes;
    protected int _bufferPosition = 0;
    protected int _bufferLength = 0;
    protected int _readCount = 0;

    public LZFInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public LZFInputStream(InputStream in, boolean fullReads) throws IOException {
        this(in, fullReads, ChunkDecoderFactory.optimalInstance());
    }

    public LZFInputStream(InputStream in, boolean fullReads, ChunkDecoder decoder) throws IOException {
        this._decoder = decoder;
        this._recycler = BufferRecycler.instance();
        this._inputStream = in;
        this._inputStreamClosed = false;
        this._cfgFullReads = fullReads;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
    }

    public void setUseFullReads(boolean b) {
        this._cfgFullReads = b;
    }

    @Override
    public int available() {
        if (this._inputStreamClosed) {
            return -1;
        }
        int left = this._bufferLength - this._bufferPosition;
        return left <= 0 ? 0 : left;
    }

    @Override
    public int read() throws IOException {
        if (!this.readyBuffer()) {
            return -1;
        }
        return this._decodedBytes[this._bufferPosition++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this._bufferLength - this._bufferPosition, length);
        System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
        this._bufferPosition += chunkLength;
        if (chunkLength == length || !this._cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this._bufferLength - this._bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this._bufferPosition, buffer, offset, chunkLength);
            this._bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    @Override
    public void close() throws IOException {
        this._bufferLength = 0;
        this._bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        if (!this._inputStreamClosed) {
            this._inputStreamClosed = true;
            this._inputStream.close();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this._inputStreamClosed) {
            return -1L;
        }
        int left = this._bufferLength - this._bufferPosition;
        if (left <= 0) {
            int b = this.read();
            if (b < 0) {
                return -1L;
            }
            --this._bufferPosition;
            left = this._bufferLength - this._bufferPosition;
        }
        if ((long)left > n) {
            left = (int)n;
        }
        this._bufferPosition += left;
        return left;
    }

    public InputStream getUnderlyingInputStream() {
        return this._inputStream;
    }

    public void discardBuffered() {
        this._bufferLength = 0;
        this._bufferPosition = 0;
    }

    public int readAndWrite(OutputStream out) throws IOException {
        int total = 0;
        while (this.readyBuffer()) {
            int avail = this._bufferLength - this._bufferPosition;
            out.write(this._decodedBytes, this._bufferPosition, avail);
            this._bufferPosition += avail;
            total += avail;
        }
        return total;
    }

    protected boolean readyBuffer() throws IOException {
        if (this._bufferPosition < this._bufferLength) {
            return true;
        }
        if (this._inputStreamClosed) {
            return false;
        }
        this._bufferLength = this._decoder.decodeChunk(this._inputStream, this._inputBuffer, this._decodedBytes);
        if (this._bufferLength < 0) {
            return false;
        }
        this._bufferPosition = 0;
        return this._bufferPosition < this._bufferLength;
    }
}

