/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz;

import java.io.InputStream;
import org.xbib.io.compress.xz.BCJCoder;
import org.xbib.io.compress.xz.FilterDecoder;
import org.xbib.io.compress.xz.SimpleInputStream;
import org.xbib.io.compress.xz.UnsupportedOptionsException;
import org.xbib.io.compress.xz.simple.ARM;
import org.xbib.io.compress.xz.simple.ARMThumb;
import org.xbib.io.compress.xz.simple.IA64;
import org.xbib.io.compress.xz.simple.PowerPC;
import org.xbib.io.compress.xz.simple.SPARC;
import org.xbib.io.compress.xz.simple.SimpleFilter;
import org.xbib.io.compress.xz.simple.X86;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;

    BCJDecoder(long filterID, byte[] props) throws UnsupportedOptionsException {
        assert (BCJDecoder.isBCJFilterID(filterID));
        this.filterID = filterID;
        if (props.length == 0) {
            this.startOffset = 0;
        } else if (props.length == 4) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n |= (props[i] & 0xFF) << i * 8;
            }
            this.startOffset = n;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    @Override
    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    @Override
    public InputStream getInputStream(InputStream in) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else assert (false);
        return new SimpleInputStream(in, simpleFilter);
    }
}

