/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.xbib.io.compress.xz.BlockInputStream;
import org.xbib.io.compress.xz.CorruptedInputException;
import org.xbib.io.compress.xz.IndexIndicatorException;
import org.xbib.io.compress.xz.MemoryLimitException;
import org.xbib.io.compress.xz.SeekableInputStream;
import org.xbib.io.compress.xz.UnsupportedOptionsException;
import org.xbib.io.compress.xz.XZ;
import org.xbib.io.compress.xz.XZFormatException;
import org.xbib.io.compress.xz.XZIOException;
import org.xbib.io.compress.xz.check.Check;
import org.xbib.io.compress.xz.common.DecoderUtil;
import org.xbib.io.compress.xz.common.StreamFlags;
import org.xbib.io.compress.xz.index.BlockInfo;
import org.xbib.io.compress.xz.index.IndexDecoder;

public class SeekableXZInputStream
extends SeekableInputStream {
    private SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList<IndexDecoder> streams = new ArrayList();
    private IndexDecoder index;
    private int checkTypes = 0;
    private Check check;
    private BlockInputStream blockDecoder = null;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;

    public SeekableXZInputStream(SeekableInputStream in) throws IOException {
        this(in, -1);
    }

    public SeekableXZInputStream(SeekableInputStream in, int memoryLimit) throws IOException {
        this.in = in;
        DataInputStream inData = new DataInputStream(in);
        in.seek(0L);
        byte[] buf = new byte[XZ.HEADER_MAGIC.length];
        inData.readFully(buf);
        if (!Arrays.equals(buf, XZ.HEADER_MAGIC)) {
            throw new XZFormatException();
        }
        long pos = in.length();
        if ((pos & 3L) != 0L) {
            throw new CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] buf2 = new byte[12];
        long streamPadding = 0L;
        while (pos > 0L) {
            long off;
            if (pos < 12L) {
                throw new CorruptedInputException();
            }
            in.seek(pos - 12L);
            inData.readFully(buf2);
            if (buf2[8] == 0 && buf2[9] == 0 && buf2[10] == 0 && buf2[11] == 0) {
                streamPadding += 4L;
                pos -= 4L;
                continue;
            }
            StreamFlags streamFooter = DecoderUtil.decodeStreamFooter(buf2);
            if (streamFooter.backwardSize >= (pos -= 12L)) {
                throw new CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = Check.getInstance(streamFooter.checkType);
            this.checkTypes |= 1 << streamFooter.checkType;
            in.seek(pos - streamFooter.backwardSize);
            try {
                this.index = new IndexDecoder(in, streamFooter, streamPadding, memoryLimit);
            }
            catch (MemoryLimitException e) {
                assert (memoryLimit >= 0);
                throw new MemoryLimitException(e.getMemoryNeeded() + this.indexMemoryUsage, memoryLimit + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += this.index.getMemoryUsage();
            if (memoryLimit >= 0) assert ((memoryLimit -= this.index.getMemoryUsage()) >= 0);
            if (this.largestBlockSize < this.index.getLargestBlockSize()) {
                this.largestBlockSize = this.index.getLargestBlockSize();
            }
            if (pos < (off = this.index.getStreamSize() - 12L)) {
                throw new CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            in.seek(pos -= off);
            inData.readFully(buf2);
            StreamFlags streamHeader = DecoderUtil.decodeStreamHeader(buf2);
            if (!DecoderUtil.areStreamFlagsEqual(streamHeader, streamFooter)) {
                throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += this.index.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new UnsupportedOptionsException("XZ file is too big");
            }
            this.streams.add(this.index);
            streamPadding = 0L;
        }
        assert (pos == 0L);
        this.memoryLimit = memoryLimit;
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        return this.read(buf, 0, 1) == -1 ? -1 : buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int size;
        block13: {
            if (off < 0 || len < 0 || off + len < 0 || off + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            size = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (len > 0) {
                    int ret;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((ret = this.blockDecoder.read(buf, off, len)) > 0) {
                        this.curPos += (long)ret;
                        size += ret;
                        off += ret;
                        len -= ret;
                        continue;
                    }
                    if (ret != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException e2) {
                CorruptedInputException e2;
                if (e2 instanceof EOFException) {
                    e2 = new CorruptedInputException();
                }
                this.exception = e2;
                if (size != 0) break block13;
                throw e2;
            }
        }
        return size;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public long length() {
        return this.uncompressedSize;
    }

    @Override
    public long position() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (pos < 0L) {
            throw new XZIOException("Negative seek position: " + pos);
        }
        this.seekPos = pos;
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        long skipAmount;
        long compressedSum;
        long uncompressedSum;
        block10: {
            if (!this.seekNeeded) {
                if (this.index.hasNext()) {
                    BlockInfo info = this.index.getNext();
                    this.initBlockDecoder(info);
                    return;
                }
                this.seekPos = this.curPos;
            }
            this.seekNeeded = false;
            if (this.seekPos >= this.uncompressedSize) {
                this.curPos = this.seekPos;
                this.blockDecoder = null;
                this.endReached = true;
                return;
            }
            this.endReached = false;
            int i = this.streams.size();
            assert (i >= 1);
            uncompressedSum = 0L;
            compressedSum = 0L;
            while (true) {
                this.index = this.streams.get(--i);
                if (uncompressedSum + this.index.getUncompressedSize() > this.seekPos) break block10;
                uncompressedSum += this.index.getUncompressedSize();
                assert (((compressedSum += this.index.getStreamAndPaddingSize()) & 3L) == 0L);
            }
        }
        BlockInfo info = this.index.locate(this.seekPos - uncompressedSum);
        assert ((info.compressedOffset & 3L) == 0L) : info.compressedOffset;
        info.compressedOffset += compressedSum;
        info.uncompressedOffset += uncompressedSum;
        assert (this.seekPos >= info.uncompressedOffset);
        assert (this.seekPos < info.uncompressedOffset + info.uncompressedSize);
        if (this.curPos <= info.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(info.compressedOffset);
            this.check = Check.getInstance(info.streamFlags.checkType);
            this.initBlockDecoder(info);
            this.curPos = info.uncompressedOffset;
        }
        if (this.seekPos > this.curPos && this.blockDecoder.skip(skipAmount = this.seekPos - this.curPos) != skipAmount) {
            throw new CorruptedInputException();
        }
        this.curPos = this.seekPos;
    }

    private void initBlockDecoder(BlockInfo info) throws IOException {
        try {
            this.blockDecoder = null;
            this.blockDecoder = new BlockInputStream(this.in, this.check, this.memoryLimit, info.unpaddedSize, info.uncompressedSize);
        }
        catch (MemoryLimitException e) {
            assert (this.memoryLimit >= 0);
            throw new MemoryLimitException(e.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch (IndexIndicatorException e) {
            throw new CorruptedInputException();
        }
    }
}

