/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xbib.io.compress.CompressCodec;
import org.xbib.io.compress.xz.LZMA2Options;
import org.xbib.io.compress.xz.XZInputStream;
import org.xbib.io.compress.xz.XZOutputStream;

public class XZCompressCodec
implements CompressCodec<XZInputStream, XZOutputStream> {
    @Override
    public String getName() {
        return "xz";
    }

    @Override
    public XZInputStream decode(InputStream in) throws IOException {
        return new XZInputStream(in);
    }

    @Override
    public XZInputStream decode(InputStream in, int bufsize) throws IOException {
        return new XZInputStream(in, bufsize / 1024);
    }

    @Override
    public XZOutputStream encode(OutputStream out) throws IOException {
        return new XZOutputStream(out, new LZMA2Options());
    }

    @Override
    public XZOutputStream encode(OutputStream out, int bufsize) throws IOException {
        return new XZOutputStream(out, new LZMA2Options());
    }
}

