/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz.check;

import org.xbib.io.compress.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        int end = off + len;
        while (off < end) {
            this.crc = crcTable[(buf[off++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long value = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] buf = new byte[8];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(value >> i * 8);
        }
        return buf;
    }

    static {
        for (int b = 0; b < crcTable.length; ++b) {
            long r = b;
            for (int i = 0; i < 8; ++i) {
                if ((r & 1L) == 1L) {
                    r = r >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                r >>>= 1;
            }
            CRC64.crcTable[b] = r;
        }
    }
}

