/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz.index;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.xbib.io.compress.xz.CorruptedInputException;
import org.xbib.io.compress.xz.MemoryLimitException;
import org.xbib.io.compress.xz.SeekableInputStream;
import org.xbib.io.compress.xz.UnsupportedOptionsException;
import org.xbib.io.compress.xz.common.DecoderUtil;
import org.xbib.io.compress.xz.common.StreamFlags;
import org.xbib.io.compress.xz.index.BlockInfo;
import org.xbib.io.compress.xz.index.IndexBase;

public class IndexDecoder
extends IndexBase {
    private final BlockInfo info = new BlockInfo();
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int pos = -1;

    public IndexDecoder(SeekableInputStream in, StreamFlags streamFooterFlags, long streamPadding, int memoryLimit) throws IOException {
        super(new CorruptedInputException("XZ Index is corrupt"));
        int i;
        this.info.streamFlags = streamFooterFlags;
        this.streamPadding = streamPadding;
        long endPos = in.position() + streamFooterFlags.backwardSize - 4L;
        CRC32 crc32 = new CRC32();
        CheckedInputStream inChecked = new CheckedInputStream(in, crc32);
        if (inChecked.read() != 0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        try {
            long count = DecoderUtil.decodeVLI(inChecked);
            if (count >= streamFooterFlags.backwardSize / 2L) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (count > Integer.MAX_VALUE) {
                throw new UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * count + 1023L) / 1024L);
            if (memoryLimit >= 0 && this.memoryUsage > memoryLimit) {
                throw new MemoryLimitException(this.memoryUsage, memoryLimit);
            }
            this.unpadded = new long[(int)count];
            this.uncompressed = new long[(int)count];
            int record = 0;
            for (i = (int)count; i > 0; --i) {
                long unpaddedSize = DecoderUtil.decodeVLI(inChecked);
                long uncompressedSize = DecoderUtil.decodeVLI(inChecked);
                if (in.position() > endPos) {
                    throw new CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[record] = this.blocksSum + unpaddedSize;
                this.uncompressed[record] = this.uncompressedSum + uncompressedSize;
                super.add(unpaddedSize, uncompressedSize);
                assert ((long)(++record) == this.recordCount);
                if (this.largestBlockSize >= uncompressedSize) continue;
                this.largestBlockSize = uncompressedSize;
            }
        }
        catch (EOFException e) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        int indexPaddingSize = this.getIndexPaddingSize();
        if (in.position() + (long)indexPaddingSize != endPos) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        while (indexPaddingSize-- > 0) {
            if (inChecked.read() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long value = crc32.getValue();
        for (i = 0; i < 4; ++i) {
            if ((value >>> i * 8 & 0xFFL) == (long)in.read()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }

    public BlockInfo locate(long target) {
        assert (target < this.uncompressedSum);
        int left = 0;
        int right = this.unpadded.length - 1;
        while (left < right) {
            int i = left + (right - left) / 2;
            if (this.uncompressed[i] <= target) {
                left = i + 1;
                continue;
            }
            right = i;
        }
        this.pos = left;
        return this.getInfo();
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getStreamAndPaddingSize() {
        return this.getStreamSize() + this.streamPadding;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasNext() {
        return (long)(this.pos + 1) < this.recordCount;
    }

    public BlockInfo getNext() {
        ++this.pos;
        return this.getInfo();
    }

    private BlockInfo getInfo() {
        if (this.pos == 0) {
            this.info.compressedOffset = 0L;
            this.info.uncompressedOffset = 0L;
        } else {
            this.info.compressedOffset = this.unpadded[this.pos - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            this.info.uncompressedOffset = this.uncompressed[this.pos - 1];
        }
        this.info.unpaddedSize = this.unpadded[this.pos] - this.info.compressedOffset;
        this.info.uncompressedSize = this.uncompressed[this.pos] - this.info.uncompressedOffset;
        this.info.compressedOffset += 12L;
        return this.info;
    }
}

