/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.io.compress.xz.rangecoder;

import java.io.DataInputStream;
import java.io.IOException;
import org.xbib.io.compress.xz.CorruptedInputException;
import org.xbib.io.compress.xz.rangecoder.RangeCoder;

public final class RangeDecoder
extends RangeCoder {
    private static final int INIT_SIZE = 5;
    private final byte[] buf;
    private int pos = 0;
    private int end = 0;
    private int range = 0;
    private int code = 0;

    public RangeDecoder(int inputSizeMax) {
        this.buf = new byte[inputSizeMax - 5];
    }

    public void prepareInputBuffer(DataInputStream in, int len) throws IOException {
        if (len < 5) {
            throw new CorruptedInputException();
        }
        if (in.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = in.readInt();
        this.range = -1;
        this.pos = 0;
        this.end = len - 5;
        in.readFully(this.buf, 0, this.end);
    }

    public boolean isInBufferOK() {
        return this.pos <= this.end;
    }

    public boolean isFinished() {
        return this.pos == this.end && this.code == 0;
    }

    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            try {
                this.code = this.code << 8 | this.buf[this.pos++] & 0xFF;
                this.range <<= 8;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CorruptedInputException();
            }
        }
    }

    public int decodeBit(short[] probs, int index) throws IOException {
        int bit;
        this.normalize();
        short prob = probs[index];
        int bound = (this.range >>> 11) * prob;
        if ((this.code ^ Integer.MIN_VALUE) < (bound ^ Integer.MIN_VALUE)) {
            this.range = bound;
            probs[index] = (short)(prob + (2048 - prob >>> 5));
            bit = 0;
        } else {
            this.range -= bound;
            this.code -= bound;
            probs[index] = (short)(prob - (prob >>> 5));
            bit = 1;
        }
        return bit;
    }

    public int decodeBitTree(short[] probs) throws IOException {
        int symbol = 1;
        while ((symbol = symbol << 1 | this.decodeBit(probs, symbol)) < probs.length) {
        }
        return symbol - probs.length;
    }

    public int decodeReverseBitTree(short[] probs) throws IOException {
        int symbol = 1;
        int i = 0;
        int result = 0;
        do {
            int bit = this.decodeBit(probs, symbol);
            symbol = symbol << 1 | bit;
            result |= bit << i++;
        } while (symbol < probs.length);
        return result;
    }

    public int decodeDirectBits(int count) throws IOException {
        int result = 0;
        do {
            this.normalize();
            this.range >>>= 1;
            int t = this.code - this.range >>> 31;
            this.code -= this.range & t - 1;
            result = result << 1 | 1 - t;
        } while (--count != 0);
        return result;
    }
}

