Gem::Specification.new do |s|
  s.name = 'logstash-filter-aggregate'
  s.version = '2.5.1'
  s.licenses = ['Apache License (2.0)']
  s.summary = 'The aim of this filter is to aggregate information available among several events (typically log lines) belonging to a same task, and finally push aggregated information into final task event.'
  s.description = 'This gem is a Logstash plugin required to be installed on top of the Logstash core pipeline using $LS_HOME/bin/logstash-plugin install gemname. This gem is not a stand-alone program'
  s.authors = ['Elastic', 'Fabien Baligand']
  s.email = 'info@elastic.co'
  s.homepage = 'https://github.com/logstash-plugins/logstash-filter-aggregate'
  s.require_paths = ['lib']

  # Files
  s.files = Dir['lib/**/*','spec/**/*','*.gemspec','*.md','CONTRIBUTORS','Gemfile','LICENSE','NOTICE.txt']

  # Tests
  s.test_files = s.files.grep(%r{^(test|spec|features)/})

  # Special flag to let us know this is actually a logstash plugin
  s.metadata = { 'logstash_plugin' => 'true', 'logstash_group' => 'filter' }

  # Gem dependencies
  s.add_runtime_dependency 'logstash-core-plugin-api', '>= 1.60', '<= 2.99'
  
  # Gem test dependencies
  s.add_development_dependency 'logstash-devutils'
end
