# logstash-filter-lookup

New lookup plugin for dynamic lookup enrichment from multiple types of sources. There are a few different filters out there today that conduct different types of lookups, which may make sense being encapsulated within one lookup filter.


## Example
### 1. Web Service Example
See examples/webservice/java

### 2. Logstash config example
```
input {
	stdin{}
}
filter {
	lookup {
		field => "message"
		map_url => "http://localhost:8080/json"
		destination => "dest"
		refresh_interval => 10
	}
}
output {
	stdout{

	}
}
```
### 3. Execution example
Install with bin/plugin install logstash-filter-lookup
```sh
bin/logstash -f config/myconf.conf --log logstash.log --debug
```

### 4. Results
#### Input
200

#### Output
```
{
    :timestamp=>"2016-03-13T10:41:50.264000+0100", 
    :message=>"output received", 
    :event=>{
        "message"=>"200", 
        "@version"=>"1", 
        "@timestamp"=>"2016-03-13T09:41:49.493Z", 
        "host"=>"Mac-mini-de-angel.local", 
        "dest"=>"OK"
    }, 
    :level=>:debug, 
    :file=>"(eval)", 
    :line=>"47", 
    :method=>"output_func"
}
```

### 5. Update
bin/plugin update logstash-filter-lookup

### 6. GEM
https://rubygems.org/gems/logstash-filter-lookup

## Documentation

Logstash provides infrastructure to automatically generate documentation for this plugin. We use the asciidoc format to write documentation so any comments in the source code will be first converted into asciidoc and then into html. All plugin documentation are placed under one [central location](http://www.elastic.co/guide/en/logstash/current/).

- For formatting code or config example, you can use the asciidoc `[source,ruby]` directive
- For more asciidoc formatting tips, see the excellent reference here https://github.com/elastic/docs#asciidoc-guide

## Need Help?

Need help? Try #logstash on freenode IRC or the https://discuss.elastic.co/c/logstash discussion forum.

## Developing

### 1. Plugin Developement and Testing

#### Code
- To get started, you'll need JRuby with the Bundler gem installed.

- Create a new plugin or clone and existing from the GitHub [logstash-plugins](https://github.com/logstash-plugins) organization. We also provide [example plugins](https://github.com/logstash-plugins?query=example).

- Install dependencies
```sh
bundle install
```

#### Test

- Update your dependencies

```sh
bundle install
```

- Run tests

```sh
bundle exec rspec
```

### 2. Running your unpublished Plugin in Logstash

#### 2.1 Run in a local Logstash clone

- Edit Logstash `Gemfile` and add the local plugin path, for example:
```ruby
gem "logstash-filter-awesome", :path => "/your/local/logstash-filter-awesome"
```
- Install plugin
```sh
bin/plugin install --no-verify
```
- Run Logstash with your plugin
```sh
bin/logstash -e 'filter {awesome {}}'
```
At this point any modifications to the plugin code will be applied to this local Logstash setup. After modifying the plugin, simply rerun Logstash.

#### 2.2 Run in an installed Logstash

You can use the same **2.1** method to run your plugin in an installed Logstash by editing its `Gemfile` and pointing the `:path` to your local plugin development directory or you can build the gem and install it using:

- Build your plugin gem
```sh
gem build logstash-filter-awesome.gemspec
```
- Install the plugin from the Logstash home
```sh
bin/plugin install /your/local/plugin/logstash-filter-awesome.gem
```
- Start Logstash and proceed to test the plugin

## Contributing

All contributions are welcome: ideas, patches, documentation, bug reports, complaints, and even something you drew up on a napkin.

Programming is not a required skill. Whatever you've seen about open source and maintainers or community members  saying "send patches or die" - you will not see that here.

It is more important to the community that you are able to contribute.

For more information about contributing, see the [CONTRIBUTING](https://github.com/elastic/logstash/blob/master/CONTRIBUTING.md) file.