# Contributing

We love pull requests from everyone. By participating in this project, you
agree to abide by our [code of conduct](https://github.com/ejholmes/restforce/blob/master/CODE_OF_CONDUCT.md).

Fork, then clone the repo:

    git clone git@github.com:ejholmes/restforce.git

Set up your machine:

    script/bootstrap

Play with the library by starting a console:

    script/console

Make sure the tests pass:

    script/test

Make your change. Add tests for your change. Make the tests pass:

    script/test

Push to your fork and [submit a pull request](https://github.com/ejholmes/restforce/compare/).

At this point you're waiting on us. We like to at least comment on pull requests
within a few days. We may suggest
some changes or improvements or alternatives.

Some things that will increase the chance that your pull request is accepted:

* Write tests.
* Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html).

*Adapted from [factory_girl_rails's CONTRIBUTING.md](https://github.com/thoughtbot/factory_girl_rails/blob/master/CONTRIBUTING.md).*
