<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'dashboard/index';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// Auth stuff
$route['login'] = 'auth/login';
$route['forgot_password'] = 'auth/forgot_password';
$route['reset_password/(:any)'] = 'auth/reset_password/$1';
$route['logout'] = 'dashboard/logout';

// Profile
$route['profile'] = 'dashboard/profile';
$route['profile/password'] = 'auth/change_password';
$route['profile/newkey'] = 'dashboard/newkey';

// Install/enter key
$route['enterkey'] = 'install/enterkey';

// Admin section
$route['admin/audit-log'] = 'admin/audit_log';

// User section
$route['admin/users/create'] = 'admin/create_user';
$route['admin/users/delete'] = 'admin/delete_user';
$route['admin/users/edit/(:any)'] = 'admin/edit_user/$1';
$route['admin/users/import'] = 'admin/user_import';
$route['admin/users/import/step2'] = 'admin/user_import_step2';
$route['admin/users/import/complete'] = 'admin/user_import_complete';

// Backend API
$route['api/backend/(.+)'] = 'api/backend/index';
$route['api/system/(.+)'] = 'api/system/$1';

// Dashboards
$route['dashboard'] = 'dashboard/show_dash';
$route['index.php/dashboard'] = 'dashboard/show_dash';
$route['export'] = 'dashboard/export';

// Waiting/Down ... Something to show when elasticsearch isn't up or during elasticsearch restart
$route['waiting'] = 'install/waiting';
$route['down'] = 'install/down';

// Alert history
$route['alerts/history/show/(:any)'] = 'alerts/history_show/$1';
$route['alerts/history/export/(:any)'] = 'alerts/history_export/$1';

// Add log sources
$route['configure/add-log-source'] = 'source/index';
$route['configure/source/windows-files'] = 'source/windows_files';
$route['configure/source/linux-files'] = 'source/linux_files';
$route['configure/source/(:any)'] = 'source/$1';

// Reports
$route['admin/hosts/remove/(:any)'] = 'admin/hosts_remove/$1';
