<?php 

// Call another CLI function in the background, then exit.
// This allows us to use an elasticsearch exec to call the main application.
class CLI_Nonblocking extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		if (!$this->input->is_cli_request()) {
			echo _("This class can only be accessed via the command line.");
			exit();
		}
	}

	public function run($endpoint, $function, $args) {
		$endpoint = escapeshellarg($endpoint);
		$function = escapeshellarg($function);
		$args = explode(' ', $args);
		foreach ($args as &$arg) {
			$arg = escapeshellarg($arg);
		}
		$args = implode(' ', $args);
		$cmd_string = "nohup php /var/www/html/nagioslogserver/www/index.php cli $endpoint $function $args >/dev/null 2>&1 &";
		exec($cmd_string);
	}
}