<?php

// This class is responsible for running scheduled reports. It should be run from cron or from models->ScheduledReport->send()
class CLI_Reporting extends CI_Controller
{

    const ES_TYPE = 'scheduled_report';

    function __construct() {
        parent::__construct();

        if (!$this->input->is_cli_request()) {
            echo _("This class can only be accessed via the command line.");
            exit();
        }
    }

    /* $args is a serialized (rawurlencode()ed) version of _POST or _GET arguments, since php-cli doesn't allow for this */
    public function run($args) {

        $this->load->helper('data');
        $this->load->helper('reporting');

        $args = explode('&', rawurldecode($args));

        $args_array = array();
        for ($i = 0; $i < count($args); $i++) {
            $arg = explode('=', $args[$i]);
            $args_array[$arg[0]] = $arg[1];
        }

        $sr_id = $args_array['srid'];
        $sr_args = $this->elasticsearch->get(self::ES_TYPE, $sr_id);
        $sr_args['_source']['id'] = $sr_args['_id'];
        $sr_args = $sr_args['_source'];

        $sr_args['attachments'] = $this->process_attachments($sr_args['dashboard-id'], $sr_args['report_args'], $sr_args['attachments']);

        $this->send_email($sr_args['recipients'], $sr_args['subject'], $sr_args['message'], $sr_args['attachments']);
    }

    /** send_email - sends the e-mail for Scheduled Reports (+ Email this Report)
     * @todo  combine this and alert's send_email so we don't have to maintain both
     * @param $recipients  - a comma-delimited list of e-mail addresses to send to.
     * @param $subject     - The user-specified subject, if it exists, otherwise a default subject should be passed in (usually just the $reportname)
     * @param $message     - The user-specified message, if it exists, otherwise a default message should be passed in.
     * @param $attachments - An array of file paths which should be attached to the outgoing e-mail.
     */
    private function send_email($recipients, $subject, $message, $attachments)
    {
        // Set the default language here.
        $lang = $this->config_option->get('language', true);
        if (empty($lang)) { $lang = get_option('language', ''); }
        set_language($lang);


        $this->load->library('email');
        $this->load->helper('mail');

        $config = mail_get_config();
        $this->email->initialize($config);
        foreach($attachments as $type => $attachment) {
            $this->email->attach($attachment, '', basename($attachment));
        }

        for ($i = 0; $i < count($recipients); $i++) {
            $recipient = $recipients[$i];

            // TODO: grab user from e-mail if applicable, grab language from that user.
            // $lang_changed = false;
            // if ($user['language'] !== 'default' && $user['language'] !== $lang) {
            //     set_language($user['language']);
            //     $lang_changed = true;
            // }

            // Send email
            $this->email->clear();
            $this->email->to($recipient);
            $this->email->reply_to(get_option('email_reply_to', 'root@localhost'), get_option('email_reply_to_name', _('Nagios Log Server')));
            $this->email->from(get_option('email_from', 'root@localhost'), get_option('email_from_name', _('Nagios Log Server')));
            $this->email->subject($subject);
            $this->email->message($message);
            $this->email->send();

            // if ($lang_changed) {
            //     set_language($lang);
            // }
        }
    }

    private function process_attachments($dashboard_id, $report_args, $attachments)
    {

        $this->load->helper('reporting');

        $report_args = rawurldecode($report_args);
        $report_args = report_uri_to_args($report_args);

        // Also retrieve the API token for nagiosadmin
        $admin = $this->elasticsearch->get('user', 1);
        $report_args['token'] = $admin['_source']['apikey'];

        foreach ($attachments as $filetype => $status) {

            if ($status !== 'on') {
                continue;
            }

            $filename = null;
            $file_location = null;
            get_reporting_command($dashboard_id, $report_args, $filetype, false, $file_location, $filename, true);
            $count = 0;
            while ($count < 20) {
                if (file_exists($file_location . '/' . $filename)) {
                    break;
                }
                else {
                    sleep(2);
                    $count++;
                }
            }

            if (!is_null($filename) && !is_null($file_location) && file_exists($file_location.$filename)) {
                $attachments[$filetype] = $file_location.$filename;
            }
        }

        return $attachments;
    }
}
