<?php

if (!function_exists('import_data')) {
    function import_data(&$object, $data)
    {
        if (is_object($data)) {
            $data = get_object_vars($data);
        }
        if (is_array($data)) {
            foreach ($data as $property => $value) {
                if (property_exists($object, $property)) {
                    $object->$property = $value;
                }
            }
        }
        return $object;
    }
}

function decode_config_string($data)
{
    $arr = unserialize(base64_decode($data));
    if (!is_array($arr)) { $arr = array($arr); }
    return $arr;
}

function encode_config_string($arr)
{
    // print_r($arr);

    if (!is_array($arr)) { $arr = array($arr); }
    return base64_encode(serialize($arr));
}

function try_add_logstash_index(&$range, $time)
{
    $current_ls_index = "logstash-" . gmdate('Y.m.d', $time);
    $es = new Elasticsearch(array('index' => $current_ls_index));
    $valid_query = $es->status();
    // make sure index is valid before putting index in range
    if (!empty($valid_query['status'])) {
        if ($valid_query['status'] != 403 && $valid_query['status'] != 404) {
            $range[] = $current_ls_index;
        }
    } else {
        if (array_key_exists('_shards', $valid_query)) {
            $range[] = $current_ls_index;
        }
    }
}

function get_logstash_indices_in_range($start, $end)
{    
    $ci =& get_instance();
    $range = array();

    if (!is_numeric($start)) { $start = strtotime($start); }
    if (!is_numeric($end)) { $end = strtotime($end); }
    
    do {
        try_add_logstash_index($range, $start);
        $start = strtotime("+ 1 day", $start);
    } while($start <= $end);

    if (gmdate('Y.m.d', $start) === gmdate('Y.m.d', $end)) {
        // The most recent $start is never added as an index in the previous loop.
        // If the $start date matches $end, we cover the whole range by adding it here.
        try_add_logstash_index($range, $start);
    }

    return implode(',', $range);
}

function snapshot_sort($a, $b)
{
    if (!array_key_exists('created', $a)) { return 0; }
    if (!array_key_exists('created', $b)) { return 0; }
    if ($a['created'] == $b['created']) {
        return 0;
    }
    return ($a['created'] < $b['created']) ? -1 : 1;
}

function ci_nat_sort($a, $b)
{
    return strnatcasecmp($a, $b);
}

// Credit to  Aneeska @ http://ask.amoeba.co.in/pretty-print-json-string-with-php-and-javascript/ for the following function
function json_pretty($json, $html = false)
{
    $out = ''; $nl = "\n"; $cnt = 0; $tab = 4; $len = strlen($json); $space = ' ';
    if($html) {
        $space = '&nbsp;';
        $nl = '<br/>';
    }
    $k = strlen($space)?strlen($space):1;
    for ($i=0; $i<=$len; $i++) {
        $char = substr($json, $i, 1);
        if($char == '}' || $char == ']') {
            $cnt --;
            $out .= $nl . str_pad('', ($tab * $cnt * $k), $space);
        } else if($char == '{' || $char == '[') {
            $cnt ++;
        }
        $out .= $char;
        if($char == ',' || $char == '{' || $char == '[') {
            $out .= $nl . str_pad('', ($tab * $cnt * $k), $space);
        }
        if($char == ':') {
            $out .= ' ';
        }
    }
    return $out;
}

/**
 * Loads a URL and returns the string or object given
 * (See http://www.bin-co.com/php/scripts/load/)
 * Version : 1.00.A
 * License: BSD
 *
 * @param   string  $url        The URL to load
 * @param   array   $options    Options to pass to curl/loader
 * @param   bool    $use_proxy  Use proxy or not
 * @return  array|string        The contents that were loaded
 */
function load_url($url, $options = array('method' => 'get', 'return_info' => false), $use_proxy = false)
{
    // Added 04-28-08 EG added a default timeout of 15 seconds
    if (!isset($options['timeout'])) {
        $options['timeout'] = 15;
    }

    $url_parts = parse_url($url);

    // HTTP code is currently only supported by cURL
    $info = array(
        'http_code' => 200
    );
    $response = '';

    // Set the user agent (added Nagios XI with version number)
    $ver = get_product_version();
    $send_header = array(
        'Accept' => 'text/*',
        'User-Agent' => 'Nagios Log Server/'.$ver.' using BinGet/1.00.A (http://www.bin-co.com/php/scripts/load/)'
    );

    ///////////////////////////// Curl /////////////////////////////////////
    if (function_exists("curl_init") && (!(isset($options['use']) && $options['use'] == 'fsocketopen')))
    {
        if (isset($options['method']) and $options['method'] == 'post') {
            $port = (isset($url_parts['port'])) ? ':' . $url_parts['port'] : '';
            $page = $url_parts['scheme'] . '://' . $url_parts['host'] . $port . $url_parts['path'];
        } else {
            $page = $url;
        }

        $ch = curl_init($url_parts['host']);

        // Added 04-28-08 EG set a timeout
        if (isset($options['timeout'])) {
            curl_setopt($ch, CURLOPT_TIMEOUT, $options['timeout']);
        }

        curl_setopt($ch, CURLOPT_URL, $page);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Just return the data - not print the whole thing.
        curl_setopt($ch, CURLOPT_HEADER, true); // We need the headers
        curl_setopt($ch, CURLOPT_NOBODY, false); // The content - if true, will not download the contents
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        if (isset($options['method']) and $options['method'] == 'post' and isset($url_parts['query']) and $url_parts['query']) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $url_parts['query']);
        }

        // Set the headers our spiders sends
        curl_setopt($ch, CURLOPT_USERAGENT, $send_header['User-Agent']); // The Name of the UserAgent we will be using ;)
        $custom_headers = array("Accept: " . $send_header['Accept']);
        if (isset($options['modified_since'])) {
            array_push($custom_headers, "If-Modified-Since: " . gmdate('D, d M Y H:i:s \G\M\T', strtotime($options['modified_since'])));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, $custom_headers);

        curl_setopt($ch, CURLOPT_COOKIEJAR, "cookie.txt"); // If ever needed...
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

        curl_setopt($ch, CURLOPT_SSLVERSION, get_option('curl_ssl_version', CURL_SSLVERSION_TLSv1_2));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

        // Updated to 2 on 4/10/2013, support for 1 is removed in curl 7.28.1 and PHP 5.4 - MG - Updated 6/4/2013 to take into account older systems -SW
        $curl_version_info = curl_version();
        if ($curl_version_info['version_number'] >= 465921 || version_compare(phpversion(), '5.4', '>')) {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        } else {
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 1);
        }
      
        // Proxy options for load_url()
        if ($use_proxy) {
            // Added ability to turn off HTTPPROXYTUNNEL from proxy component -SW
            curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, get_option('proxy_tunnel', 1));
            curl_setopt($ch, CURLOPT_PROXY, get_option('proxy_address'));
            curl_setopt($ch, CURLOPT_PROXYPORT, get_option('proxy_port'));
            curl_setopt($ch, CURLOPT_PROXYTYPE, 'HTTP');
            // Use auth credentials if specified
            if (have_value(get_option('proxy_auth'))) {
                curl_setopt($ch, CURLOPT_PROXYUSERPWD, get_option('proxy_auth'));
            }
        }

        if (isset($url_parts['user']) and isset($url_parts['pass'])) {
            $custom_headers = array("Authorization: Basic " . base64_encode($url_parts['user'] . ':' . $url_parts['pass']));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $custom_headers);
        }

        $response = curl_exec($ch);

        $info = curl_getinfo($ch); // Some information on the fetch

        // Log error if there is a problem
        if ($response === false) {
            $error = curl_error($ch);

            $info['error'] = $error;
            error_log(__FUNCTION__."() [$error] | (".__FILE__.") line: ".__LINE__);
        }

        curl_close($ch);

    //////////////////////////////////////////// FSockOpen //////////////////////////////
    }
    else
    {
        if (isset($url_parts['query'])) {
            if (isset($options['method']) and $options['method'] == 'post')
                $page = $url_parts['path'];
            else
                $page = $url_parts['path'] . '?' . $url_parts['query'];
        } else {
            $page = $url_parts['path'];
        }

        $fp = fsockopen($url_parts['host'], 80, $errno, $errstr, 30);
        if ($fp) {

            // added 04-28-08 EG set a timeout
            if (isset($options['timeout']))
                stream_set_timeout($fp, $options['timeout']);

            $out = '';
            if (isset($options['method']) and $options['method'] == 'post' and isset($url_parts['query'])) {
                $out .= "POST $page HTTP/1.1\r\n";
            } else {
                $out .= "GET $page HTTP/1.0\r\n"; //HTTP/1.0 is much easier to handle than HTTP/1.1
            }
            $out .= "Host: $url_parts[host]\r\n";
            $out .= "Accept: $send_header[Accept]\r\n";
            $out .= "User-Agent: {$send_header['User-Agent']}\r\n";
            if (isset($options['modified_since']))
                $out .= "If-Modified-Since: " . gmdate('D, d M Y H:i:s \G\M\T', strtotime($options['modified_since'])) . "\r\n";

            $out .= "Connection: Close\r\n";

            //HTTP Basic Authorization support
            if (isset($url_parts['user']) and isset($url_parts['pass'])) {
                $out .= "Authorization: Basic " . base64_encode($url_parts['user'] . ':' . $url_parts['pass']) . "\r\n";
            }

            //If the request is post - pass the data in a special way.
            if (isset($options['method']) and $options['method'] == 'post' and $url_parts['query']) {
                $out .= "Content-Type: application/x-www-form-urlencoded\r\n";
                $out .= 'Content-Length: ' . strlen($url_parts['query']) . "\r\n";
                $out .= "\r\n" . $url_parts['query'];
            }
            $out .= "\r\n";

            fwrite($fp, $out);
            while (!feof($fp)) {
                $response .= fgets($fp, 128);
            }
            fclose($fp);
        }
    }

    // Get the headers in an associative array
    $headers = array();

    // Added logging for connection failures
    if ($info['http_code'] > 399 || $info['http_code'] < 200) {        
        error_log("\nCURL ERROR\n TIME: " . date('c', time()) . "\n" . print_r($info, true) . "\nURL:\n $url \n OPTIONS: \n" . print_r($options, true) . "\nEND LOGENTRY\n\n");
    }

    if ($info['http_code'] == 404) {
        $body = "";
        $headers['Status'] = 404;
    } else {
        // Seperate header and content
        $separator_position = strpos($response, "\r\n\r\n");
        $header_text = substr($response, 0, $separator_position);
        $body = substr($response, $separator_position + 4);

        // Added 04-28-2008 EG if we get a 301 (moved), another set of headers is received,
        if (substr($body, 0, 5) == "HTTP/") {
            $separator_position = strpos($body, "\r\n\r\n");
            $header_text = substr($body, 0, $separator_position);
            $body = substr($body, $separator_position + 4);
        }

        foreach (explode("\n", $header_text) as $line) {
            $parts = explode(": ", $line);
            if (count($parts) == 2) $headers[$parts[0]] = chop($parts[1]);
        }
    }

    if ($options['return_info']) {
        return array('headers' => $headers, 'body' => $body, 'info' => $info);
    }
    return $body;
}

function set_start_end_times($json, $start, $end)
{
    $obj = json_decode($json);

    // Create replace string and turn into micro time
    $replace = new StdClass;
    $replace->from = $start * 1000;
    $replace->to = $end * 1000;

    // Do some processing of the object to remove the current timestamps from/to and 
    // replace them with the new $start and $end variables
    recursive_query_search("@timestamp", $obj, $replace);

    return json_encode($obj);
}

function recursive_query_search($needle, &$haystack, $replace) {
    foreach ($haystack as $k => &$value) {
        if ($k === $needle) {
            $value = $replace;
            return;
        }
        if (is_array($value) || is_object($value)) {
            recursive_query_search($needle, $value, $replace);
        }
    }
    return;
}

//==================================
// Known hosts functions
//==================================

/**
 * Do the known host call and update the database with any new hosts
 * that are found. This is just for historical purposes so we only care
 * about the host's name/ip not the count.
 *
 * @param   int     $hours  The amount of hours to look back
 */
function update_known_hosts($hours=24)
{
    $ci =& get_instance();

    // Create start time
    $start = time() - ($hours * 60 * 60);
    $now = time();

    // Get the data
    $hosts = get_hosts($start);
    $known_hosts = get_known_hosts();

    print "Hosts found: " . count($hosts) . "\n";
    print "Known hosts: " . count($known_hosts) . "\n";

    // Take list of hosts and add it to known hosts with the time that it last received logs
    foreach ($hosts as $host => $logs) {
        $known_hosts[$host] = $now;
    }

    // Update known_hosts option in DB
    set_option('known_hosts_last_check', $now);
    set_option('known_hosts', base64_encode(serialize($known_hosts)));
}

/**
 * Get a unique list of hosts in an array with the amount of logs for each
 *
 * @param   int     $start  Start time
 * @param   int     $end    End time (defaults to now)
 * @return  array           An array of hosts and amount of logs
 */
function get_hosts($start=null, $end=null)
{
    $ci =& get_instance();

    // Set times
    if (empty($start)) { $start = time() - (24*60*60); }
    if (empty($end)) { $end = time(); }

    // Elasticsearch query syntax / filtered aggregation
    $json = '{"query":{"filtered":{"filter":{"bool":{"must":[{"range":{"@timestamp":{"from":1,"to":1}}}]}}}},"aggs":{"hosts":{"terms":{"field":"host.raw", "size":' . 1024*1024*1024 . '}}}}';

    // Do the query
    $index = get_logstash_indices_in_range($start, $end);
    $json = set_start_end_times($json, $start, $end);
    $es = new Elasticsearch(array('index' => $index));
    $data = $es->backend_call('_search?search_type=count', 'POST', $json);

    // Each host in array has a count of how many logs it has sent in the last time frame
    $tmp = $data['aggregations']['hosts']['buckets'];
    $hosts = array();
    foreach ($tmp as $o) {
        $hosts[$o['key']] = $o['doc_count'];
    }

    return $hosts;
}

/**
 * Get a list of all the known hosts
 *
 * @param   array   Array of known hosts
 */
function get_known_hosts()
{
    $ci =& get_instance();
    $known_hosts = array();

    $kh_raw = get_option('known_hosts', '');
    if (!empty($kh_raw)) {
        $known_hosts = unserialize(base64_decode($kh_raw));
    }

    return $known_hosts;
}

/**
 * Delete a known host from the known hosts list
 *
 * @param   string  $host   The name or ip address of the host to remove
 * @return  bool            True if host was removed
 */
function delete_known_host($host)
{
    $ci =& get_instance();
    $known_hosts = get_known_hosts();

    // Remove host from list
    unset($known_hosts[$host]);

    // Save host list
    set_option('known_hosts', base64_encode(serialize($known_hosts)));

    return false;
}

// Returns an array of the IPv4 $addresses which are within the $cidr ranges
// For now, $cidr must be like '192.168.0.1/24', NOT like '192.168.0.1/255.255.255.0'
// Multiple CIDRs are separated by commas, like '192.168.0.1/16,192.172.16.18.0/24'
function ipv4_netmask_filter($addresses, $cidrs)
{
    if (!is_array($cidrs)) {
        $cidrs = explode(',', $cidrs);
    }
    $filtered_addresses = array();
    for ($i = 0; $i < count($cidrs); $i++) {
        $cidr = trim($cidrs[$i]);
        $cidr = explode('/', $cidr);
        // To get the low address, shift off all of the 'unused' bits, shift them back on as zeroes
        $low_address = ip2long($cidr[0]) >> (32 - $cidr[1]) << (32 - $cidr[1]);

        // Do each operation left-to-right:
        // To get the high address, shift off the lowest bits, add 1 to get the 'upper bound plus one', 
        // shift zeroes back on, then subtract 1 to get the inclusive upper bound. 
        $high_address = (((ip2long($cidr[0]) >> (32 - $cidr[1])) + 1) << (32 - $cidr[1])) - 1;

        for ($j = 0; $j < count($addresses); $j++) {
            $test_ip = ip2long($addresses[$j]);
            if ($test_ip && $test_ip >= $low_address && $test_ip <= $high_address) {
                $filtered_addresses[] = $addresses[$j];
            }
        }
    }

    return array_unique($filtered_addresses);
}