<?php

define('EXPORT_PDF', 'pdf');
define('EXPORT_JPG', 'jpg');

function get_reporting_command($dashboard_id, $query_args, $filetype = EXPORT_PDF, $print_page = true, &$file_location = null,  &$filename = null, $use_api = null)
{
    $ci =& get_instance();
    $ci->load->model('Cmdsubsys');
    // Set filename to report if it doesn't exist
    if ($filename === null) {
        $filename = 'report-' . time();
    }

    $query_args['export'] = 'getreport';

    $scheme = (!empty($_SERVER['HTTPS'])) ? 'https' : 'http';
    $url = $scheme . "://localhost/nagioslogserver/reports/view/$dashboard_id";
    if ($use_api) {
        $url = $scheme . "://localhost/nagioslogserver/api/report/run/$dashboard_id";
    }
    $uri = $url . '?' . report_args_to_uri($query_args);

    $disposition = 'inline';
    $bin = 'HOME=/home/nagios google-chrome-stable --headless --enable-low-end-device-mode --ignore-certificate-errors --disable-gpu --no-sandbox --virtual-time-budget=10000 --run-all-compositor-stages-before-draw';

    // Do specifics for each type of report
    switch ($filetype)
    {
        case EXPORT_PDF:
            $filename .= ".pdf";
            $opts = " --no-pdf-header-footer --window-size=1280,720 --print-to-pdf=\"/home/nagios/" . $filename . "\" ";
            $mime = 'application/' . $filetype;
            break;
        case EXPORT_JPG:
            $filename .= ".jpg";
            $opts = " --hide-scrollbars --window-size=1280,1696  --screenshot=\"/home/nagios/" . $filename . "\" ";
            $mime = 'application/' . $filetype;
            break;
        default:
            die(_('ERROR: Could not export report as ') . $filetype . '. ' . _('This type is not defined.'));
    }

    $file_location = '/usr/local/nagioslogserver/tmp/';
    $tmp_file = $file_location . $filename;
    $log = '/usr/local/nagioslogserver/var/chromium_report.log';

    // Run the report generating command
    $bash_cmd = $bin . $opts . "\"" . $uri . "\"";

    if (file_exists($log) && is_writable($log)) {
        file_put_contents($log, "[".date(DATE_RFC2822)."] {$bash_cmd}\n", FILE_APPEND);
        $bash_cmd .= " &>> $log"; // This will not work with snap chromium on ubuntu
    }

    // Snap chromium only allows writing to home directory, so we gotta mv it to the tmp folder
    $bash_cmd .= " && mv /home/nagios/" . $filename . " " . $tmp_file . " && echo " . $filename;

    // Have to do this weirdness because the shell command doesn't do && in the right order
    $cmd = "/bin/bash -c '" . $bash_cmd . "'";

    // Schedule report generation job
    $args = array('cmd' => $cmd);
    $data = array(
        "command" => 'do_report_generation',
        "node" => 'global',
        "args" => $args,
    );
    $ci->Cmdsubsys->create($data, false, 'report_generation');

    if ($print_page) {
        $count = 0;
        while ($count < 20) {
            if (file_exists($tmp_file)) {
                break;
            }
            else {
                sleep(2);
                $count++;
            }
        }

        if (!file_exists($tmp_file)) {
            echo '<div style="margin: 7% auto; max-width: 80%; text-align: center; font-family: verdana, arial; font-size: 1rem; word-wrap: break-word;">';
            echo '<div><strong>' . _('Failed to create ') . '<span style="text-transform: uppercase;">' . $filetype . '</span></strong></div>';
            echo '<div style="margin: 10px 0 30px 0;">' . _('Verify that your Nagios Log server can connect to the URL') . ':</div>';
            echo '<div style="font-size: 0.7rem;">' . $uri . '</div>';
            echo '</div>';
            die();
        } else {
            header('Content-type: ' . $mime);
            header('Content-Disposition: ' . $disposition . '; filename="' . $filename . '"');
            readfile($tmp_file);
            unlink($tmp_file);
        }
    }
}

// Encode associative array as a HTTP GET query string
function report_args_to_uri($args)
{
    $ret = '';
    foreach ($args as $key => $value) {
        $ret .= "&" . rawurlencode($key) . '=' . rawurlencode($value);
    }

    return $ret;
}

// Invert report_args_to_uri
function report_uri_to_args($uri)
{
    $ret = array();
    $uri = explode('&', $uri);
    foreach ($uri as $pair) {
        $pair = explode('=', $pair);
        $val = '';
        if (isset($pair[1])) {
            $val = rawurldecode($pair[1]);
        }
        $ret[rawurldecode($pair[0])] = $val;
    }

    return $ret;
}

// Function for preparing and displaying the dashboard reports
function reporting_run_dashboard($dashboard_id)
{
    $ci =& get_instance();
    $ci->load->helper('alert_helper');

    $css = array('/css/dashboard.css', '/../css/animate.min.css', '/../css/timepicker.css');
    $tab = (isset($ci->page)) ? $ci->page : '';
    $ci->init_page(_("Report"), $tab, array(), $css);

    $export = $ci->input->post_get('export');
    $email = $ci->session->userdata('email');
    $scheduled_reports = (property_exists($ci, 'scheduled_reports') ? $ci->scheduled_reports : array());
    $dashboard_reports = (property_exists($ci, 'dashboard_reports') ? $ci->dashboard_reports : array());
    $default_reports = (property_exists($ci, 'default_reports') ? $ci->default_reports : array());

    if ($export) { // If we're exporting we don't want to show any of this
        $ci->data['leftbar'] = $ci->load->view('reports/export', array(), true);
        $ci->data['report_options'] = '';
        $ci->data['schedule_modal'] = '';
    } else {
        $ci->data['leftbar'] = $ci->load->view('reports/leftbar', array('scheduled_reports' => $scheduled_reports, 'dashboard_reports' => $dashboard_reports, 'default_reports' => $default_reports), true);
        $ci->data['report_options'] = $ci->load->view('reports/report_options', array(), true);
        $ci->data['schedule_modal'] = $ci->load->view('reports/schedule', array('email' => $email), true);
    }
    $ci->data['dashboard'] = $ci->load->view('dashboard', array(), true);
    $ci->data['dashboard_id'] = $dashboard_id;

    /* grab api key for whatever headless webkit thing we're using now */
    $admin = $ci->elasticsearch->get('user', 1);
    $query_args = array_merge($ci->input->post(), $ci->input->get());
    $query_args['token'] = $admin['_source']['apikey'];

    # Get the user's language. If it's different from system language, force the report to be in that language.
    $user_language = $ci->session->userdata('language');
    if (!empty($user_language) && $user_language != 'default' && !array_key_exists('force_language', $query_args)) {
        $query_args['force_language'] = $user_language;
    }

    if (!in_array($export, array(EXPORT_PDF, EXPORT_JPG))) {
        $ci->load->view('reports/dashboard_report', $ci->data);
        return;
    }
    get_reporting_command($dashboard_id, $query_args, $export);
}