<?php echo $header; 

$ci =& get_instance();
$ci->load->helper('auditlog');

foreach ($logs as $index => $log) {
    if (isset($log['_source']['actions']) && json_decode($log['_source']['actions']) !== null) {
        $logs[$index]['_source']['actions'] = rerun_query_link(json_decode($log['_source']['actions'], true));
    }
}
?>

<script type="text/javascript">
$(document).ready(function() {

    update_datetimepicker();
    $('input.date-picker').datetimepicker();

    $('select[name="time"]').change(function() {
        update_datetimepicker();
    });

    $('div.show-arguments-link').click(function() {
        $(this).css('display', 'none');
        $(this).siblings('div.hide-arguments-link').css('display', 'inline');
        $(this).siblings('div.arguments-data').show();
    });

    $('div.hide-arguments-link').click(function() {
        $(this).siblings('div.show-arguments-link').css('display', 'inline');
        $(this).css('display', 'none');
        $(this).siblings('div.arguments-data').hide();
    });

    $('#trim-audit-log').click(function(e) {
        e.preventDefault();
        $.post(site_url+'api/system/trim_history', { type: 'audit' }, function(data) {
            data = JSON.parse(data);
            if (data.error) {
                alert(data.error);
            } else if (data.curl_response) {
                var response = JSON.parse(data.curl_response);
                if (response._indices.nagioslogserver_log._shards.failed == 0) {
                    alert('Trimmed Alert History to remove entries older than ' + data.days_to_trim + ' days.');
                }
            }
        });
    });
});

function update_datetimepicker() {
    if ($('.time-select').val() == 'c') {
        $('.date-picker').show();
    } else {
        $('.date-picker').hide();
    }
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="well report-header">
            <?php echo form_open('admin/audit-log', array('class' => 'form-inline', 'method' => 'get')); ?>
                <h1 class="fl"><?php echo _("Audit Log"); ?></h1>
                <div class="fl">
                    <div class="input-group">
                        <div class="input-group-addon"><?php echo _('Time Frame'); ?></div>
                        <select class="form-control time-select" name="time">
                            <option value="24h"<?php if ($time == '24h' || $time == '') { echo ' selected'; } ?>><?php echo _('Last 24 Hours'); ?></option>
                            <option value="7d"<?php if ($time == '7d') { echo ' selected'; } ?>><?php echo _('Last 7 Days'); ?></option>
                            <option value="30d"<?php if ($time == '30d') { echo ' selected'; } ?>><?php echo _('Last 30 Days'); ?></option>
                            <option value="c"<?php if ($time == 'c') { echo ' selected'; } ?>><?php echo _('Custom'); ?></option>
                        </select>
                        <div class="input-group-addon date-picker"><?php echo _('From'); ?></div>
                        <input type="text" name="start" class="form-control date-picker" value="<?php if (!empty($start)) { echo $start; } ?>">
                        <div class="input-group-addon date-picker"><?php echo _('to'); ?></div>
                        <input type="text" name="end" class="form-control date-picker" value="<?php if (!empty($end)) { echo $end; } ?>">
                    </div>
                    <div class="input-group">
                        <div class="input-group-addon"><?php echo _('Type'); ?></div>
                        <select class="form-control" name="type">
                            <option value=""><?php echo _('All'); ?></option>
                            <option value="JOBS"<?php if ($type == 'JOBS') { echo ' selected'; } ?>><?php echo _('JOBS'); ?></option>
                            <option value="ALERT"<?php if ($type == 'ALERT') { echo ' selected'; } ?>><?php echo _('ALERT'); ?></option>
                            <option value="INFO"<?php if ($type == 'INFO') { echo ' selected'; } ?>><?php echo _('INFO'); ?></option>
                            <option value="SECURITY"<?php if ($type == 'SECURITY') { echo ' selected'; } ?>><?php echo _('SECURITY'); ?></option>
                            <option value="CONFIG"<?php if ($type == 'CONFIG') { echo ' selected'; } ?>><?php echo _('CONFIG'); ?></option>
                            <option value="MAINTENANCE"<?php if ($type == 'MAINTENANCE') { echo ' selected'; } ?>><?php echo _('MAINTENANCE'); ?></option>
                            <option value="POLLER"<?php if ($type == 'POLLER') { echo ' selected'; } ?>><?php echo _('POLLER'); ?></option>
                            <option value="BACKUP"<?php if ($type == 'BACKUP') { echo ' selected'; } ?>><?php echo _('BACKUP'); ?></option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-sm btn-default"><i class="fa fa-filter fa-l"></i> <?php echo _('Filter'); ?></button>
                    <button id="trim-audit-log" class="btn btn-sm btn-default"><i class="fa fa-scissors fa-l"></i> <?php echo _('Trim Audit Log'); ?></button>
                </div>
                <div class="fr">
                    <input type="text" name="search" class="form-control" value="<?php echo $search; ?>" placeholder="<?php echo _("Search message..."); ?>">
                </div>
            <?php echo form_close(); ?>
            <div class="clear"></div>
        </div>

        <div class="table-bar">
            <?php
            if (!empty($record_total)) {
                echo '<span style="display: inline-block;">' . _('Page') . ' ' . $page . ' of ' . $total_pages . ' &nbsp;&middot;&nbsp; ';
                if (!empty($limiting)) {
                    echo $limiting . ' (' .  number_format($record_total) .  ' ' . _('total records') . ')';
                } else {
                    echo number_format($record_total) .  ' ' . _('records');
                }
                echo '</span>';
            } else {
                echo '<span style="display: inline-block;">0 ' . _(' records') . '</span>';
            }
            ?>
            <div class="page-numbers fr">
                <?php echo $pagination; ?>
            </div>
            <div class="clear"></div>
        </div>

        <table class="table table-striped table-condensed table-bordered">
            <thead>
                <tr>
                    <th><?php echo _('Created By'); ?></th>
                    <th><?php echo _('Type'); ?></th>
                    <th style="width: 220px;"><?php echo _('Created At'); ?></th>
                    <th><?php echo _('Message'); ?></th>
                    <th><?php echo _('Instance ID'); ?></th>
                    <th><?php echo _('Source'); ?></th>
                    <th style="width: 110px;"><?php echo _('Actions'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (count($logs) > 0) {
                    foreach ($logs as $log) {
                ?>
                <tr>
                    <td><?php echo htmlentities($log['_source']['created_by'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo $log['_source']['type']; ?></td>
                    <td><?php echo date('r', ($log['_source']['created'] / 1000)); ?></td>
                    <td><?php echo $log['_source']['message']; ?></td>
                    <td><?php if (@isset($log['_source']['node'])) { echo $log['_source']['node']; } ?></td>
                    <td><?php echo $log['_source']['source']; ?></td>
                    <td><?php if (@isset($log['_source']['actions'])) { echo $log['_source']['actions']; } ?></td>
                </tr>
                <?php
                    }
                } else {
                ?>
                <tr>
                    <td colspan="7"><?php echo _("No logs matched your filters."); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <div class="table-bar">
            <?php
            $url = (!empty($_SERVER['QUERY_STRING'])) ? 'admin/audit-log?' . htmlentities($_SERVER['QUERY_STRING'], ENT_COMPAT, 'UTF-8') : 'admin/audit-log';
            echo form_open($url, array('class' => 'pp-form'));
            ?>
            <input type="hidden" name="pp" class="pp" value="<?php echo intval($page_size); ?>">
            <?php echo form_close(); ?>
            <div class="fl form-inline" style="margin-right: 4px;">
                <div class="input-group">
                    <label class="input-group-addon"><?php echo _('Results per page'); ?></label>
                    <select class="form-control results-per-page">
                        <option value="10"<?php if ($page_size == 10) { echo ' selected'; } ?>>10</option>
                        <option value="25"<?php if ($page_size == 25) { echo ' selected'; } ?>>25</option>
                        <option value="50"<?php if ($page_size == 50) { echo ' selected'; } ?>>50</option>
                        <option value="100"<?php if ($page_size == 100) { echo ' selected'; } ?>>100</option>
                        <option value="c"><?php echo _("Custom"); ?></option>
                        <?php if (!in_array($page_size, array(10, 25, 50, 100))) { echo '<option value="' . $page_size . '" selected>' . _('Custom') . ' - ' . $page_size . '</option>'; } ?>
                    </select>
                </div>
            </div>
            <div class="fl custom-box">
                <label>
                <input type="text" class="form-control custom" placeholder="#" value="">
                <button type="button" class="btn btn-sm btn-default save-custom"><?php echo _("Save"); ?></button>
                </label>
            </div>
            <div class="page-numbers fr">
                <?php echo $pagination; ?>
            </div>
            <div class="clear"></div>
        </div>

    </div>
</div>

<?php echo $footer; ?>