<?php echo $header; ?>

<script>
    var other_hosts = <?php echo json_encode($addresses); ?>;
    $(document).ready(function() {

        $('.upload-button').click(function() {
            $('.real-upload').click();
        });

        $('.real-upload').change(function() {
            var file_input = $('.real-upload')[0];
            var filename = file_input.files.item(0).name;
            $('.upload-filename').val(filename);
        });

        $('.add-certificate').click(function() {
            $('#add-certificate-modal').modal('show');
        });

        // Popup the window to load in a certificate
        $("#add-certificate-modal").on("paste", "textarea.ajax-validated", function(e) {
            $(".ca-error").addClass('hide');
            $('textarea.ajax-validated').removeClass('form-error');
            var elem = $(this);
            setTimeout(function() {

                var cert = elem.val();
                $.post(site_url + "api/LDAP/add_certificate", { cert: cert, verify: true }, function(data) {

                    if (data.error) {
                        $(".ca-error").html(data.message).removeClass('hide');
                        $('textarea.ajax-validated').addClass('form-error');
                        $('.btn-primary.raw-input').attr('disabled', 'disabled');
                    }
                    else {
                        $(".ca-host").attr('disabled', false).val(data.CN);
                        $('.btn-primary.raw-input').attr('disabled', false);
                    }
                }, "json");
            }, 200);
        });

        // Actually add the certificate when clicking the button
        $(".btn-primary.raw-input").on("click", function(e) {
            $(".ca-error").addClass('hide');
            $('textarea.ajax-validated').removeClass('form-error');

            var cert = $("textarea.ajax-validated").val();
            var protocol = window.location.protocol;

            $.post(site_url + 'api/LDAP/add_certificate', { cert: cert }, function(data) {

                if (data.error) {
                    alert(data.message);
                } else {

                    setTimeout(function () {
                        load_certificates();
                    }, 200);
                }

                $('.btn-primary.raw-input').attr('disabled', true);
                $('.ca-host').val('').attr('disabled', true);
                $('textarea.ajax-validated').val('').removeClass('form-error');
            }, "json");

            for (i in other_hosts) {
                var address = other_hosts[i];
                var url = protocol + '//'+address+"/nagioslogserver/api/LDAP/add_certificate";

                $.post(url, { cert: cert, fs_only: true, token: '<?php echo $apikey; ?>' }, function(data) {
                    if (data.error) {
                        alert(data.message);
                    }
                }, "json");
            }
        });

        load_certificates();
    });

function load_certificates() {
    $.post(site_url + 'api/LDAP/get_certificates', function(certs) {
        certs = JSON.parse(certs);
        if (certs === false) {
            return;
        }

        var table_text = '';
        for (ind in certs) {
            table_text += '<tr><td>' + certs[ind]['subject_CN'] + '</td><td>' + certs[ind]['issuer_CN'] + '</td><td>' + new Date(certs[ind]['validto'] * 1000) + '</td><td><a><i class="fa fa-times remove-certificate" data-id="' + ind + '" ></i></button></a></td></tr>';
        }

        if (table_text === '') {
            table_text = '<tr><td colspan="4"><?php echo _("No certificates have been added.");?></td></tr>';
        }
        $('.certificates-go-here').html(table_text);

        $('.remove-certificate').off('click');
        $('.remove-certificate').on('click', function() {

            var id = $(this).data('id');

            var conf = confirm('<?php echo _("Are you sure you want to delete this certificate?");?>');
            if (!conf) {
                return;
            }

            $.post(site_url + 'api/LDAP/remove_certificate', {id: id}, function(ret_bool) {

                if (!ret_bool) {
                    alert("Failed to remove certificate.");
                }

                load_certificates();

            }, 'json');

            for (i in other_hosts) {
                var address = other_hosts[i];
                var protocol = window.location.protocol;
                var url = protocol + '//'+address+"/nagioslogserver/api/LDAP/remove_certificate";

                $.post(url, { id: id, fs_only: true, token: '<?php echo $apikey; ?>' }, function(data) {
                    if (data.error) {
                        alert(data.message);
                    }
                }, "json");
            }
        });
    }, 'json');
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('LDAP / AD Integration'); ?></h1>
        <p><?php echo _('Manage authentication servers can be used to authenticate users against during login. Once a server has been added you can'); ?> <a href="<?php echo site_url('admin/users/import'); ?>"><?php echo _('import users'); ?></a>.</p>
        <p style="margin-bottom: 10px;"><a href="<?php echo site_url('admin/add_auth_server'); ?>" class="btn btn-sm btn-default"><i class="fa fa-plus"></i> <?php echo _('Add Server'); ?></a></p>

        <?php if (!empty($message)) { ?>
        <div class="alert alert-info" style="margin-bottom: 15px;"><?php echo $message; ?><a href="#" class="close" data-dismiss="alert">&times;</a></div>
        <?php } ?>

        <table class="table table-striped table-hover table-condensed table-bordered table-va-middle" style="width: auto; min-width: 60%;">
            <thead>
                <tr>
                    <th style="width: 20px; text-align: center;"></th>
                    <th><?php echo _('Name'); ?></th>
                    <th><?php echo _('Servers'); ?></th>
                    <th style="width: 140px;"><?php echo _('Type'); ?></th>
                    <th style="width: 80px;"><?php echo _('Encryption'); ?></th>
                    <th style="width: 130px;"><?php echo _('Associated Users'); ?></th>
                    <th style="width: 80px; text-align: center;"><?php echo _('Actions'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (count($servers) > 0) {
                    foreach ($servers as $server) {
                ?>
                <tr>
                    <td style="text-align: center;"><?php if ($server['active'] == 1) { echo '<img src="'.base_url('media/icons/accept.png').'" title="'._('Enabled').'">'; } ?></td>
                    <td><?php echo html_escape($server['name']); ?></td>
                    <td><?php if ($server['type'] == "ad") { echo $server['controllers']; } else { echo html_escape($server['host']); } ?></td>
                    <td><?php if ($server['type'] == "ad") { echo _('Active Directory'); } else if ($server['type'] == "ldap") { echo 'LDAP'; } ?></td>
                    <td><?php if ($server['encryption'] == 'tls') { echo 'STARTTLS'; } else if ($server['encryption'] == 'ssl') { echo 'SSL/TLS'; } else { echo _('None'); } ?></td>
                    <td><?php echo $server['associated_users']; ?></td>
                    <td style="font-size: 18px; text-align: center;">
                        <a href="<?php echo site_url('admin/edit_auth_server/'.$server['id']); ?>" title="<?php echo _('Edit'); ?>"><i class="fa fa-wrench"></i></a>
                        <?php if ($server['associated_users'] == 0) { ?><a href="<?php echo site_url('admin/delete_auth_server/'.$server['id']); ?>" title="<?php echo _('Remove server'); ?>" style="margin-left: 10px;"><i class="fa fa-times"></i></a><?php } ?>
                    </td>
                </tr>
                <?php
                    }
                } else {
                ?>
                <tr>
                    <td colspan="7"><?php echo _('No LDAP/AD auth servers have been added.'); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        <br>
        <h5><?php echo _("Certificate Authority Management");?></h5>

        <p><?php echo _('If you are using self-signed certificates to connect over SSL/TLS, you will need to add the domain controllers\' certificates to the local certificate authority.'); ?></a></p>
        <p style="margin-bottom: 10px;"><a class="btn btn-sm btn-default add-certificate"><i class="fa fa-plus"></i> <?php echo _('Add Certificate'); ?></a></p>
        <table class="table table-striped table-hover table-condensed table-bordered table-va-middle" style="width: auto; min-width: 60%;">
            <thead>
                <tr>
                    <th><?php echo _('Hostname'); ?></th>
                    <th><?php echo _('Issuer (CA)'); ?></th>
                    <th><?php echo _('Expiration Date'); ?></th>
                    <th style="width: 80px; text-align: center;"><?php echo _('Actions'); ?></th>
                </tr>
            </thead>
            <tbody class="certificates-go-here">
                <tr>
                    <td colspan="4"><?php echo _("No certificates have been added.");?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<div class="modal hide" id="add-certificate-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _('Add SSL/TLS Certificate'); ?>: <span class="snapshot-time"></span></h2>
            </div>
            <div class="modal-body">
                <div class="raw-input input-group" style="width: 100%;">
                    <!-- &#10; is the newline HTML entity-->
                    <div class="form-horizontal" style="padding: 19px 19px 19px 19px;">
                        <div class="form-group">
                            <input class="form-control ca-host" style="width: 300px" type="text" value="" placeholder="<?php echo _("Hostname");?>" disabled>
                        </div>
                        <div class="form-group">
                            <textarea class="form-control ajax-validated" placeholder="-----BEGIN CERTIFICATE-----
MIIEBTCCAu2gAwIBAgIJANowY9Rn/C5NMA0GCSqGSIb3DQEBCwUAMIGYMQswCQYD
VQQGEwJVUzESMBAGA1UECAwJTWlubmVzb3RhMRAwDgYDVQQHDAdTdCBQYXVsMSAw
HgYDVQQKDBdOYWdpb3MgRW50ZXJwcmlzZXMsIExMQzEQMA4GA1UECwwHRXhhbXBs
ZTEQMA4GA1UEAwwHRXhhbXBsZTEdMBsGCSqGSIb3DQEJARYOcm9vdEBsb2NhbGhv
c3QwHhcNMTgxMDE3MjE0NzEwWhcNMTkxMDE3MjE0NzEwWjCBmDELMAkGA1UEBhMC
VVMxEjAQBgNVBAgMCU1pbm5lc290YTEQMA4GA1UEBwwHU3QgUGF1bDEgMB4GA1UE
CgwXTmFnaW9zIEVudGVycHJpc2VzLCBMTEMxEDAOBgNVBAsMB0V4YW1wbGUxEDAO
BgNVBAMMB0V4YW1wbGUxHTAbBgkqhkiG9w0BCQEWDnJvb3RAbG9jYWxob3N0MIIB
IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAreyxG8ijn8nNw145oCV2Lll9
YJ0rVdWN+U1T3kneDL8vF6RZ03GqkmsyUVjpKLevSXFIqUWz/4i1uMbLguxtugmq
AkAjyN3qPZthi5Wu20RjS+7h6EaOzd1Pzf6jYQsJqhzSHRJyiDHExzsGJK43jRAM
3Q8MQkYibKzPlpj03sBIaodzOVzKRZ+M/Ct0UaWDYueVeNF9yigrrhsziGmDUCIi
92oBiMp7SmzDGKxwFzIiBtwgwst1RQ773rl9ixbxFwZzeoJcEXeFXnIlliWy+NDU
QZUKtowzE2k6jxBWSHci1sopuCO5rD6UiCT5AO58RWKrMFaDKglctU5LTugN/QID
AQABo1AwTjAdBgNVHQ4EFgQUDsbFCsJBTfonQSRO091BIWJvXvwwHwYDVR0jBBgw
FoAUDsbFCsJBTfonQSRO091BIWJvXvwwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B
AQsFAAOCAQEALuVIr1J9oRSVSi/a9MkbRrT2c2R+o87cOUqogO+rlTKi41+qVOxr
rN7qhzxWmKRD3EdpnfwE45a7ik72leL+xLdqYTHMKYjw6e7YTXn4ixEeMjXHLV3j
pM0ddovvw5OPO0gDRCAhefMSZNIol3eho7boNGkiH7MidwhtYS8dskQO2zWYsrc7
SxecPLpEZHBXrB2mXWUWAl/wenV25o/Ik2UweYBr1xZgC2FdJiOyrl5QruRDdh+0
CWySyD2S3EZy+KU/XjgZRUJa3mFFrUeDnpbRbt0RJKo+NTbn2OdqYccecjtXNxxg
SFwVPNgmI7/jwns014NlTSsV31GOxVGqnQ==
-----END CERTIFICATE-----" style="height: 300px; resize: vertical; font-family: monospace; font-size:15px"></textarea>
                        <span class="ca-error hide" style="color: red; font-weight: bold; border-top: 10px;"><?php echo _('Certificate is invalid'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
                <button class="btn btn-sm btn-primary raw-input" data-dismiss="modal" aria-hidden="true" disabled><?php echo _('Submit'); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>