<?php echo $header; ?>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">
        <h1 style="margin-bottom: 10px;">
            <?php echo _('Cluster Status'); ?>
            <div class="input-group fr" style="width: 470px;">
                <span class="input-group-addon"><i class="fa fa-fw fa-cubes"></i> <b><?php echo _('Cluster ID'); ?></b></span>
                <input type="text" class="form-control text-center select-all" name="cluster_id" value="<?php echo $cluster['health']['cluster_name']; ?>" readonly>
            </div>
            <div class="clear"></div>
        </h1>

        <div class="container-fluid" id="workspace">
            <div class="alert alert-info hide" id="indices_opening" style="margin: 0 -5px 10px -5px "><?php echo sprintf(_('Some indices are still opening. %1$s of %2$s remaining'), '<div id="indices_opening_remaining" style="display: inline"></div>', '<div id="indices_opening_total" style="display: inline"></div>');?>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-bar-chart"></i></div>
                                <span><?php echo _("Cluster Statistics"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="container-fluid" style="padding: 20px 25px 0 25px;">
                            <div class="row">
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo number_format($cluster['stats']['indices']['docs']['count']); ?></span><span><?php echo _("Documents"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></span><span><?php echo _("Primary Size"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></span><span><?php echo _("Total Size"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo $cluster['health']['number_of_data_nodes']; ?></span><span><?php echo _("Data Instances"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo $index['stats']['_shards']['total']; ?></span><span><?php echo _("Total Shards"); ?></span></div>
                                </div>
                                <div class="col-sm-12 col-lg-6 stat-box-wrap">
                                    <div class="well stat-box"><span class="stat-detail"><?php echo $cluster['stats']['indices']['count']; ?></span><span><?php echo _("Indices"); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-sitemap"></i></div>
                                <span><?php echo _("Cluster Health"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-striped table-hover table-bordered center-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 150px;"><?php echo _("Status"); ?></td>
                                        <td><span style="font-size: 11px;" class="label <?php echo $status_label; ?>"><?php echo ucfirst($cluster['health']['status']); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Timed Out?"); ?></td>
                                        <td><?php echo ($cluster['health']['timed_out']) ? 'true' : 'false'; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("# Instances"); ?></td>
                                        <td><?php echo $cluster['health']['number_of_nodes']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("# Data Instances"); ?></td>
                                        <td><?php echo $cluster['health']['number_of_data_nodes']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Active Primary Shards"); ?></td>
                                        <td><?php echo $cluster['health']['active_primary_shards']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Active Shards"); ?></td>
                                        <td><?php echo $cluster['health']['active_shards']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Relocating Shards"); ?></td>
                                        <td><?php echo $cluster['health']['relocating_shards']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Initializing Shards"); ?></td>
                                        <td><?php echo $cluster['health']['initializing_shards']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Unassigned Shards"); ?></td>
                                        <td><?php echo $cluster['health']['unassigned_shards']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php echo $indices_table; ?>
            </div>
        </div>

    </div>
</div>

<?php echo $footer; ?>