<?php echo $header; 

/* This was going to be kind of elegant code but then the data structure wasn't very regular... 
 * The permissions array looks like this:
 *
 * Array
 * (
 *     [alerts] => Array
 *         (
 *             [0] => view
 *             [1] => create
 *         )
 *     [contacts] => Array
 *         (
 *             [0] => all
 *         )
 * )
 *
 * Kind of terrible.
 */
function safe_permission_set($perms, $type, $permission) {

    if (!isset($perms) || !is_array($perms)) {
        return false;
    }

    if (!isset($perms[$type]) || !is_array($perms[$type])) {
        return false;
    }

    if (!in_array($permission, $perms[$type])) {
        return false;
    }

    return true;
}

?>

<script type="text/javascript">
$(document).ready(function() {

    show_correct_fields();

    check_non_admin('alerts');
    check_non_admin('contacts');
    check_non_admin('config');

    check_required('.alerts');
    check_required('.contacts');
    check_required('.config');

    $('#account_type').change(function() {
        show_correct_fields();
    });

    $('input[name="auth_type"]').change(function() {
        var type = $(this).val();
        if (type == 'user') {
            $('.user-perms').show();
        } else {
            $('.user-perms').hide();
        }
    });

    // Toggle all perms or not in the row
    $('.toggle').click(function() {

        var section = $(this).data('section');

        if ($('#' + section + '-admin').is(":checked")) {
            $('.' + section).prop('disabled', false)
                            .prop('checked', false);
        } 
        else {
            $('#' + section + '-admin').prop('checked', true);
            $('.' + section).not('#' + section + '-admin')
                            .prop('checked', true)
                            .prop('disabled', true);
        }

        check_required('.config');
        check_required('.contacts');
        check_required('.alerts');
    });

    // If set to alert admin, turn off other checkboxes
    admin_button('alerts');
    admin_button('contacts');

    // If create, edit, or delete selected... must have view
    $('.alerts').click(function () { check_required('.alerts'); });
    $('.contacts').click(function () { check_required('.contacts'); });
    $('.config').click(function () { check_required('.config'); });

    // When a "Known Hosts" item is selected, paste it into the Additional Hosts textarea (unless it's already there)
    $('#host-list-known-hosts').change(function(e) {

        // Build the regex:
        // To match an entry like '192.168.0.1', we want a regexp like '/^192\.168\.0\.1$/m'
        // Get the IP Address that was just selected
        var addr = e.target.value;

        // Replace all periods '.' with the escaped periods '\.'
        var addr_escaped = addr.replace(/\./g, '\\.');

        // Match any line exactly matching the IP Address
        var match_regexp = new RegExp('^' + addr_escaped + '$', 'm');

        // If the IP Address is already present, do nothing
        var current_text = $('#host-list-selected-hosts').val();
        if (!current_text.match(match_regexp)) {

            // Insert a newline only if we need to
            var last_character = current_text[current_text.length-1];
            if ((typeof last_character !== 'undefined') && last_character !== '\n') {
                $('#host-list-selected-hosts')[0].value += "\n";
            }

            // Finally, insert the IP address into the textarea.
            $('#host-list-selected-hosts')[0].value += addr;
        }
    });

    // Move selcted elements from 'Host Lists' to 'Selected Host Lists', and add hidden form elements to match
    $('#add-to-selected-hosts').click( function() {
        var new_hosts = $('#all-host-lists').children(':selected');
        var old_hosts = $('#selected-host-lists').children();
        var new_host;
        var matching_sentinel;

        for (var i = 0; i < new_hosts.length; i++) {
            new_host = new_hosts[i];

            matching_sentinel = false;

            // Verify that the host is not already in the Selected Host Lists table
            for (var j = 0; j < old_hosts.length; j++) {

                if (old_hosts[j].value === new_host.value) {
                    matching_sentinel = true;
                    break;
                }
            }

            if (matching_sentinel) {
                continue;
            }
            // Otherwise, add it to the table.
            $('#selected-host-lists').append(new_host);
            // Also create a hidden input so that the selected host is passed to POST.
            $('#insert-selected-host-lists-here').append('<input type="hidden" class="host-list-hidden" id="selected-host-list-'+$(new_host).val()+'" name="host_lists[]" value="'+$(new_host).val()+'">');
        }
    });

    // Move selected elements from Selected Host Lists to Host Lists, remove any relevant hidden form elements
    $('#remove-from-selected-hosts').click(function() {
        var hosts_to_remove = $('#selected-host-lists').children(':selected');

        hosts_to_remove.each(function() {

            // Remove the hidden input associated with the selected host list from the DOM.
            $('#selected-host-list-'+$(this).val()).remove();
            // Remove the entry from the selected host lists table.
            $('#all-host-lists').append($(this));
        });
    });

});

function check_required(obj)
{
    if ($(obj + ':checked').not(obj + '-req').length > 0) {
        $(obj + '-req').prop('checked', true);
        $(obj + '-req').prop('disabled', true);
    } else {
        $(obj + '-req').prop('disabled', false);
    }
}

function check_non_admin(obj)
{
    var admin_id = '#'+obj+'-admin';
    if ($(admin_id + ":checked").length > 0) {
        $('.'+obj).not(admin_id).prop('checked', true);
        $('.'+obj).not(admin_id).prop('disabled', true);
    } else {
        $('.'+obj).not(admin_id).prop('disabled', false);
    }
}

/* This function is only needed when a permissions row has more than just "View" and "Admin" boxes */
function admin_button(obj) {
    var admin_id = '#'+obj+'-admin';
    $(admin_id).click(function() {
        if ($(this).is(":checked")) {
            $(this).parents('tr').find('input').prop('checked', true);
            $(this).parents('tr').find('input').not(admin_id).prop('disabled', true);
        } else {
            $(this).parents('tr').find('input').not(admin_id).prop('disabled', false);
            $('.'+obj+'-req').prop('disabled', true);
        }
    });
};

function show_correct_fields()
{
    var type = $('#account_type').val();

    if (type == "ldap") {
        $('.ad-required').hide();
        $('.ldap-required').show();
        $('.pw-box').hide();
    } else if (type == "ad") {
        $('.ldap-required').hide();
        $('.ad-required').show();
        $('.pw-box').hide();
    } else {
        $('.ldap-required').hide();
        $('.ad-required').hide();
        $('.pw-box').show();
    }
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('Create User');?></h1>

        <p><?php echo _('Please enter all fields of the new users information below. Starred fields are required');?></p>
        <?php if (!empty($error)) { ?><div class="alert alert-danger" style="margin: 10px 0 20px 0;"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/users/create');?>
        <input type="hidden" name="hash" value="">

        <ul class="nav nav-tabs" style="margin-top: 10px;">
            <li class="active"><a href="#details" role="tab" data-toggle="tab"><i class="fa fa-user"></i> <?php echo _('Details'); ?></a></li>
            <li><a href="#authentication" role="tab" data-toggle="tab"><i class="fa fa-key"></i> <?php echo _('External Authentication'); ?></a></li>
            <li><a href="#permissions" role="tab" data-toggle="tab"><i class="fa fa-lock"></i> <?php echo _('Permissions'); ?></a></li>
        </ul>
     
        <div class="tab-content">

            <div role="tabpanel" class="tab-pane active" id="details">
                <h5><?php echo _('User Details'); ?></h5>
                <div class="form-horizontal under-underline">
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _("Full Name"); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <input type="text" class="form-control" name="name" value="<?php echo set_value('name'); ?>"> *
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _("Email"); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <input type="text" class="form-control" style="width: 260px;" name="email" value="<?php echo set_value('email'); ?>"> *
                        </div>
                    </div>
                </div>
                <h5><?php echo _('Account Information'); ?></h5>
                <div class="form-horizontal under-underline">
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _('Username'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <input type="text" class="form-control" name="username" value="<?php echo set_value('username'); ?>"> *
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _('Password'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <input type="password" class="form-control" name="password" value="<?php echo set_value('password'); ?>"> *
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _('Confirm Password'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <input type="password" class="form-control" name="password2" value="<?php echo set_value('password2'); ?>"> *
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 control-label"><?php echo _('Language'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-lg-9">
                            <select name="language" class="form-control">
                                <option value="default" <?php if (set_value('language') == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                                <?php foreach ($languages as $l) { ?>
                                <option value="<?php echo $l; ?>" <?php if (set_value('language') == $l) { echo 'selected'; } ?>>
                                    <?php echo get_language_name($l); ?>
                                </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="authentication">
                <p style="margin: 20px 0 10px 0;"><?php echo _('User accounts can be authenticated in many different ways either from your local database or external programs such as Active Directory or LDAP. You can set up external authentication servers in the'); ?> <a href="<?php echo site_url('admin/auth_servers'); ?>"><?php echo _('LDAP/AD Integration settings'); ?></a>.</p>
                <div class="form-horizontal under-underline">
                    <div class="form-group">
                        <label class="col-sm-4 col-md-3 col-lg-2 col-xl-1 control-label"><?php echo _('Auth Type'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-xl-6">
                            <select name="account_type" class="form-control" id="account_type">
                                <option value="local"><?php echo _('Local Only (Default)'); ?></option>
                                <option value="ad" <?php if (empty($ad_servers)) { echo "disabled"; } if (@$user['auth_settings']['type'] == "ad") { echo "selected"; } ?>><?php echo _('Active Directory'); ?> <?php if (empty($ad_servers)) { ?>(<?php echo _('No Servers'); ?>)<?php } ?></option>
                                <option value="ldap" <?php if (empty($ldap_servers)) { echo "disabled"; } if (@$user['auth_settings']['type'] == "ldap") { echo "selected"; } ?>><?php echo _('LDAP'); ?> <?php if (empty($ldap_servers)) { ?>(<?php echo _('No Servers'); ?>)<?php } ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group hide ldap-required">
                        <label class="col-sm-4 col-md-3 col-lg-2 col-xl-1 control-label"><?php echo _('LDAP Server'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-xl-6">
                            <select name="ldap_server" class="form-control" id="ldap_server" style="min-width: 340px;">
                                <?php foreach ($ldap_servers as $ldap) { ?>
                                <option value="<?php echo $ldap['id']; ?>"><?php echo $ldap['name'].' ('.$ldap['host'].')'; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group hide ldap-required">
                        <label class="col-sm-4 col-md-3 col-lg-2 col-xl-1 control-label"><?php echo _('User\'s Full DN'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-xl-6">
                            <input type="text" class="form-control" name="dn" <?php echo set_value('dn'); ?> placeholder="cn=John Smith,dn=nagios,dc=com" style="min-width: 280px; width: 75%;">
                        </div>
                    </div>
                    <div class="form-group hide ad-required">
                        <label class="col-sm-4 col-md-3 col-lg-2 col-xl-1 control-label"><?php echo _('AD Server'); ?>:</label>
                        <div class="col-sm-8 col-md-9 col-xl-6">
                            <select name="ad_server" class="form-control" id="ad_server" style="min-width: 340px;">
                                <?php foreach ($ad_servers as $ad) { ?>
                                <option value="<?php echo $ad['id']; ?>"><?php echo $ad['name'].' ('.$ad['controllers'].')'; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group hide ad-required">
                        <label class="col-sm-4 col-md-3 col-lg-2 col-xl-1 control-label"><?php echo _('AD Username'); ?>:</label>
                        <div class="col-sm-8 col-md-6 col-lg-4 col-xl-3">
                            <input type="text" class="form-control" name="ad_username" id="ad_username" <?php echo set_value('ad_username'); ?> style="min-width: 160px;">
                        </div>
                    </div>
                </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="permissions">
                <h5><?php echo _('User Access Level'); ?></h5>
                <p><?php echo _('Set the user level of access inside the UI.'); ?></p>

                <div class="radio">
                    <label>
                        <input type="radio" name="auth_type" value="admin" <?php if ($admin_checked) { echo "checked"; } ?>>
                        <b><?php echo _('Admin'); ?></b> &middot;
                        <?php echo _('Full Access. Admins can change/delete all components and settings including indexes, backups, dashboards, queries, and alerts. They can also update the Nagios Log Server configuration and manage users.'); ?>
                    </label>
                </div>
                <div class="radio">
                    <label>
                        <input type="radio" name="auth_type" value="user" <?php if ($user_checked) { echo "checked"; } ?>>
                        <b><?php echo _('User'); ?></b> &middot;
                        <?php echo _("Limited Access. Users are allowed to only edit their account and their own dashboards by default."); ?>
                    </label>
                </div>

                <div class="user-perms <?php if ($admin_checked) { echo "hide"; } ?>">
                    <h5><?php echo _('User Permissions'); ?></h5>
                    <p><?php echo _('Give users special permissions to access certain tabs. By default, users can only view alerts.'); ?></p>
                    <table class="table table-bordered table-auto-width">
                        <thead>
                            <tr>
                                <th><?php echo _("Permission"); ?></th>
                                <th><?php echo _("View"); ?></th>
                                <th><?php echo _("Create"); ?></th>
                                <th><?php echo _("Edit"); ?></th>
                                <th><?php echo _("Delete"); ?></th>
                                <th><?php echo _("Admin"); ?> <i class="fa fa-question-circle tt-bind" title="<?php echo _("By default, the create, edit, and delete permissions only apply to items the user makes. This setting allows users to manage all items, not just their own."); ?>"></i></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?php echo _("Alerts"); ?></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="alerts alerts-req" name="perms[alerts][]" value="view" <?php if (safe_permission_set(set_value('perms', array('alerts' => array('view'))), 'alerts', 'view')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="alerts" name="perms[alerts][]" value="create" <?php if (safe_permission_set(set_value('perms'), 'alerts', 'create')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="alerts" name="perms[alerts][]" value="edit" <?php if (safe_permission_set(set_value('perms'), 'alerts', 'edit')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="alerts" name="perms[alerts][]" value="delete" <?php if (safe_permission_set(set_value('perms'), 'alerts', 'delete')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" id="alerts-admin" class="alerts" name="perms[alerts][]" value="all" <?php if (safe_permission_set(set_value('perms'), 'alerts', 'all')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td>
                                    <a class="toggle" data-section="alerts" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo _("Contacts"); ?></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="contacts contacts-req" name="perms[contacts][]" value="view" <?php if (safe_permission_set(set_value('perms'), 'contacts', 'view')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="contacts" name="perms[contacts][]" value="edit" <?php if (safe_permission_set(set_value('perms'), 'contacts', 'edit')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" id="contacts-admin" class="contacts" name="perms[contacts][]" value="all" <?php if (safe_permission_set(set_value('perms'), 'contacts', 'all')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td>
                                    <a class="toggle" data-section="contacts" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                            <tr>
                                <td><?php echo _('Configuration'); ?></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" class="config config-req" name="perms[configure][]" value="view" <?php if (safe_permission_set(set_value('perms'), 'configure', 'view')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td class="checkbox">
                                    <label>
                                        <input type="checkbox" id="config-admin" class="config" name="perms[configure][]" value="all" <?php if (safe_permission_set(set_value('perms'), 'configure', 'all')) { echo 'checked'; }?>>
                                    </label>
                                </td>
                                <td>
                                    <a class="toggle" data-section="config" data-toggle="0"><?php echo _("Toggle All"); ?></a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <h5><?php echo _('Restrict Host Visibility'); ?></h5>
                <p><?php echo _('Create a whitelist of visible hosts for non-API users.'); ?></p>

                <div style="display: grid; align-items: center; justify-items: center; width: 600px; grid-columns: 1fr 50px 1fr; grid-template-columns: 1fr 50px 1fr; grid-rows: 30px 1fr 30px 1fr; grid-template-rows: 30px 1fr 30px 30px 1fr;">

                    <label style="grid-column: 1; grid-row: 1"><?php echo _('Host Lists'); ?></label>
                    <select multiple id="all-host-lists" class="form-control" size="5" style="height: 100%; width: 100%; grid-column: 1; grid-row: 2">
                        <?php foreach ($host_lists as $host_list) {
                            echo '<option id="host-list-option-'.$host_list['_id'].'" value="'.$host_list['_id'].'">'.html_escape($host_list['_source']['name']).'</option>';
                        } ?>
                    </select>

                    <div style="grid-column: 2; grid-row: 2; text-align: center;">
                        <i class="fa fa-arrow-right" id="add-to-selected-hosts" style="cursor: pointer"></i><br>
                        <i class="fa fa-arrow-left" id="remove-from-selected-hosts" style="cursor: pointer"></i>
                    </div>

                    <div id="insert-selected-host-lists-here" class="hide">
                    </div>

                    <label style="grid-column: 3; grid-row: 1;"><?php echo _('Selected Host Lists'); ?></label>
                    <select multiple id="selected-host-lists" class="form-control" size="5" style="height: 100%; width: 100%; grid-column: 3; grid-row: 2">
                    </select>

                    <p style="grid-column: 1; grid-column-end: 4; grid-row: 3; padding-bottom: 0; justify-self: start"><?php echo _('Select any additional hosts from the menu to the left, or enter their IP addresses manually on the right.'); ?></p>

                    <label style="grid-column: 1; grid-row: 4"><?php echo _('Known Hosts'); ?></label>
                    <select id="host-list-known-hosts" class="form-control" size="5" style="height: 100%; width: 100%; grid-column: 1; grid-row: 5">
                        <?php 
                        $ci =& get_instance();
                        $ci->load->helper('network');
                        foreach ($known_hosts as $host => $_) {
                            $name = dns_reverse_lookup($host, true);
                            echo "<option value=\"$host\">".htmlentities("$host ($name)", ENT_QUOTES, 'UTF-8')."</option>";
                        } ?>
                    </select>

                    <label style="grid-column: 3; grid-row: 4;"><?php echo _('Additional Hosts'); ?></label>
                    <textarea class="form-control" name="hosts" placeholder="<?php echo _('IP Addresses only, one per line'); ?>" id="host-list-selected-hosts" style="height: 100%; width: 100%; grid-column: 3; grid-row: 5"></textarea>
                </div>

                <h5><?php echo _('API Access'); ?></h5>
                <p><?php echo _('If you want to allow this user to use the external API via an access key.'); ?></p>

                <div class="radio">
                    <label>
                        <input type="radio" class="yes-admin" name="apiaccess" value="1" <?php if (set_value('apiaccess') == 1) { echo 'checked'; } ?>>
                        <?php echo _('Yes'); ?>
                    </label>
                </div>
                <div class="radio">
                    <label>
                        <input type="radio" class="no-admin" name="apiaccess" value="0" <?php if (set_value('apiaccess') != 1) { echo 'checked'; } else if (set_value('auth_type') == 'admin') { echo 'disabled'; } ?>>
                        <?php echo _('No'); ?>
                    </label>
                </div>
            </div>

        </div>
            
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <div style="margin-top: 15px; margin-bottom: 0;" class="form-actions">
                        <button type="submit" class="btn btn-sm btn-primary"><?php echo _('Create User'); ?></button>
                        <a href="<?php echo site_url('admin/users'); ?>" class="btn btn-sm btn-default"><?php echo _('Cancel'); ?></a>
                    </div>
                </div>
            </div>
        </div>
        
        <?php echo form_close();?>
            
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $('input[name="auth_type"]').click(function () {
        var auth_type = $(this).val();
        if (auth_type == 'admin') {
            $('.no-admin').prop('checked', false);
            $('.yes-admin').prop('checked', true);
            $('.no-admin').prop('disabled', true);
        } else {
            $('.no-admin').prop('disabled', false);
        }
    });
});
</script>

<?php echo $footer; ?>