<?php echo $header; ?>

<?php 
if (isset($_GET['validate_ai_api_key'])) {
    if (isset($_GET['key'])) {
        $key = $_GET['key'];
        $script = "/usr/local/nagioslogserver/scripts/check_ai_key.sh";
        $command = escapeshellcmd($script . " -k " . escapeshellarg($key));
        $output = null;
        $return_var = null;
        exec($command, $output, $return_var);

        switch ($return_var) {
            case 10:
                echo "<!--VALID_OPENAI_KEY-->";
                break;
            case 20:
                echo "<!--VALID_MISTRAL_KEY-->";
                break;
            case 30:
                echo "<!--VALID_ANTHROPIC_KEY-->";
                break;
            default:
                echo "<!--INVALID_KEY-->";
                break;
        }
    }
    exit;  
}

if (isset($_GET['validate_self_hosted'])) {
    if (isset($_GET['address']) && isset($_GET['port'])) {
        $address = $_GET['address'];
        $port = $_GET['port'];
        $script = "/usr/local/nagioslogserver/scripts/check_ai_key.sh";
        $command = escapeshellcmd($script . " --local --address " . escapeshellarg($address) . " --port " . escapeshellarg($port));
        $output = null;
        $return_var = null;
        exec($command, $output, $return_var);

        if ($return_var == 0) {
            echo "<!--VALID_SELF_HOSTED-->";
        } else {
            echo "<!--INVALID_SELF_HOSTED-->";
        }
    }
    exit;
}
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const nlpYesButton = document.getElementById('nlp_query_yes');
        const nlpNoButton = document.getElementById('nlp_query_no');
        const disclaimerCheckbox = document.getElementById('nlp_disclaimer');
        const aiProviderRadios = document.querySelectorAll('input[name="ai_provider"]');
        const openaiRadio = document.querySelector('input[value="openai"]');
        const apiInput = document.getElementById('ai_api_key');
        const ipInput = document.getElementById('self_host_ip_address');
        const aiPortInput = document.getElementById('ai_port');
        const saveButton = document.querySelector('button[type="submit"]');
        const keyValidationStatus = document.getElementById('key_validation_status');
        const loadingMessage = document.getElementById('loading_message');
        const successMessage = document.getElementById('success_message');
        const errorMessage = document.getElementById('error_message');
        let keyIsValid = false;

        function updateValidationUI(isValid) {
            apiInput.style.borderColor = isValid ? 'green' : 'red';
            keyIsValid = isValid;
        }

        function updateSelfHostedValidationUI(isValid) {
            ipInput.style.borderColor = isValid ? 'green' : 'red';
            aiPortInput.style.borderColor = isValid ? 'green' : 'red';
            keyIsValid = isValid;
        }

        function validateAPIKey() {
            if (!apiInput) return;

            let key = apiInput.value.trim();
            if (!key) {
                updateValidationUI(false);
                return;
            }

            keyValidationStatus.style.display = 'block';
            loadingMessage.style.display = 'block';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';

            let xhr = new XMLHttpRequest();
            xhr.open('GET', window.location.href + '?key=' + encodeURIComponent(key) + '&validate_ai_api_key=1', true);
            xhr.timeout = 3000; // 3 seconds timeout
            xhr.onload = function() {
                loadingMessage.style.display = 'none';
                const selectedProvider = document.querySelector('input[name="ai_provider"]:checked')?.value;
                
                if (selectedProvider === 'openai' && this.responseText.includes("<!--VALID_OPENAI_KEY-->")) {
                    successMessage.textContent = 'Valid OpenAI API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else if (selectedProvider === 'mistral' && this.responseText.includes("<!--VALID_MISTRAL_KEY-->")) {
                    successMessage.textContent = 'Valid Mistral API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else if (selectedProvider === 'anthropic' && this.responseText.includes("<!--VALID_ANTHROPIC_KEY-->")) {
                    successMessage.textContent = 'Valid Anthropic API key';
                    successMessage.style.display = 'block';
                    updateValidationUI(true);
                } else {
                    errorMessage.textContent = `Invalid ${selectedProvider.charAt(0).toUpperCase() + selectedProvider.slice(1)} API key`;
                    errorMessage.style.display = 'block';
                    updateValidationUI(false);
                }
            };
            xhr.ontimeout = function() {
                loadingMessage.style.display = 'none';
                errorMessage.textContent = 'Timeout, the API provider may be having issues.';
                errorMessage.style.display = 'block';
                updateValidationUI(false);
            };
            xhr.send();
        }

        function validateSelfHosted() {
            if (!ipInput || !aiPortInput) return;

            let ip = ipInput.value.trim();
            let port = aiPortInput.value.trim();
            if (!ip || !port) {
                updateSelfHostedValidationUI(false);
                return;
            }

            keyValidationStatus.style.display = 'block';
            loadingMessage.style.display = 'block';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';

            let xhr = new XMLHttpRequest();
            xhr.open('GET', window.location.href + '?address=' + encodeURIComponent(ip) + '&port=' + encodeURIComponent(port) + '&validate_self_hosted=1', true);
            xhr.timeout = 3000; // 3 seconds timeout
            xhr.onload = function() {
                loadingMessage.style.display = 'none';
                if (this.responseText.includes("<!--VALID_SELF_HOSTED-->")) {
                    successMessage.textContent = 'Valid IP address and port';
                    successMessage.style.display = 'block';
                    updateSelfHostedValidationUI(true);
                } else {
                    errorMessage.textContent = 'Invalid IP address or port';
                    errorMessage.style.display = 'block';
                    updateSelfHostedValidationUI(false);
                }
            };
            xhr.ontimeout = function() {
                loadingMessage.style.display = 'none';
                errorMessage.textContent = 'Timeout, unable to validate IP address and port.';
                errorMessage.style.display = 'block';
                updateSelfHostedValidationUI(false);
            };
            xhr.send();
        }

        apiInput?.addEventListener('input', function() {
            clearTimeout(apiInput.validationTimeout);
            apiInput.validationTimeout = setTimeout(validateAPIKey, 500); // Debounce the API key validation
        });

        ipInput?.addEventListener('input', function() {
            clearTimeout(ipInput.validationTimeout);
            ipInput.validationTimeout = setTimeout(validateSelfHosted, 500); // Debounce the IP and port validation
        });

        aiPortInput?.addEventListener('input', function() {
            clearTimeout(aiPortInput.validationTimeout);
            aiPortInput.validationTimeout = setTimeout(validateSelfHosted, 500); // Debounce the IP and port validation
        });

        function resetDefaults() {
            if (openaiRadio) openaiRadio.checked = true; // Set OpenAI as the default selected provider
            if (apiInput) apiInput.value = ''; 
            if (ipInput) ipInput.value = '';
            if (aiPortInput) aiPortInput.value = '8000'; 
            updateApiKeyLabel('OpenAI API Key'); 
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'none';
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = nlpYesButton?.checked ? 'block' : 'none';
            loadingMessage.style.display = 'none';
            successMessage.style.display = 'none';
            errorMessage.style.display = 'none';
        }

        function toggleNLPFeatures(enabled) {
            const isChecked = disclaimerCheckbox?.checked;
            const displayStyle = enabled ? 'block' : 'none';
            if (document.getElementById('nlp_disclaimer_div')) document.getElementById('nlp_disclaimer_div').style.display = displayStyle;
            if (document.getElementById('ai_provider_div')) document.getElementById('ai_provider_div').style.display = displayStyle;
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = displayStyle;

            if (!enabled) {
                resetDefaults();
            }
            toggleDisclaimer(); 
        }

        function toggleDisclaimer() {
            const isChecked = disclaimerCheckbox?.checked;
            aiProviderRadios.forEach(radio => {
                radio.disabled = !isChecked;
            });
            if (apiInput) apiInput.disabled = !isChecked;
            if (ipInput) ipInput.disabled = !isChecked;
            if (aiPortInput) aiPortInput.disabled = !isChecked;
            if (saveButton) saveButton.disabled = nlpYesButton?.checked && !isChecked; 

            if (!isChecked) {
                resetDefaults(); 
            }
        }

        nlpYesButton?.addEventListener('click', function() {
            toggleNLPFeatures(true);
        });
        nlpNoButton?.addEventListener('click', function() {
            toggleNLPFeatures(false);
        });

        disclaimerCheckbox?.addEventListener('click', toggleDisclaimer);

        function updateApiKeyLabel(providerLabel) {
            const apiKeyLabel = document.getElementById('ai_api_key_label');
            if (apiKeyLabel) apiKeyLabel.textContent = providerLabel;
            if (apiInput) apiInput.value = '';
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = 'block';
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'none';
        }

        function showSelfHostedFields() {
            if (document.getElementById('ai_api_key_input')) document.getElementById('ai_api_key_input').style.display = 'none';
            if (document.getElementById('self_hosted_fields')) document.getElementById('self_hosted_fields').style.display = 'block';
        }

        aiProviderRadios.forEach(radio => {
            radio.addEventListener('click', function() {
                if (this.value === 'self_hosted') {
                    showSelfHostedFields();
                } else {
                    updateApiKeyLabel(this.value.charAt(0).toUpperCase() + this.value.slice(1) + ' API Key');
                }
                if (document.getElementById('key_validation_status')) document.getElementById('key_validation_status').style.display = 'none';
                if (apiInput) apiInput.style.border = '';
                if (ipInput) ipInput.style.border = '';
                if (aiPortInput) aiPortInput.style.border = '';
            });
        });

        if (nlpYesButton) toggleNLPFeatures(nlpYesButton.checked);
        toggleDisclaimer();

        const selfHostedRadio = document.querySelector('input[value="self_hosted"]');
        if (selfHostedRadio && selfHostedRadio.checked) {
            showSelfHostedFields();
        }
    });
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('Global Settings'); ?></h1>
        <p><?php echo _('Edit default global settings for your Nagios Log Server install.'); ?></p>

        <?php if (!empty($success)) { ?><div class="alert alert-info" style="margin: 10px 0 20px 0;"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger" style="margin: 10px 0 20px 0;"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/globals', array("class" => "form-horizontal")); ?>
        <div class="well" style="min-width: 700px; width: 50%; margin-top: 10px;">
            <div class="form-group">
                <label class="col-sm-3 control-label" for="language"><?php echo _("Default Language"); ?></label>
                <div class="col-sm-9">
                    <select id="language" name="language" class="form-control">
                    <?php foreach ($languages as $l) { ?>
                    <option value="<?php echo $l; ?>" <?php if ($global_language == $l) { echo 'selected'; } ?>><?php echo get_language_name($l); ?></option>
                    <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="hostname">
                    <?php echo _("Cluster Hostname"); ?>
                    <?php echo question_tooltip(_('The cluster hostname can be utilized if you have a load balancer or round robin DNS setup for your cluster. This will modify all of the setup instructions to point to this host name.')); ?>
                </label>
                <div class="col-sm-9">
                    <input id="hostname" name="cluster_hostname" type="text" style="width: 210px;" class="form-control" value="<?php echo html_escape($cluster_hostname); ?>" />
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="interface_url">
                    <?php echo _("Interface URL"); ?>
                    <?php echo question_tooltip(_('The interface URL is what is displayed in alerts for the view in dashboard URL.')); ?>
                </label>
                <div class="col-sm-9">
                    <input id="interface_url" name="interface_url" type="text" style="width: 210px;" class="form-control" value="<?php echo html_escape($interface_url); ?>" />
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="log_user_queries">
                    <?php echo _("Log User Queries"); ?>
                    <?php echo question_tooltip(_('Allows you to log all user queries to show in the Audit Log.')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="log_user_queries" value="1" <?php if ($log_user_queries == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="log_user_queries" value="0" <?php if (!$log_user_queries) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="backup_rotation">
                    <?php echo _("Backup Retention"); ?>
                    <?php echo question_tooltip(_('The amount of days to keep backup system data. This is ONLY for system data, NOT log data. Setting this to 0 will stop backups from being created.')); ?>
                </label>
                <div class="col-sm-9">
                    <input id="backup_rotation" name="backup_rotation" type="text" class="form-control" value="<?php if (empty($backup_rotation)) { echo '0'; } else { echo html_escape($backup_rotation); } ?>" />
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="disable_update_check">
                    <?php echo _("Disable Update Check"); ?>
                    <?php echo question_tooltip(_('Log Server update checks are performed every 24 hours, you can disable the check.')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="disable_update_check" value="1" <?php if ($disable_update_check == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="disable_update_check" value="0" <?php if (!$disable_update_check) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="disable_reverse_dns">
                    <?php echo _("Disable Reverse DNS"); ?>
                    <?php echo question_tooltip(_('Log Server occasionally tries to retrieve hostnames from IP addresses using DNS. This setting allows you to disable that behavior.')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="disable_reverse_dns" value="1" <?php if ($disable_reverse_dns == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="disable_reverse_dns" value="0" <?php if (!$disable_reverse_dns) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="elasticsearch_localhost_only">
                    <?php echo _("Elasticsearch Listen"); ?>
                    <?php echo question_tooltip(_('Set to "All Interfaces" to allow migrating indices to a future version of Nagios Log Server.')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="elasticsearch_localhost_only" value="1" <?php if ($elasticsearch_localhost_only == 1) { echo "checked"; } ?>> <?php echo _('localhost'); ?>
                        </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="elasticsearch_localhost_only" value="0" <?php if (!$elasticsearch_localhost_only) { echo "checked"; } ?>> <?php echo _('All Interfaces'); ?>
                        </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="disable_update_check">
                    <?php echo _("Cluster Timezone"); ?>
                    <?php echo question_tooltip(_('Will set the timezone of all systems in the cluster. May take up to a minute to complete.')); ?>
                </label>
                <div class="col-sm-9">
                    <select name="timezone" class="form-control" style="min-width: 300px;">
                        <?php
                        $cur_timezone = get_current_timezone();
                        if (!empty($set_timezone)) { $cur_timezone = $set_timezone; }
                        foreach (get_timezones() as $name => $val) {
                        ?>
                        <option value="<?php echo $val; ?>" <?php if ($val == $cur_timezone) { echo 'selected'; } ?>><?php echo $name; ?></option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="csv_use_local_timezone">
                    <?php echo _("Exported CSV Timezone"); ?>
                    <?php echo question_tooltip(_('When exporting data from Log Server, timestamps can use either UTC or the Cluster Timezone.')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="csv_use_local_timezone" value="1" <?php if ($csv_use_local_timezone == 1) { echo "checked"; } ?>> <?php echo _('Cluster Timezone'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="csv_use_local_timezone" value="0" <?php if (!$csv_use_local_timezone) { echo "checked"; } ?>> <?php echo _('UTC (Default)'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>

            <!-- ================ Multi-Factor Auth Feature Section ================ -->

            <div class="two_factor-divider">
                    <div style="margin: 20px 0; margin-top:40px;">
                        <div style="padding:5px; text-align: start; font-weight: bold; font-size: 1.1em;"><?php echo _('Two Factor Authentication'); ?></div>
                        <hr style="border-color: #a5a5a5; margin: 5px 0;">
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="enable_email_two_factor">
                    <?php echo _("Enable Two Factor"); ?>
                    <?php echo question_tooltip(_('Send an email to users after logging in to authenticate')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="enable_email_two_factor" value="1" <?php if ($enable_email_two_factor == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="enable_email_two_factor" value="0" <?php if (!$enable_email_two_factor) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="token_timeout_two_factor">
                    <?php echo _("Token Timeout"); ?>
                    <?php echo question_tooltip(_('Number of minutes before a two factor auth token expires')); ?>
                </label>
                <div class="col-sm-9">
                    <label>
                        <input type="text" name="token_timeout_two_factor" class="form-control" value="<?php if (empty($token_timeout_two_factor)) { echo '15'; } else { echo html_escape($token_timeout_two_factor); } ?>">
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="enable_cookie_two_factor">
                    <?php echo _("Two Factor Cookie"); ?>
                    <?php echo question_tooltip(_('Allow users to choose to remember their browser with a cookie')); ?>
                </label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" name="enable_cookie_two_factor" value="1" <?php if ($enable_cookie_two_factor == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" name="enable_cookie_two_factor" value="0" <?php if (!$enable_cookie_two_factor) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                    <div class="clear"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-sm-3 control-label" for="cookie_timeout_two_factor">
                    <?php echo _("Cookie Timeout"); ?>
                    <?php echo question_tooltip(_('Number of days a two factor cookie will remain active before requiring a new auth token')); ?>
                </label>
                <div class="col-sm-9">
                    <label>
                        <input type="text" name="cookie_timeout_two_factor" class="form-control" value="<?php if (!is_numeric($cookie_timeout_two_factor)) { echo '90'; } else { echo html_escape($cookie_timeout_two_factor); } ?>">
                    </label>
                    <div class="clear"></div>
                </div>
            </div>

            <!-- ================ Natural Language Processing Feature Section ================ -->

            <div class="experimental-features-divider">
                    <div style="margin: 20px 0; margin-top:40px;">
                        <div style="padding:5px; text-align: start; font-weight: bold; font-size: 1.1em;"><i class="fa fa-exclamation-triangle"></i> <?php echo _('Experimental Features'); ?></div>
                        <hr style="border-color: #a5a5a5; margin: 5px 0;">
                </div>
            </div>            
            <div class="form-group">
                <label class="col-sm-3 control-label" for="nlp_query">Natural Language Queries</label>
                <div class="col-sm-9 radio" style="height: 29px; padding-top: 5px;">
                    <label>
                        <input type="radio" id="nlp_query_yes" name="natural_language_query" value="1"  <?php if ($natural_language_query == 1) { echo "checked"; } ?>> <?php echo _('Yes'); ?>
                    </label>
                    <label style="margin-left: 10px;">
                        <input type="radio" id="nlp_query_no" name="natural_language_query" value="0"<?php if (!$natural_language_query) { echo "checked"; } ?>> <?php echo _('No'); ?>
                    </label>
                </div>
            </div>
            <div class="form-group" id="nlp_disclaimer_div" style="display: none;">
                <label class="col-sm-3 control-label" for="nlp_disclaimer"><?php echo _('Disclaimer'); ?></label>
                <div class="col-sm-9">
                    <p>
                       <?php echo _('By using the Natural Language Queries feature, you acknowledge that the outputs from generative AI models might not always be accurate or useful. They can sometimes generate results that are unexpected, inappropriate, or offensive. Use this feature with caution and always review the generated results. No logs are sent to the API Provider.'); ?>
                    </p>
                    <input type="checkbox" id="nlp_disclaimer" name="nlp_disclaimer" <?php if ($nlp_disclaimer) { echo 'checked'; } ?>>
                    <label for="nlp_disclaimer"><?php echo _('I understand and agree to the disclaimer.'); ?></label>
                </div>
            </div>
            <div class="form-group" id="ai_provider_div" style="display: none;">
                <label class="col-sm-3 control-label"><?php echo _('AI Provider'); ?></label>
                <div class="col-sm-9 radio"  style="height: 29px; padding-top: 5px; display:flex; gap:10px;">
                    <!-- This will be a horizontal selection because this form has exclusively horizontal radio buttons for some reason. -->
                    <label><input type="radio" name="ai_provider" value="openai" <?php if($ai_provider=="openai" || !$ai_provider) { echo 'checked'; } ?>> OpenAI</label>
                    <label><input type="radio" name="ai_provider" value="mistral" <?php if($ai_provider=="mistral") { echo 'checked' ;} ?>> Mistral</label>
                    <label><input type="radio" name="ai_provider" value="anthropic" <?php if($ai_provider=="anthropic") { echo 'checked';} ?>> Anthropic</label>
                        <label><input type="radio" name="ai_provider" value="self_hosted" <?php if($ai_provider=="self_hosted") { echo 'checked';} ?>> <?php echo _('Self-Hosted'); ?></label>
                </div>
            </div>
            <div class="form-group" id="ai_api_key_input" style="display: none;">
                <label class="col-sm-3 control-label" id="ai_api_key_label"><?php echo _('API Key'); ?></label>
                <div class="col-sm-9">
                    <input type="password" id="ai_api_key" name="ai_api_key" class="form-control" placeholder="<?php echo _("API Key"); ?>" disabled  value="<?php if (empty($ai_api_key)) { echo ''; } else { echo html_escape($ai_api_key); } ?>" />
                </div>
            </div>
            <div class="form-group ip-ai-port-container"  id="self_hosted_fields" style="display: none;">
                <label class="col-sm-3 control-label" for="self_host_ip_address">Server Address</label>
                <div class="col-sm-9">
                    <input type="text" id="self_host_ip_address" name="self_host_ip_address"  class="form-control" placeholder="e.g. http://192.168.1.1" value="<?php if (empty($self_host_ip_address)) { echo ''; } else { echo html_escape($self_host_ip_address); } ?>" disabled />
                </div>
                <label class="col-sm-3 control-label" for="ai_port"><?php echo _('Port'); ?></label>
                <div class="col-sm-9">
                    <input type="number" id="ai_port" name="ai_port" class="form-control" value="<?php if (empty($ai_port)) { echo '8000';} else { echo html_escape($ai_port); } ?>" disabled />
                </div>
                <div class="col-sm-offset-3 col-sm-9">
                    <p class="help-block"><?php echo _('For self-hosting instructions, please refer to the <a href="') . 'https://assets.nagios.com/downloads/nagios-log-server/docs/Serving-Nagios-Enterprises-Large-Language-Models.pdf' . _('">self hosting documentation</a> here.'); ?></p>
                </div>
            </div>

            <div id="key_validation_status" style="display: none;">
                <span id="loading_message"><?php echo _('Validating...'); ?></span>
                <span id="success_message" style="color: green; display: none;"><?php echo _('API Key is valid!'); ?></span>
                <span id="error_message" style="color: red; display: none;"><?php echo _('Invalid API Key!'); ?></span>
            </div>
            <!--
            <div class="form-group">
                <label class="col-sm-3 control-label">
                    <?php echo _('Audit Log Level'); ?>
                    <?php echo question_tooltip(_('Set what type of logs you want logged in the audit log. This value defaults to info.')); ?>
                </label>
                <div class="col-sm-9">
                    <select name="audit_log_level" class="form-control">
                        <option></option>
                    </select>
                </div>
            </div>
            -->
        </div>
        <div>
            <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="saveglobals" class="btn btn-primary"><?php echo _('Save Settings'); ?></button>
        </div>
        <?php echo form_close(); ?>
        <div class="clear" style="padding-bottom:500px;"></div>
    </div>
</div>




<?php echo $footer; ?>