<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _("Admin Overview"); ?></h1>

        <div class="container-fluid admin-dash grid" style="margin-top: 10px;">
            <div class="row">
                <div class="col-sm-12">
                    <div class="grid-title">
                        <div class="pull-left">
                            <div class="table-title"><i class="fa fa-bar-chart"></i></div>
                            <span><?php echo _("Cluster Statistics"); ?></span>
                            <div class="clearfix"></div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="container-fluid" style="padding: 20px 25px 0 25px;">
                        <div class="row">
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo number_format($cluster['stats']['indices']['docs']['count']); ?></span><span><?php echo _("Documents"); ?></span></div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></span><span><?php echo _("Primary Size"); ?></span></div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></span><span><?php echo _("Total Size"); ?></span></div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo $cluster['health']['number_of_data_nodes']; ?></span><span><?php echo _("Data Instances"); ?></span></div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo $index['stats']['_shards']['total']; ?></span><span><?php echo _("Total Shards"); ?></span></div>
                            </div>
                            <div class="col-sm-12 col-md-6 col-lg-4 col-xl-2 stat-box-wrap">
                                <div class="well stat-box"><span class="stat-detail"><?php echo $cluster['stats']['indices']['count']; ?></span><span><?php echo _("Indices"); ?></span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!$maintenance_active) { ?>
        <div class="alert alert-warning" style="margin: 10px 0 20px 0;">
        <?php echo _("It looks like snapshots are currently <strong>turned off</strong>. For increased redundancy we recommend configuring automatic snapshots of your log data."); ?> <a href="<?php echo site_url('admin/snapshots'); ?>"><?php echo _("Configure automatic snapshots"); ?></a> <i class="fa fa-chevron-right"></i>
        </div>
        <?php } ?>

        <?php if (!empty($ports)) { ?>
        <div class="alert alert-info" style="margin: 10px 0 20px 0;">
            <?php echo _("<strong>Logstash</strong> is currently collecting locally on"); ?>: <?php foreach ($ports as $type => $p) { echo '<span style="margin: 0 5px;"><strong>'.$type.": ".implode(', ', $p)."</strong></span>"; } ?>
        </div>
        <?php } ?>

        <div class="admin-dash">
            <div class="row-fluid" style="min-width: 300px; width: 20%; min-height: 200px;">
                <div style="margin-top: 15px;" class="grid">
                    <div class="grid-title">
                        <div class="pull-left">
                            <div class="table-title"><i class="fa fa-bar-chart"></i></div>
                            <span><?php echo _("Version Info"); ?></span>
                            <div class="clearfix"></div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                    <div class="grid-content overflow">
                        <table>
                            <tr>
                                <td style="text-align: right; padding: 0 10px 0 20px; font-weight: bold;"><?php echo _('Nagios Log Server'); ?></td>
                                <td><?php echo get_product_version(); ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php echo $footer; ?>