<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">
        <h1><?php echo _('Host Lists'); ?></h1>

        <p><?php echo _('Configure host whitelists for multitenancy. To use these lists, edit a user and assign them one or more host lists. Their dashboards and alerts will be limited to the hosts in their assigned lists.'); ?></p>

        <?php if (!empty($errors)) { ?>
            <div class="alert alert-danger" style="margin-bottom: 15px"><?php echo implode('<br>', $errors); ?></div>
        <?php } ?>

        <div class="container-fluid" style="margin-bottom: 15px;">
            <div class="row">
                <div class="col-sm-6">
                    <button type="button" class="btn btn-sm btn-default" id="new-host-list-btn"><i class="fa fa-plus"></i> <?php echo _('New Host List');?></button>
                </div>
            </div>
        </div>

        <table class="table table-striped table-condensed table-bordered">
            <thead>
                <th style="width: 20%"><?php echo _('Name'); ?></th>
                <th><?php echo _('Hosts'); ?></th>
                <th style="width: 100px; text-align: center"><?php echo _('Actions'); ?></th>
            </thead>
            <tbody>
                <?php if (count($host_lists) > 0) {

                    foreach ($host_lists as $host_list) { ?>
                        <tr>
                            <td><?php echo html_escape($host_list['_source']['name']); ?></td>
                            <td><?php echo html_escape(implode(', ', $host_list['_source']['hosts'])); ?></td>
                            <td style="text-align: center">
                                <a class="edit" data-name="<?php echo html_escape($host_list['_source']['name']); ?>" data-hosts="<?php echo html_escape(implode("\n", $host_list['_source']['hosts'])); ?>" data-id="<?php echo html_escape($host_list['_id']); ?>"><i class="fa fa-pencil"></i></a>
                                <a class="delete" href="<?php echo site_url('admin/host_lists') . "?cmd=delete&id=" . html_escape($host_list['_id']) . "&name=" . html_escape($host_list['_source']['name']); ?>"><i class="fa fa-times" style="color: red"></i></a>
                            </td>
                        </tr>
                    <?php }
                } else { ?>
                    <td colspan="3"><?php echo _('There are no host lists defined.'); ?></td>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<div id="host-list-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">

        <?php echo form_open('admin/host_lists'); ?>

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2 id="host-list-title"><?php echo _("Add a Host List"); ?></h2>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-danger" style="margin: 0 0 15px 0;">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
                <div class="alert-body">
                    <input type="hidden" id="host-list-cmd" name="cmd" value="add">
                    <input type="hidden" id="host-list-hidden-name" name="hidden_name" value="">
                    <input type="hidden" id="host-list-id" name="id" value="">
                    <div class="well" style="margin-bottom: 0;">
                        <div class="form-horizontal">
                            <div class="form-group">
                                <label class="col-sm-3 control-label" for="name">
                                    <?php echo _('Name'); ?>
                                </label>
                                <input type="text" class="form-control col-sm-9" name="name" id="host-list-name">
                            </div>
                            <div class="form-group">
                                <label class="col-sm-3 control-label" for="name">
                                    <?php echo _('Selected Hosts'); ?>
                                </label>
                                <div class="col-sm-9" style="padding-left: 0">
                                    <textarea class="form-control" style="width: 75%; height: 10rem" name="host_list" placeholder="<?php echo _('IP Addresses only, one per line'); ?>" id="host-list-selected-hosts"></textarea>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-3 control-label" for="name">
                                    <?php echo _('Known Hosts'); ?>
                                </label>

                                <div class="col-sm-9" style="padding-left: 0">
                                    <select size="6" class="form-control" name="known_hosts" id="host-list-known-hosts" style="width: 75%; height: auto">
                                        <?php 
                                        $ci =& get_instance();
                                        $ci->load->helper('network');
                                        foreach ($known_hosts as $host => $_) {
                                            $name = dns_reverse_lookup($host, true);
                                            echo "<option value=\"$host\">".htmlentities("$host ($name)", ENT_QUOTES, 'UTF-8')."</option>";
                                        } ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-sm btn-success" <?php if (is_demo_mode()) { echo 'disabled'; } ?> id="rename-submit-btn"><?php echo _("Submit"); ?></button>
                <button type="button" class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>

        <?php echo form_close(); ?>

    </div>
</div>
<script>

var ADD_TITLE = '<?php echo _('Add a Host List'); ?>';
var EDIT_TITLE = '<?php echo _('Change a Host List'); ?>';

$(document).ready(function() {
    $('#new-host-list-btn').click(function() {
        // Clear the modal (sets to add mode)
        clear_host_list_modal();

        // Show the modal
        $('#host-list-modal').modal('show');
    });

    $('.edit').click(function() {
        // Clear the modal
        clear_host_list_modal();

        // Populate specific data for selected list
        populate_host_list_modal(this);

        // Show the modal
        $('#host-list-modal').modal('show');
    });

    $('#host-list-known-hosts').change(function(e) {

        // Get the IP Address that was just selected
        var addr = e.target.value;

        // Replace all periods '.' with the escaped periods '\.'
        var addr_escaped = addr.replace(/\./g, '\\.');

        // Match any line exactly matching the IP Address
        var match_regexp = new RegExp('^' + addr_escaped + '$', 'm');

        // If the IP Address is already present, do nothing
        var current_text = $('#host-list-selected-hosts').val();
        if (!current_text.match(match_regexp)) {

            // Insert a newline only if we need to
            var last_character = current_text[current_text.length-1];
            if ((typeof last_character === 'undefined') || last_character === '\n') {
                $('#host-list-selected-hosts')[0].value += addr;
            }
            else {
                $('#host-list-selected-hosts')[0].value += "\n" + addr;
            }
        }
    });

    $('#rename-submit-btn').click(function() {
        $(this).html('<i class="fa fa-spinner"></i> ' + $(this).html());
    });
});

function clear_host_list_modal() {
    $('#host-list-title').html(ADD_TITLE);
    $('#host-list-name').val('');
    $('#host-list-cmd').val('add');
    $('#host-list-id').val('');
    $('#host-list-selected-hosts').val('');
}

function populate_host_list_modal(edit_button_this) {
    $('#host-list-title').html(EDIT_TITLE);
    $('#host-list-name').val($(edit_button_this).data('name'));
    $('#host-list-hidden-name').val($(edit_button_this).data('name'));
    $('#host-list-cmd').val('edit');
    $('#host-list-id').val($(edit_button_this).data('id'));
    $('#host-list-selected-hosts').val($(edit_button_this).data('hosts'));
}

</script>