<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('LDAP / AD Import Users'); ?></h1>
        <p><?php echo _("Log into your LDAP / Active Directory"); ?> <strong><?php echo _("administrator"); ?></strong> <?php echo _("or"); ?> <strong><?php echo _("privileged account"); ?></strong> <?php echo _("to be able to import users directly into Log Server."); ?></p>

        <?php if (!empty($errors)) { ?>
        <div class="alert alert-danger" style="margin: 10px 0 10px 0;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <?php echo $errors; ?>
        </div>
        <?php } ?>

        <?php echo form_open('admin/users/import'); ?>
        <div style="padding: 10px 0; margin-bottom: 20px;">
            <div style="margin-bottom: 10px;">
                <input type="text" name="username" class="form-control" value="<?php if (!empty($username)) { echo $username; } ?>" placeholder="<?php echo _("Username"); ?>">
            </div>
            <div style="margin-bottom: 10px;">
                <input type="password" name="password" class="form-control" placeholder="<?php echo _("Password"); ?>">
            </div>
            <div style="margin-bottom: 10px;">
                <select name="auth_server_id" class="form-control" style="width: auto;">
                    <?php foreach ($auth_servers as $as) { ?>
                    <option value="<?php echo $as['id']; ?>" <?php if (empty($as['active'])) { echo "disabled"; } if (!empty($auth_server_id)) { if ($auth_server_id == $as['id']) { echo 'selected'; } } ?>><?php if ($as['type'] == "ad") { echo _('Active Directory').' - '.$as['name']. ' - '. $as['controllers']; } else { echo _('LDAP').' - '.$as['host']; } ?></option>
                    <?php } ?>
                </select>
            </div>
            <div>
                <button type="submit" value="1" name="submitted" class="btn btn-sm btn-default"><?php echo _('Next'); ?> <i class="fa fa-chevron-right" style="font-size: 11px; margin-left: 4px;"></i></button>
            </div>
        </div>
        <?php echo form_close(); ?>

        <a href="<?php echo site_url('admin/auth_servers'); ?>"><?php echo _('Manage Authentication Servers'); ?></a>

    </div>
</div>

<?php echo $footer; ?>