<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $('#create').click(function() {

        $.get(site_url+'api/system/get_users', { }, function(data) {
            var alerts = [];
            var all_usernames = [];

            $.each(data, function(k, v) {
                all_usernames.push(v.username);
            });

            $.each($('.email'), function(k, v) {
                if ($(v).parents('tr').find('input[type="checkbox"]').is(":checked")) {
                    var email = $(v).val();
                    if (email == '' || email.length < 4 || email.indexOf('@') == -1) {
                        $(v).addClass('req');
                        if (alerts.indexOf('email') == -1) {
                            alerts.push('email');
                        }
                    }
                }
            });

            $.each($('.username'), function(k, v) {
                if ($(v).parents('tr').find('input[type="checkbox"]').is(":checked")) {
                    if (all_usernames.indexOf($(v).val()) != -1) {
                        $(this).addClass('req');
                        if (alerts.indexOf('username') == -1) {
                            alerts.push('username');
                        }
                    }
                }
            });
            
            // Submit the form manually or show an error...
            if (alerts.length == 0) {
                $('#main-alert').hide();
                $('form').submit();
            } else {
                var alert_text = '';
                $.each(alerts, function(k, v) {
                    if (v == 'email') {
                        alert_text += '<?php echo _("Must enter a valid email address for each user."); ?> ';
                    } else if (v == 'username') {
                        alert_text += '<?php echo _("Must be a unique username, the username(s) already exist."); ?> ';
                    }
                });

                $('#main-alert-text').html(alert_text);
                $('#main-alert').show();
            }

        });

        return false;
    });

    $('.email').blur(function() {
        if ($(this).hasClass('req')) {
            if ($(this).val() != '') {
                $(this).removeClass('req');
            }
        }
    });

    $('.username').blur(function() {
        $(this).removeClass('req');
    });

});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('LDAP / AD Import Users'); ?></h1>
        <p><?php echo _('Set up the new users. Add missing information and update the account.'); ?></p>
        <h4><?php echo _('Fill Out New User Information'); ?></h4>

        <div class="alert alert-danger hide" id="main-alert">
            <span id="main-alert-text"></span>
        </div>

        <?php echo form_open('admin/users/import/complete'); ?>
        <table class="table table-striped table-bordered table-hover import-users-table" style="margin: 20px 0;">
            <thead>
                <tr>
                    <th style="width: 34px;"></th>
                    <th><?php echo _('Full Name'); ?></th>
                    <th><?php echo _('Username'); ?> <span class="red tt_bind" title="Required">*</span></th>
                    <th><?php echo _('Email Address'); ?> <span class="red tt_bind" title="Required">*</span></th>
                    <th><?php echo _('User Type'); ?> <span class="red tt_bind" title="Required">*</span></th>
                    <th><?php echo _('API Access'); ?></th>
                    <th><?php echo _('Auth Type'); ?></th>
                    <th><?php echo _('Auth Identifier'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($new_users as $i => $user) { ?>
                <tr>
                    <td style="text-align: center;">
                        <input type="checkbox" value="1" name="import[<?php echo $i; ?>]" checked style="margin-top: 9px;" class="tt-bind" data-placement="right" title="<?php echo _('Select or de-select user to be created.'); ?>">
                    </td>
                    <td>
                        <input type="text" class="name form-control" name="full_name[<?php echo $i; ?>]" value="<?php echo $user['firstname'] . ' ' . $user['lastname']; ?>">
                    </td>
                    <td>
                        <input type="text" class="username form-control" name="username[<?php echo $i; ?>]" value="<?php echo $user['username']; ?>" style="width: 120px;">
                    </td>
                    <td>
                        <input type="text" class="email form-control" name="email[<?php echo $i; ?>]" value="<?php echo $user['email']; ?>">
                    </td>
                    <td>
                        <select name="level[<?php echo $i; ?>]" class="form-control" style="width: 100px;">
                            <option value="user"><?php echo _('User'); ?></option>
                            <option value="admin"><?php echo _('Admin'); ?></option>
                        </select>
                    </td>
                    <td>
                        <select name="apiaccess[<?php echo $i; ?>]" class="form-control" style="width: 70px;">
                            <option value="1"><?php echo _('Yes'); ?></option>
                            <option value="0" selected><?php echo _('No'); ?></option>
                        </select>
                    </td>
                    <td>
                        <input type="hidden" name="account_type[<?php echo $i; ?>]" value="<?php echo $server['type']; ?>">
                        <input type="hidden" name="server_id[<?php echo $i; ?>]" value="<?php echo $server['id']; ?>">
                        <input type="text" class="form-control" value="<?php if ($server_type == "ad") { echo _('Active Directory'); } else if ($server_type == "ldap") { echo _('LDAP'); } ?>" disabled style="width: 140px;">
                    </td>
                    <?php if ($server_type == "ad") { ?>
                    <td>
                        <input type="hidden" name="ad_username[<?php echo $i; ?>]" value="<?php echo $user['username']; ?>">
                        <input type="text" class="form-control" value="<?php echo $user['username'].$server['suffix']; ?>" disabled style="width: 200px;">
                    </td>
                    <?php
                    } else if ($server_type == "ldap") {
                    ?>
                    <td>
                        <input type="hidden" name="dn[<?php echo $i; ?>]" value="<?php echo $user['dn']; ?>">
                        <input type="text" class="form-control" value="<?php echo $user['dn']; ?>" disabled style="width: 300px;">
                    </td>
                    <?php } ?>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <button type="submit" id="create" class="btn btn-sm btn-primary"><?php echo _('Create Users'); ?></button>
        <a href="<?php echo site_url('admin/users/import'); ?>" class="btn btn-sm btn-default"><?php echo _('Cancel'); ?></a>
        <?php echo form_close(); ?>

    </div>
</div>

<?php echo $footer; ?>