
<script type="text/javascript">
var lastChecked = null;

var opening_indices = ['<?= (is_array($opening_indices)) ? implode("','", $opening_indices) : "" ?>'];
if (opening_indices[0] === '') {
    opening_indices = [];
}

var opening_indices_interval_tracker = null;

$(document).ready(function() {

    add_checkbox_magic();

    handle_opening_indices();

    $('#cb-toggle').click(function() {
        if ($(this).is(':checked')) {
            $('input[name="sel"]').prop('checked', true);
        } else {
            $('input[name="sel"]').prop('checked', false);
        }
    });

    $('#index-action').change(function() {
        var action = $(this).val();
        var indices = [];
        $('input[name="sel"]:checked').each(function(k, v) { indices.push($(v).val()); });

        switch (action) {

            case 'open':
                var conf = confirm("<?php echo _('Are you sure you want to open all the selected indexes?'); ?>");
                if (conf == true) {
                    set_opening_indices(indices);
                    $.each(indices, function(k, v) {
                        open_index(v);
                    });
                }
                break;

            case 'close':
                var conf = confirm("<?php echo _('Are you sure you want to close all the selected indexes?'); ?>");
                if (conf == true) {
                    $.each(indices, function(k, v) {
                        close_index(v);
                    });
                }
                break;

            case 'delete':
                var conf = confirm("<?php echo _('Are you sure you want to delete all the selected indexes?'); ?>");
                if (conf == true) {
                    $.each(indices, function(k, v) {
                        delete_index(v);
                    });
                }
                break;

        }
        window.location.href = window.location.href;
    });

    // close open index
    $('.close-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = this.id;
        var conf = confirm("Are you sure you want to close index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {
            $.post(site_url + 'api/backend/' + index + '/_close', {}, function(data) {
                if (data.success == 0) {
                    alert(data.errormsg);
                } else {
                    var log = {
                        type: 'CONFIG',
                        message: 'Index ' + index + ' closed',
                    };
                    $.post(site_url + 'api/log/create', { log: log }, function() {
                         window.location.href = window.location.href;
                    });
                }
            }, 'json');
        }
    });
    
    // open closed index
    $('.open-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = this.id;
        var conf = confirm("Are you sure you want to open index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {

            set_opening_indices([index]);
            $.post(site_url + 'api/backend/' + index + '/_open', {}, function(data) {
                if (data.success == 0) {
                    alert(data.errormsg);
                } else {
                    var log = {
                        type: 'CONFIG',
                        message: 'Index ' + index + ' opened'
                    };
                    $.post(site_url + 'api/log/create', { log: log }, function() {
                         window.location.href = window.location.href;
                    });
                }
            }, 'json');
        }
    });
    
    // delete index
    $('.delete-index').click(function(e) {
        if (is_demo_mode) {
            alert("This function is not available in demo mode.");
            return false;
        }
        var index = $(this).children().first().val();
        var conf = confirm("Are you sure you want to PERMANENTLY DELETE index " + index + "?");
        if (conf == true && index.indexOf("logstash") > -1) {
            $.ajax({
                url: site_url + 'api/backend/' + index + '/',
                type: 'DELETE',
                success: function(data) {
                    if (data.success == 0) {
                        alert(data.errormsg);
                    } else {
                        window.location.href = window.location.href;
                    }
                }
            });
        }
    });

});

function handle_opening_indices() {

    if (opening_indices.length !== 0) {

        // Disable each button
        for (i in opening_indices) {
            jq_escaped = selector_escape(opening_indices[i]);
            $('#' + jq_escaped).attr('disabled', true);
        }

        // Create the throbber
        $('#indices_opening_total').html(opening_indices.length);
        $('#indices_opening_remaining').html(opening_indices.length);
        $('#indices_opening').removeClass('hide');

        opening_indices_interval_tracker = setInterval(function() {

            $.ajax({
                url: site_url + '/api/system/indices_status',
                type: 'POST',
                async: false,
                data: { indices: opening_indices },
                dataType: 'json',
                success: function(data) {

                    for (var i = opening_indices.length - 1; i >= 0; i--) {
                        index_name = opening_indices[i];
                        if (data[index_name] === "STARTED") {
                            $('#' + selector_escape(index_name)).attr('disabled', false);
                            opening_indices.splice(i, 1);
                        }
                    }

                    $('#indices_opening_remaining').html(opening_indices.length);

                    if (opening_indices.length === 0) {
                        $('#indices_opening').html('<?php echo _('All indices finished opening.'); ?>');
                        clearInterval(opening_indices_interval_tracker);
                        set_opening_indices(opening_indices); // opening_indices = []
                    }
                }
            });
        }, 1000);
    }
}

function set_opening_indices(indices) {
    $.ajax({
        url: site_url + 'api/system/set_opening_indices',
        type: 'POST',
        async: true,
        data: { indices: indices }
    });
}

function close_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/_close',
        type: 'POST',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function open_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/_open',
        type: 'POST',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function delete_index(index) {
    $.ajax({
        url: site_url + 'api/backend/' + index + '/',
        type: 'DELETE',
        async: false,
        success: function(data) {
            if (data.success == 0) {
                alert(data.errormsg);
            }
        }
    });
}

function add_checkbox_magic() {
    var $chkboxes = $('input[name="sel"]');
    $chkboxes.click(function(e) {
        if (!lastChecked) {
            lastChecked = this;
            return;
        }
        if (e.shiftKey) {
            var start = $chkboxes.index(this);
            var end = $chkboxes.index(lastChecked);
            $chkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
        }
        lastChecked = this;
    });
}
</script>


                <?php if (!isset($index['stats']['count']) || $index['stats']['count'] != 1): ?>

                <div class="col-sm-12">

                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-database"></i></div>
                                <span><?php echo _("Indices"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table id="indicesTable" class="table table-bordered table-condensed table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th style="width: 18px; text-align: center;"><input type="checkbox" id="cb-toggle"></th>
                                        <th><?php echo _("Index"); ?></th>
                                        <th style="text-align: right;"># <?php echo _("Docs"); ?></th>
                                        <th style="text-align: right;"><?php echo _("Primary Size"); ?></th>
                                        <th style="text-align: right;"># <?php echo _("Shards"); ?></th>
                                        <th style="text-align: right;"># <?php echo _("Replicas"); ?></th>
                                        <th style="text-align: center;"><?php echo _("Action"); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($index['stats']['indices'] as $index_id => $indices): ?>
                                    <tr>
                                        <td style="text-align: center;">
                                            <?php if ($index_id != ('logstash-' . date('Y.m.d'))) { ?>
                                            <input type="checkbox" name="sel" value="<?php echo $index_id; ?>">
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if ($indices['state'] == "open"): ?>
                                            <a data-title="Index Information" data-placement="bottom" rel="tipRight" href="<?php echo site_url('admin/index_status/'.$index_id); ?>" data-original-title="" title=""><?php echo $index_id; ?></a>
                                            <?php else: ?>
                                                <?php echo $index_id; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td style="text-align: right"><?php if (@isset($indices['primaries'])) { echo number_format($indices['primaries']['docs']['count']); } else { echo "-"; } ?></td>
                                        <td style="text-align: right"><?php if (@isset($indices['primaries'])) { echo @strtoupper($indices['primaries']['store']['size']); } else { echo "-"; } ?></td>
                                        <td style="text-align:right"><?php echo $indices['settings']['index']['number_of_shards']; ?></td>
                                        <td style="text-align:right"><?php echo $indices['settings']['index']['number_of_replicas']; ?></td>
                                        <td style="width: 180px; text-align: center;">
                                            <?php if ($index_id != ('logstash-' . date('Y.m.d'))) { ?>
                                            <?php if ($indices['state'] == 'close'): ?>
                                                <button id="<?php echo $index_id; ?>" class="btn btn-xs btn-default open-index" type="button"><i class="fa fa-history"></i> <?php echo _("open"); ?></button>
                                            <?php else: ?>
                                                <button id="<?php echo $index_id; ?>" class="btn btn-xs btn-default close-index" type="button"><i class="fa fa-stop"></i> <?php echo _("close"); ?></button>
                                            <?php endif; } ?>
                                            <button class="btn btn-xs btn-default delete-index" type="button"><input type="hidden" value="<?php echo $index_id; ?>"/><i class="fa fa-times-circle"></i> <?php echo _("delete"); ?></button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                            <div style="margin-top: 10px;">
                                <?php echo _('With selected indices'); ?>: 
                                <select id="index-action" class="form-control" style="width: 100px; margin: 0;">
                                    <option></option>
                                    <option value="open"><?php echo _('Open'); ?></option>
                                    <option value="close"><?php echo _('Close'); ?></option>
                                    <option value="delete"><?php echo _('Delete'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <?php else: ?>
                
                <div class="col-sm-6">

                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-search"></i></div>
                                <span class="text-left"><?php echo _("Search Totals"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-bordered table-striped grid-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 120px;"><?php echo _("Query Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['search']['query_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Query Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['search']['query_time']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Fetch Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['search']['fetch_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Fetch Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['search']['fetch_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-file"></i></div>
                                <span class="text-left"><?php echo _("Get Totals"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-bordered table-striped grid-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 120px;"><?php echo _("Get Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Get Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['get_time']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Exists Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['exists_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Exists Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['exists_time']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Missing Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['missing_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Missing Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['get']['missing_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
                <div class="col-sm-6">

                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-file"></i></div>
                                <span class="text-left"><?php echo _("Documents"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-bordered table-striped grid-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 120px;"><?php echo _("Primary Documents"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['primaries']['docs']['count']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Total Documents"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['docs']['count']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Deleted Documents"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['docs']['deleted']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Primary Size"); ?>:</td>
                                        <td><?php echo strtoupper($index['stats']['_all']['primaries']['store']['size']); ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Total Size"); ?>:</td>
                                        <td><?php echo strtoupper($index['stats']['_all']['total']['store']['size']); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-list"></i></div>
                                <span class="text-left"><?php echo _("Indexing Totals"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-bordered table-striped grid-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 120px;"><?php echo _("Index Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['indexing']['index_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Index Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['indexing']['index_time']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Delete Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['indexing']['delete_total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Delete Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['indexing']['delete_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    
                    <div class="grid">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-cog"></i></div>
                                <span class="text-left"><?php echo _("Operations"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-bordered table-striped grid-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%; min-width: 120px;"><?php echo _("Refresh Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['refresh']['total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Refresh Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['refresh']['total_time']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Flush Total"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['flush']['total']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _("Flush Time"); ?>:</td>
                                        <td><?php echo $index['stats']['_all']['total']['flush']['total_time']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
                <?php endif; ?>

                </div>
