<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('License Information'); ?></h1>
        <?php if (is_trial_license()) { ?>
        <p><?php echo _('Manage your Nagios Log Server license. If you do not have one, you can'); ?> <a href="https://www.nagios.com/buy/" target="_new"><?php echo _("purchase one"); ?></a>.</p>
        <?php } ?>

        <?php if (!empty($success)) { ?><div class="alert alert-info" style="margin: 10px 0 20px 0;"><?php echo $success; ?></div><?php } ?>

        <div class="container-fluid" style="margin-top: 10px;">
            <div class="row">
                <div class="col-sm-12 col-md-10 col-lg-8 col-xl-6">
                    <?php if (!empty($error)) { ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
                    <?php } else if (is_trial_license()) { ?>
                        <?php if (get_trial_days_left() > 60) { ?>
                            <div class="alert alert-warning"><?php echo _('<b>Extended Trial</b> - Your trial will end in'); ?> <strong><?php echo get_trial_days_left(); ?></strong> <?php echo _('days'). " (60 + " . (get_trial_days_left() - 60) . " " . _("bonus days") . ")"; ?>.</div>
                        <?php } else { ?>
                            <div class="alert alert-warning"><?php echo _('Update your license key. Your trial will end in'); ?> <strong><?php echo get_trial_days_left(); ?></strong> <?php echo _('days'); ?>.</div>
                        <?php } ?>
                    <?php } else if (is_subscription_license() == true && is_subscription_expired()) { ?>
                    <div class="alert alert-danger"><?php echo _("This subscription for Nagios Log Server has expired"); ?>.</div>
                    <?php } else if (is_subscription_license() == true && get_subscription_days_left() < 30) { ?>
                    <div class="alert alert-danger"><?php echo _("The subscription to Nagios Log Server will expire in"); ?> <?php echo get_subscription_days_left(); ?> <?php echo _("days"); ?>.</div>
                    <?php } else { ?>
                    <div class="alert alert-success"><?php echo _('Your license key is valid'); if (is_license_activated()) { echo ' ' . _('and activated'); } ?>.</div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="form-horizontal" style="margin: 20px 0;">
            <?php echo form_open('admin/license'); ?>
                <div class="input-group" style="width: 400px; float: left;">
                    <span class="input-group-addon"><i class="fa fa-key fa-l"></i> <b><?php echo _('License Key'); ?></b></span>
                    <input <?php if (is_demo_mode()) { echo 'disabled'; } ?> style="border-right: 0;" type="text" name="key" class="form-control" value="<?php if (!is_demo_mode()) { echo get_license_key(); } else { echo 'DEMO MODE'; } ?>">
                </div>
                <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="setkey" class="btn btn-sm btn-primary"><?php echo _('Set Key'); ?> <i class="icon-chevron-right icon-white"></i></button>
                <div class="clear"></div>
            <?php echo form_close(); ?>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12 col-md-10 col-lg-8 col-xl-6">
                    <div class="grid" style="margin:0;">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-bookmark"></i></div>
                                <span><?php echo _("License Information"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-striped table-hover table-bordered center-table">
                                <tbody>
                                    <?php echo get_license_info(get_license_key()); ?>
                                </tbody>
                            </table>
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!is_trial_license() && !is_free_license()) { ?>
            <div class="row" style="margin-top: 20px;">
                <div class="col-sm-12 col-md-10 col-lg-8 col-xl-6">
                    <div class="grid" style="margin:0;">
                        <div class="grid-title">
                            <div class="pull-left">
                                <div class="table-title"><i class="fa fa-bookmark"></i></div>
                                <span><?php echo _("Maintenance &amp; Activation"); ?></span>
                                <div class="clearfix"></div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                        <div class="grid-content overflow">
                            <table class="table table-striped table-hover table-bordered center-table">
                                <tbody>
                                    <tr>
                                        <td style="width: 40%;"><?php echo _('License Activated'); ?>:</td>
                                        <td><?php if (is_license_activated()) { echo _('Yes'); } else { echo _('No') . ' - <a href="' . site_url('admin/activate') . '">' . _('Activate now') . '</a>'; } ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _('Maintenance Status'); ?>:</td>
                                        <td>
                                            <?php if (is_demo_mode()) { echo _('DEMO MODE'); } else { if (does_license_have_maintenance()) { echo _('Current - Expires on'); } else { echo _('<b>Expired!</b> - Ends on'); } ?> 
                                            <?php echo date("m/d/Y", get_maintenance_end_date()); ?> <?php if (get_maintenance_days_left() > 0) { ?>(<?php echo get_maintenance_days_left() . " " . _('days left'); ?>)<?php } } ?> - <a href="https://www.nagios.com/renew/?license_hash=<?php echo md5(get_license_key()); ?>" target="_blank"><?php echo _('Renew Now') ?></a>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><?php echo _('Last Maintenance Check'); ?>:</td>
                                        <td><?php echo date("m/d/Y H:i:s", get_option('last_met_check_time')); ?> - <a href="<?php echo site_url('admin/license?maint_check=1'); ?>"><?php echo _('Run Check'); ?></a></td>
                                    </tr>
                                </tbody>
                            </table>
                            <div class="clear"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>

            <?php if (is_trial_license() || is_free_license()) { ?>
            <h5><?php echo _("Trial Extension"); ?></h5>
            <p><?php echo _("Need a trial extension? Contact"); ?> <a href="mailto:sales@nagios.com">sales@nagios.com</a> <?php echo _("for more information"); ?>.</p>
            <div class="form-inline">
                <?php echo form_open('admin/extend_trial'); ?>
                <div class="input-group">
                    <div class="input-group-addon"><?php echo _("Trial Extension Key"); ?></div>
                    <input type="text" name="trial_extension_key" value="<?php echo set_value('trial_extension_key'); ?>" class="form-control">
                </div>
                <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="setkey" class="btn btn-sm btn-default"><?php echo _('Apply'); ?> <i class="icon-chevron-right icon-white"></i></button>
                <?php echo form_close(); ?>
            </div>
            <?php } ?>

        </div>
    </div>
</div>
<?php echo $footer; ?>