<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $("#test-settings").bind('click', function() {
        btn = $(this);
        btn.button('loading');
        postvars = { '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }
        url = '<?php echo site_url('admin/test_mail_settings') ?>';
        $.post(url, postvars, function(data) {
            if (data.result == 'success') {
                $('#test-success').html('<?php echo _('The email was sent successfully to'); ?> <b>' + data.email + '</b> <?php echo _('Check your inbox to ensure you received the message'); ?>.').show();
                $('#test-error').hide();
            } else {
                $('#test-success').hide();
                $('#test-error').html(data.msg).show();
            }
            btn.button('reset');
        }, 'json');
        return false;
    });

    $('#email_method').change(function() {
        var method = $(this).val();
        if (method == "smtp") {
            $('#smtp-settings').show();
        } else {
            $('#smtp-settings').hide();
        }
    });

});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('Mail Settings'); ?></h1>
        <p><?php echo _('Set the settings for sending outgoing mail such as notifications. From and Reply-to names and emails are defaulted to what is shown below.'); ?></p>

        <?php if (!empty($success)) { ?><div class="alert alert-info" style="margin: 10px 0 20px 0;"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger" style="margin: 10px 0 20px 0;"><?php echo $error; ?></div><?php } ?>
    
        <div id="test-error" style="margin: 10px 0 20px 0;" class="alert alert-danger hide"></div>
        <div id="test-success" style="margin: 10px 0 20px 0;" class="alert alert-success hide"></div>

        <?php echo form_open('admin/mail', array("class" => "form-horizontal")); ?>
        <div style="min-width: 700px; width: 50%; margin: 10px 0 20px 0; padding-bottom: 5px;">
            <div class="well">
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="email_from"><?php echo _("From Email"); ?></label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control" style="width: 150px;" id="email_from_name" name="email_from_name" value="<?php echo htmlentities($email_from_name, ENT_COMPAT, 'UTF-8'); ?>" placeholder="<?php echo _('Nagios Log Server'); ?>">
                        <input type="text" id="email_from" style="width: 250px;" class="form-control" name="email_from" value="<?php echo htmlentities($email_from, ENT_COMPAT, 'UTF-8'); ?>" placeholder="logserver@mydomain.com">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="email_reply_to"><?php echo _("Reply-To Email"); ?></label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control" style="width: 150px;" id="email_reply_to_name" name="email_reply_to_name" value="<?php echo htmlentities($email_reply_to_name, ENT_COMPAT, 'UTF-8'); ?>" placeholder="<?php echo _('Nagios Log Server'); ?>">
                        <input type="text" id="email_reply_to" style="width: 250px;" class="form-control" name="email_reply_to" value="<?php echo htmlentities($email_reply_to, ENT_COMPAT, 'UTF-8'); ?>" placeholder="root@localhost">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="email_method"><?php echo _("Send Email Method"); ?></label>
                    <div class="col-sm-9">
                        <select name="email_method" class="form-control" id="email_method">
                            <option value="mail" <?php if ($email_method == 'mail') { echo "selected"; } ?>><?php echo _("PHP Mail"); ?></option>
                            <option value="smtp" <?php if ($email_method == 'smtp') { echo "selected"; } ?>><?php echo _("SMTP Server"); ?></option>
                        </select>
                    </div>
                </div>
                <div id="smtp-settings" <?php if ($email_method == 'mail' || empty($email_method)) { echo 'class="hide"'; } ?>>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="smtp_host"><?php echo _("SMTP Server Address"); ?></label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_host" value="<?php echo $smtp_host; ?>" id="smtp_host">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="smtp_crypto"><?php echo _("SMTP Security"); ?></label>
                        <div class="col-sm-9">
                            <select name="smtp_crypto" class="form-control" id="smtp_crypto">
                                <option value="" <?php if (empty($smtp_crypto)) { echo "selected"; } ?>>None</option>
                                <option value="ssl" <?php if ($smtp_crypto == 'ssl') { echo "selected"; } ?>>SSL</option>
                                <option value="tls" <?php if ($smtp_crypto == 'tls') { echo "selected"; } ?>>TLS or STARTTLS</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="smtp_port"><?php echo _("SMTP Port"); ?></label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_port" style="width: 40px;" value="<?php if (!empty($smtp_port)) { echo $smtp_port; } else { echo '25'; } ?>" placeholder="25" id="smtp_port">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="smtp_user"><?php echo _("SMTP Username"); ?></label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="smtp_user" style="width: 200px;" value="<?php echo $smtp_user; ?>" id="smtp_user">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label" for="smtp_pass"><?php echo _("SMTP Password"); ?></label>
                        <div class="col-sm-9">
                            <input type="password" class="form-control" name="smtp_pass" style="width: 200px;" value="<?php echo $smtp_pass; ?>" id="smtp_pass">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label"></label>
                    <div class="col-sm-9 checkbox">
                        <label>
                            <input type="checkbox" name="email_text_only" value="1" <?php if ($email_text_only) { echo 'checked'; } ?> id="email_text_only">
                            <?php echo _("Send emails as text only (no HTML)"); ?>
                        </label>
                    </div>
                </div>
            </div>
            <div>
                <button type="submit" class="btn fl btn-sm btn-primary"><?php echo _("Save Settings"); ?></button>
                <button <?php if (is_demo_mode()) { echo "disabled"; } ?> autocomplete="false" id="test-settings" data-toggle="button" data-loading-text="<?php echo _('Please wait'); ?>..." class="btn fr btn-sm btn-default"><i class="fa fa-paper-plane fa-l"></i> <?php echo _('Test Settings'); ?></button>
                <div class="clear"></div>
            </div>
        </div>
        <?php echo form_close(); ?>

    </div>
</div>

<?php echo $footer; ?>