<?php

echo $header;

// FIX THIS!!!!!
$nodeList = array();

foreach ($nodes as $node) {
    $nodeList[] = $node['_source']['hostname'].'|'.$node['_source']['address'];
}
?>

<div class="configure-layout">
    <?= $leftbar ?>

    <div id="create-alert-message" class="rside alert hide" style="margin: 0 0 15px 0; height: 35px; padding: 10px 20px;">
        <div id="alert-message"></div>
    </div>
    <div class="rside">

        <h1><?= _('Monitor Backend (via NCPA)') ?></h1>
        <p><?= _('This page provides information regarding the monitoring of Nagios Log Server itself. Nagios Log Server comes with the Nagios Cross-Platform Agent installed, so that you can integrate with a Nagios XI server.') ?></p>

        <?php if (!empty($success)) { ?><div class="alert alert-success"><?= $success ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger"><?= $error ?></div><?php } ?>

        <a class="btn btn-sm btn-primary" target="_blank" href="<?= 'https://' . $_SERVER['SERVER_ADDR'] . ':5693/';?>"><?= _("Open NCPA Interface") ?></a>

        <h3><?= _('Tokens') ?></h3>
        <div>
            <p><?= _('When saved, these tokens will be applied to all instances.');?></p>
        </div>
        <div class="input-group"  style="margin-bottom: 10px; width: 600px">
            <span class="input-group-addon"><?= _("NCPA API Token") ?></span>
            <input type="text" class="form-control" value="<?= $api_token;?>" style="width: 300px;">
            <button class="btn btn-sm btn-default tt-bind generate-random" title="<?= _("Generate new API token");?>" style="margin-left: 5px;"><i class="fa fa-undo"></i></button>
            <button class="btn btn-sm btn-primary save-config" data-endpoint="ncpa-api" style="margin-left: 5px;"><i class="fa fa-save"></i> <?= _("Save");?></button>
        </div>

        <?php /* <!--<div class="input-group"  style="margin-bottom: 10px; width: 600px">
            <span class="input-group-addon"><?= _("NRDP Token") ?></span>
            <input type="text" class="form-control" value="<?= $nrdp_token;?>" style="width: 300px;">
            <button class="btn btn-sm btn-default tt-bind generate-random" title="<?= _("Generate new NRDP token");?>" style="margin-left: 5px;"><i class="fa fa-undo"></i></button>
            <button class="btn btn-sm btn-primary save-config" data-endpoint="ncpa-nrdp" style="margin-left: 5px;"><i class="fa fa-save"></i> <?= _("Save");?></button>
        </div>--> */ ?>


        <h3><?= _('Processes') ?></h3>

        <div class="input-group" style="width: 460px;">
            <span class="input-group-addon"><?= _("Instance") ?></span>

            <select id="node-select" class="form-control">
                <?php foreach ($nodes as $node) {
                    $node = $node['_source'];
                    $thisInstance = '';

                    # SERVER_ADDR may be localhost or the inet6 address, so check HTTP_HOST, as well.
                    # The value returned by HTTP_HOST and SERVER_ADDR may be the hostname or an ip, so check both.
                    # NOTE: I was changing /etc/hosts and hostname via hostnamectl, so this may not be correct.
                    if ($node['hostname'] == $_SERVER['HTTP_HOST']   || $node['address'] == $_SERVER['HTTP_HOST'] ||
                        $node['hostname'] == $_SERVER['SERVER_ADDR'] || $node['address'] == $_SERVER['SERVER_ADDR']) {

                        $thisInstance = "[This Instance] ";
                    }
                ?>
                <option value="<?= $node['hostname'].'|'.$node['address'] ?>">
                    <?= $thisInstance ?>
                    <?= empty($node['hostname']) ? $node['address'] : "{$node['hostname']} ({$node['address']})" ?>
                </option>
                <?php } ?>
            </select>
        </div>
        <div class="well" style="margin: 10px 0; min-width: 400px; width: fit-content; line-height: 20px;">
            <div><span id="ncpa_listener-status" class="status" style="margin-right: 5px;"><i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i></span> <?= _('NCPA Active Check Listener') ?> <span data-service="ncpa_listener" class="service-actions" id="ncpa_listener-actions"></span></div>
            <div><span id="ncpa_passive-status" class="status" style="margin-right: 5px;"><i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i></span> <?= _('NCPA Passive Check Sender') ?> <span data-service="ncpa_passive" class="service-actions" id="ncpa_passive-actions"></span></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    // Required by status-check.js functions
    var apikey = '<?= $apikey ?>';

    $(document).ready(function() {

        // FIX THIS!!!!
        var nodeList = ['<?= implode("', '", $nodeList);?>'];

        $('#system-profile').click(function() {
            window.location.href = site_url+'api/system/get_system_profile';
        });

        $('.save-config').click(function() {
            var endpoint = $(this).data('endpoint');
            var value = $(this).siblings('input.form-control').val();

            $(this).prop('disabled', true);
            $(this).html('<i class="fa fa-save"></i> <?= _("Saving...") ?>');

            save(endpoint, value)
        });


        // Depends on var nodeList.
        function save(endpoint, value) {
            var addr
            var url;

            for (idx in nodeList) {
                key = nodeList[idx];

                $.post(site_url + "/api/system/set_token", { key: endpoint, value: value, token: '<?= $apikey ?>' }, function(data) {
                    $('.save-config').prop('disabled', false);
                    $('.save-config').html('<i class="fa fa-save"></i> <?= _("Save") ?>');

                    if (data.error || data.status) {
                        show_error(data.message);
                        return;
                    }

                    show_info(data.message);
                }, 'json')
                .fail(function(response) {
                    // Catch failure, such as the server is down/not responding.
                    show_error(response.statusText);
                    // Return or keep going?
                    //return;
                });
            }
        }

        $('.generate-random').click(function () {
            $(this).siblings('.form-control').val(generate_random());
        });

        // Add changing the selection box
        $('#node-select').change(function() {
            clear_all_status();

            var key = $(this).val();

            check_service(key, 'ncpa_listener');
            check_service(key, 'ncpa_passive');
        });

        // Do ajax calls to update service information
        check_all_services();

        // Bind click action for starting/stopping/restarting
        $('.service-actions').bind('click', 'a', run_action);
    });

    function show_error(msg) {
        $('#alert-message').html(msg);
        $('#create-alert-message').addClass('alert-danger').show();
    }

    function show_info(msg) {
        $('#alert-message').html(msg);
        $('#create-alert-message').addClass('alert-info').show();
    }

    function generate_random() {
        var alphabet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_.";
        var value = [];

        for (var i=0; i < 32; i++) {
            var alpha_index = Math.floor(Math.random() * 31);
            value[i] = alphabet[alpha_index];
        }

        return value.join("");
    }

    function check_all_services()
    {
        var key = $('#node-select option:selected').val();

        check_service(key, 'ncpa_listener');
        check_service(key, 'ncpa_passive');
    }

    // For status-check.js
    var base_url = "<?= base_url() ?>";

    var stopText = "<?= _('Stop') ?>";
    var startText = "<?= _('Start') ?>";
    var restartText = "<?= _('Restart') ?>";

</script>

<script type="text/javascript" src="<?= base_url('media') ?>/js/status-check.js"></script>

<?= $footer ?>