<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <h1><?php echo _('Proxy Configuration'); ?></h1>
        <p>
            <?php echo _('These proxy settings, when enabled, <i>only</i> apply to internal Log Server calls back to Nagios. The calls include update checks, maintenance checks, and activation.'); ?>
        </p>

        <?php if (!empty($success)) { ?><div class="alert alert-info" style="margin: 10px 0 20px 0;"><?php echo $success; ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger" style="margin: 10px 0 20px 0;"><?php echo $error; ?></div><?php } ?>

        <?php echo form_open('admin/proxy', array("class" => "form-horizontal")); ?>
        <div class="checkbox" style="margin: 10px 0;">
            <label>
                <input type="checkbox" name="use_proxy" <?php if (get_option('use_proxy', 0)) { echo 'checked'; } ?> value="1"> <?php echo _("Enable proxy for update checks, maintenance checks, and activation"); ?>
            </label>
        </div>
        <h5><?php echo _('Proxy Settings'); ?></h5>
        <div class="form-group">
            <label class="col-sm-3 col-lg-2 col-xl-1 control-label" for="proxy_address"><?php echo _("Proxy Address"); ?>:</label>
            <div class="col-sm-6">
                <input type="text" name="proxy_address" value="<?php echo htmlentities(get_option('proxy_address'), ENT_COMPAT, 'UTF-8'); ?>" style="width: 300px;" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="col-sm-3 col-lg-2 col-xl-1 control-label" for="proxy_port"><?php echo _("Proxy Port"); ?>:</label>
            <div class="col-sm-6">
                <input type="text" name="proxy_port" value="<?php echo htmlentities(get_option('proxy_port'), ENT_COMPAT, 'UTF-8'); ?>" style="width: 70px;" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="col-sm-3 col-lg-2 col-xl-1 control-label" for="proxy_auth"><?php echo _("Proxy Auth"); ?>:</label>
            <div class="col-sm-6">
                <input type="text" name="proxy_auth" value="<?php echo htmlentities(get_option('proxy_auth'), ENT_COMPAT, 'UTF-8'); ?>" placeholder="username:password" class="form-control">
            </div>
        </div>
        <div class="form-group">
            <label class="col-sm-3 col-lg-2 col-xl-1 control-label"></label>
            <div class="col-sm-6 checkbox">
                <label>
                    <input type="checkbox" name="proxy_tunnel" <?php if (get_option('proxy_tunnel', 1)) { echo 'checked'; } ?> value="1"> <?php echo _("Use HTTP Tunnel"); ?>
                </label>
            </div>
        </div>
        <div style="margin-top: 30px;">
            <button type="submit" class="btn btn-sm btn-primary"><?php echo _("Save Settings"); ?></button>
        </div>
        <?php echo form_close(); ?>

    </div>
</div>

<?php echo $footer; ?>