<?php echo $header; ?>

<script>
var lastChecked;
function add_checkbox_magic() {
    var $chkboxes = $('input[name="sel"]');
    $chkboxes.click(function(e) {
        if (!lastChecked) {
            lastChecked = this;
            return;
        }
        if (e.shiftKey) {
            var start = $chkboxes.index(this);
            var end = $chkboxes.index(lastChecked);
            $chkboxes.slice(Math.min(start,end), Math.max(start,end)+ 1).prop('checked', lastChecked.checked);
        }
        lastChecked = this;
    });
}
$(document).ready(function() {
    add_checkbox_magic();

    $('.cb-toggle').click(function() {
        var repo_name = this.value;
        if ($(this).is(':checked')) {
            $('input.'+repo_name+'[name="sel"]').prop('checked', true);
        } else {
            $('input.'+repo_name+'[name="sel"]').prop('checked', false);
        }
    });
    $('.cb-toggle-delete').click(function() {
        if ($(this).is(':checked')) {
            $('input.rsi.rsi-delete').prop('checked', true);
        } else {
            $('input.rsi.rsi-delete').prop('checked', false);
        }
    })

    if ($('.no-repos-configured').length !== 0) {
        $("a[href='#settings']").click();
    }

    $('#restore-modal').on('hidden.bs.modal', function() {
        $('select.action-restore-indices').val('');
    });

    $('input.date-picker').datetimepicker();
});
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="well report-header">
            <?php echo form_open('admin/snapshots', array('class' => 'form-inline')); ?>
                <h1 class="fl"><?php echo _("Snapshots &amp; Maintenance"); ?></h1>
                <div class="fl">
                    <div class="input-group">
                        <div class="input-group-addon"><?php echo _('Time Frame'); ?></div>
                        <div class="input-group-addon date-picker"><?php echo _('From'); ?></div>
                        <input type="text" class="form-control date-picker" id="from_date" name="from_date" value="<?php echo $selected_from_date; ?>">
                        <div class="input-group-addon date-picker"><?php echo _('to'); ?></div>
                        <input type="text" class="form-control date-picker" id="to_date" name="to_date" value="<?php echo $selected_to_date; ?>">
                    </div>
                    <button type="submit" class="btn btn-sm btn-default"><i class="fa fa-filter fa-l"></i> <?php echo _('Filter'); ?></button>
                    <i class="fa fa-question-circle fa-help tt-bind va-m fa-" data-placement="bottom" title="<?php echo _("Note that Snapshots contain all indices open when they were created, so indexes from slightly outside the Time Frame may appear."); ?>">  </i>
                </div>
            <?php echo form_close(); ?>
            <div class="clear"></div>
        </div>

        <?php if (!empty($msg_html)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?> alert-margin">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <?php echo $msg_html; ?>
        </div>
        <?php } ?>

        <div class="container-fluid mt-10" id="workspace">

            <div class="tab-content">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="nav nav-tabs">
                            <li class="active"><a href="#snapshots" data-toggle="tab"><i class="fa fa-hdd-o fa-14 mr-5"></i><?php echo _("Snapshots"); ?></a></li>
                            <li><a href="#settings" data-toggle="tab"><i class="fa fa-wrench fa-14 mr-5"></i><?php echo _("Maintenance and Repository Settings"); ?></a></li>
                        </ul>
                    </div>
                </div>
                <br>
                <li class="tab-pane active" id="snapshots">
                    <div class="row">
                        <?php if (count($repositories) == 0): ?>
                            <div class="col-sm-12">
                                <div class="no-repos-configured alert alert-warning"><?php echo _("No repositories configured! Please go to the 'Maintenance and Repository Settings' tab."); ?></div>
                            </div>
                        <?php endif; ?>
                        <?php foreach ($repositories as $name => $repository): ?>
                        <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                        <div class="col-sm-12">
                            <div class="grid">
                                <div class="grid-title">
                                    <div class="pull-left">
                                        <div class="table-title"><i class="fa fa-archive"></i></div>
                                        <span><?php echo "$name"?></span>
                                        <div class="clearfix"></div>
                                    </div>
                                    <?php if (count($repositories) > 1): ?>
                                    <div class="pull-right">
                                        <span class="table-title hide-grid" title="<?php echo _("Hide"); ?>"><i class="fa fa-eye-slash"></i></span>
                                    </div>
                                    <?php endif; ?>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="grid-content overflow">
                                    <table class="table table-striped table-hover table-bordered center-table">
                                        <thead>
                                            <tr>
                                                <th><input type="checkbox" class="cb-toggle w-28" value="<?php echo str_replace(' ', '-', $name);?>"></th>
                                                <th><?php echo _("Index");?></th>
                                                <th><?php echo _("Most Recent State");?></th>
                                                <th><?php echo _("Most Recent Snapshot Time");?></th>
                                                <th><?php echo _("Versions ");?><i class="fa fa-question-circle fa-help tt-bind" data-placement="bottom" title="<?php echo _("Number of Snapshots that include this Index"); ?>"></i></th>
                                                <th class="snapshot-actions"><?php echo _("Actions"); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody class="snapshots">
                                            <?php if (count($repository['indices']) == 0): ?>

                                                <td colspan="7"><?php echo _('No backups yet!'); ?></td>

                                            <?php endif;?>

                                            <?php
                                            foreach ($repository['indices'] as $index => $index_data) {
                                                $unique = uniqid();
                                            ?>
                                            <tr>
                                                <td class="w-28"><input type="checkbox" name="sel" class="<?php echo str_replace(' ', '-', $name);?>" id="<?php echo $unique;?>" value="<?php echo $index;?>"></td>
                                                <td><label for="<?php echo $unique;?>" class="fw-400"><?php echo $index; ?></label></td>
                                                <td><label for="<?php echo $unique;?>" class="fw-400"><?php echo $index_data[0]->{"state"};?></label></td>
                                                <td><label for="<?php echo $unique;?>" class="fw-400"><?php echo date("Y-m-d H:i:s", $index_data[0]->{"start_time_in_millis"}/1000); ?></label></td>
                                                <td><label for="<?php echo $unique;?>" class="fw-400"><?php echo count($index_data);?></label></td>
                                                <td>
                                                    <button class="btn btn-xs btn-default restore-index" data-repo="<?php echo $name; ?>" data-index="<?php echo $index; ?>" data-other='<?php echo json_encode($index_data); ?>' type="button">
                                                        <input name="repository" type="hidden" value="<?php echo $name; ?>"/>
                                                        <input name="index" type="hidden" value="<?php echo $index; ?>"/>
                                                        <i class="fa fa-refresh"></i> <?php echo _("Restore"); ?>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                    <div class="mt-10">
                                        <?php echo _("With Selected:");?>
                                        <select class="action-restore-indices form-control" data-repo="<?php echo $name;?>">
                                            <option></option>
                                            <option value="restore"><?php echo _("Restore"); ?></option>
                                        </select>
                                        <button class="btn btn-default show-delete-snapshots fr" data-repo="<?php echo $name;?>" data-snapshots='<?php echo json_encode($repository["snapshots"]);?>'><i class="fa fa-trash-o"></i> <?php echo _("Delete Snapshots"); ?></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </li>
                <li class="tab-pane" id="settings">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="grid">
                                <div class="grid-title">
                                    <div class="pull-left">
                                        <div class="table-title"><i class="fa fa-wrench"></i></div>
                                        <span><?php echo _("Maintenance Settings"); ?></span>
                                        <div class="clear"></div>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                                <div id="maintenance" class="grid-content">
                                <?php echo form_open('admin/snapshots'); ?>
                                    <table class="table table-striped table-hover table-bordered">
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <?php echo _("Delete audit log entries older than"); ?>
                                                    <?php echo question_tooltip(_('Delete entries from the Nagios Log Server audit log found under Admin > Reports > Audit. Set to 0 to disable. Decimal values down to ".0001" supported for deleting data less than a day old.')); ?>
                                                </td>
                                                <td>
                                                    <input name="maintenance_settings[audit_retention]" type="text" class="form-control width-50p" value="<?php echo htmlentities($maintenance_settings['audit_retention'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo _("Delete alert history older than"); ?>
                                                    <?php echo question_tooltip(_('Delete entries from the Alert History found under Alerting > Alerting > Alert History. Set to 0 to disable. Decimal values down to ".0001" supported for deleting data less than a day old.')); ?>
                                                </td>
                                                <td>
                                                    <input name="maintenance_settings[alert_retention]" type="text" class="form-control width-50p" value="<?php echo htmlentities($maintenance_settings['alert_retention'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo _("Optimize Indexes older than"); ?>
                                                    <?php echo question_tooltip(_('Performs a Lucene forceMerge on indexes where no new data will be ingested. Set to 0 to disable.')); ?>
                                                </td>
                                                <td>
                                                    <input name="maintenance_settings[optimize_time]" type="text" class="form-control width-50p" value="<?php echo htmlentities($maintenance_settings['optimize_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo _("Close indexes older than"); ?>
                                                    <?php echo question_tooltip(_('Marks indexes older that this value as closed. Closed indices do not take any system resources other than disk space, however are not searchable unless re-opened. Set to 0 to disable.')); ?>
                                                </td>
                                                <td>
                                                    <input name="maintenance_settings[close_time]" type="text" class="form-control width-50p" value="<?php echo htmlentities($maintenance_settings['close_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo _("Delete indexes older than"); ?>
                                                    <?php echo question_tooltip(_('Deletes indexes older than this value, freeing resources. This is permanant, the only way to restore a deleted index is from an archived snapshot. Set to 0 to disable.')); ?>
                                                </td>
                                                <td>
                                                    <input name="maintenance_settings[delete_time]" type="text" class="form-control width-50p" value="<?php echo htmlentities($maintenance_settings['delete_time'], ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><?php echo _("Repository to store snapshots in"); ?> <?php echo question_tooltip(_('Repository to store the snapshots of indexes.')); ?></td>
                                                <?php if(!empty($repositories)): ?>
                                                <td><select name="maintenance_settings[repository]" class="form-control max-400">
                                                    <option value=""></option>
                                                    <?php foreach ($repositories as $name => $respsitory) { ?>
                                                    <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                                                    <option value="<?php echo $name; ?>" <?php if (@$maintenance_settings['repository'] == $name) { echo 'selected'; } ?>><?php echo $name; ?></option>
                                                    <?php } ?>
                                                    </select></td>
                                                <?php else: ?>
                                                <td><?php echo _('You must first create a repository on the right.'); ?></td>
                                                <?php endif; ?>
                                            </tr>
                                            <tr>
                                                <td><?php echo _("Delete snapshots older than"); ?> <?php echo question_tooltip(_('Number of days before snapshots are deleted.')); ?></td>
                                                <td>
                                                <?php if(!empty($repositories)): 
                                                    $delete_snapshot_time = isset($maintenance_settings['delete_snapshot_time']) ? $maintenance_settings['delete_snapshot_time'] : '720';?>
                                                    <input name="maintenance_settings[delete_snapshot_time]" type="text" class="form-control width-50p" value="<?php echo htmlentities($delete_snapshot_time, ENT_QUOTES, 'UTF-8'); ?>" /> <?php echo _('days'); ?>
                                                <?php else: ?>
                                                    <?php echo _('You must first create a repository on the right.'); ?>
                                                <?php endif; ?>
                                            </tr>
                                            <tr>
                                                <td><?php echo _("Enable Maintenance and Snapshots"); ?> <?php echo question_tooltip(_('Enable or disable processing of all scheduled maintenance jobs.')); ?></td>
                                                <td>
                                                    <div class="radio snapshot-radio">
                                                        <label><input type="radio" name="maintenance_settings[active]" value="1" <?php if ($maintenance_settings['active']) { echo "checked"; } ?>> <?php echo _('Yes'); ?></label>
                                                        <label><input type="radio" name="maintenance_settings[active]" value="0" <?php if (!$maintenance_settings['active']) { echo "checked"; } ?>> <?php echo _('No'); ?></label>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <?php echo _("Last modified"); ?> <?php echo question_tooltip(_('The last time these settings were updated. If unknown, save to update last modified time.')); ?>
                                                </td>
                                                <td>
                                                    <?php if (!empty($maintenance_settings['last_modified'])) { echo date('r', $maintenance_settings['last_modified']); } else { echo _("Unknown"); } ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td></td>
                                                <td><button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="maintenance" class="btn btn-sm btn-primary"><?php echo _('Save Settings'); ?></button></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <?php echo form_close(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="grid">
                                <div class="grid-title">
                                    <div class="pull-left max-150">
                                        <div class="table-title"><i class="fa fa-hdd-o"></i></div>
                                        <span><?php echo _("Repositories"); ?></span>
                                        <div class="clearfix"></div>
                                    </div>
                                    <div class="pull-right">
                                        <span><button class="btn btn-xs btn-create-repo btn-info" type="button"><i class="fa fa-database fa-l"></i> <?php echo _("Create Repository"); ?></button></span>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                                <div class="grid-content overflow">
                                    <table class="table table-striped table-hover table-bordered center-table">
                                        <thead>
                                            <tr>
                                                <th><?php echo _("Name"); ?></th>
                                                <th><?php echo _("Location"); ?></th>
                                                <th><?php echo _("Type"); ?></th>
                                                <th><?php echo _("Size"); ?></th>
                                                <th class="width-80"><?php echo _("Actions"); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            if (count($repositories) > 0) {
                                            foreach ($repositories as $name => $respsitory): ?>
                                            <?php $name = htmlentities($name, ENT_QUOTES, 'UTF-8');?>
                                            <tr>
                                                <td><?php echo $name; ?></td>
                                                <td><?php echo $respsitory['settings']['location']; ?></td>
                                                <td><?php if ($respsitory['type'] == 'fs') { echo _("Filesystem"); } else { echo $respsitory['type']; } ?></td>
                                                <td><?php echo $respsitory['size']; ?></td>
                                                <td>
                                                    <button class="btn btn-xs btn-default delete-repository" type="button">
                                                        <input type="hidden" value="<?php echo $name; ?>"/>
                                                        <i class="fa fa-times-circle"></i> <?php echo _("Delete"); ?>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach;
                                            } else { ?>
                                            <tr>
                                                <td colspan="9"><?php echo _("No repositories have been created."); ?></td>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                    <div class="clear"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
            </div>
        </div>
    </div>
</div>

<div class="modal hide" id="create-repo-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <?php echo form_open('admin/snapshots'); ?>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _('Create Repository'); ?></h2>
            </div>
            <div class="modal-body">
                <p class="mb-5"><?php echo _('This location <b>MUST</b> be a shared filesystem accessible to all data instances in the cluster. If not, snapshots or restoration can fail.'); ?></p>
                <div id="repo_form" class="form-horizontal">
                    <table class="table table-striped table-bordered">
                        <tbody>
                            <tr>
                                <td><?php echo _('Repository Name'); ?>:</td>
                                <td><input name="repository_name" type="text" class="form-control" value="<?php if (!empty($repo['name'])) { echo htmlentities($repo['name'], ENT_COMPAT, 'UTF-8'); } ?>" /></td>
                            </tr>
                            <tr>
                                <td><?php echo _('Repository Location'); ?>:</td>
                                <td><input name="repository_location" type="text" class="form-control" value="<?php if (!empty($repo['location'])) { echo htmlentities($repo['location'], ENT_COMPAT, 'UTF-8'); } ?>" /></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" value="1" name="addrepo" class="btn btn-sm btn-primary"><?php echo _('Add Repository'); ?></button>
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<div class="modal hide" id="indexes-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _('Indexes in Snapshot'); ?>: <span class="snapshot-time"></span></h2>
            </div>
            <div class="modal-body">
                <table class="table table-condensed table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th><?php echo _('Index Name'); ?></th>
                        </tr>
                    </thead>
                    <tbody class="indexes-modal-list">
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal hide" id="restore-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _('Select Indices to Restore'); ?></h2>
            </div>
            <div class="modal-body">
                <div>
                    <?php echo sprintf(_('Restoring %s from time:'), '<b><span class="restore-index-name"></span></b>'); ?>
                </div>
                <div class="modal-body-container">
                    <table class="table table-condensed table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th colspan="2">
                                    <label><?php echo _('Choose one:') ?></label>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="restore-snapshots">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" class="restore-repo">
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
                <button class="btn btn-sm btn-primary" id="do-restore" data-loading-text="<?php echo _('Restoring'); ?>..."><?php echo _('Restore Index'); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal hide" id="delete-snapshot-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _('Select Snapshots to Delete'); ?></h2>
            </div>
            <div class="modal-body">
                <div>
                    <?php echo _('Deleting from repository'); ?> <b><span class="repo-name"></span></b>
                </div>
                <div class="modal-body-container">
                    
                </div>
                <div>
                    <table class="table table-condensed table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="cb-toggle-delete"></th>
                                <th>
                                    <label><?php echo _('Select which snapshots to delete:') ?></label>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="delete-snapshots">
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" class="restore-repo">
                <p class="deletion-progress fl"></p>
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Close'); ?></button>
                <button class="btn btn-sm btn-primary" id="do-delete-snapshots" data-loading-text="<?php echo _('Deleting'); ?>..."><?php echo _('Delete Snapshot'); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
