<?= $header ?>

<script type="text/javascript">
$(document).ready(function() {

    $('#system-profile').click(function() {
        window.location.href = site_url+'api/system/get_system_profile';
    });

});
</script>

<div class="configure-layout">
    <?= $leftbar ?>
    <div class="rside">

        <h1><?= _('System Status') ?></h1>
        <p><?= _('The system status shows the important required components statuses and allows you to start/stop/restart them from the web UI.') ?></p>
        <p><button type="button" id="system-profile" class="btn btn-sm btn-default"><i class="fa fa-download fa-l"></i> <?= _('Download System Profile') ?></button></p>

        <?php if (!empty($success)) { ?><div class="alert alert-success"><?= $success ?></div><?php } ?>
        <?php if (!empty($error)) { ?><div class="alert alert-danger"><?= $error ?></div><?php } ?>

        <h3><?= _('Subsystems') ?></h3>
        <div class="input-group" style="width: 460px;">
            <span class="input-group-addon"><?= _("Instance") ?></span>

            <select id="node-select" class="form-control">
                <?php foreach ($nodes as $node) {
                    $thisInstance = '';

                    # SERVER_ADDR may be localhost or the inet6 address, so check HTTP_HOST, as well.
                    # The value returned by HTTP_HOST and SERVER_ADDR may be the hostname or an ip, so check both.
                    # NOTE: I was changing /etc/hosts and hostname via hostnamectl, so this may not be correct.
                    if ($node['hostname'] == $_SERVER['HTTP_HOST']   || $node['address'] == $_SERVER['HTTP_HOST'] ||
                        $node['hostname'] == $_SERVER['SERVER_ADDR'] || $node['address'] == $_SERVER['SERVER_ADDR']) {

                        $thisInstance = "[This Instance] ";
                    }
                ?>
                <option value="<?= $node['hostname'].'|'.$node['address'] ?>">
                    <?= $thisInstance ?>
                    <?= empty($node['hostname']) ? $node['address'] : "{$node['hostname']} ({$node['address']})" ?>
                </option>
                <?php } ?>
            </select>
        </div>
        <div class="well" style="margin: 10px 0; min-width: 400px; width: fit-content; line-height: 20px;">
            <div><span id="elasticsearch-status" class="status" style="margin-right: 5px;"><i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i></span> <?= _('Elasticsearch Database') ?> <span data-service="elasticsearch" class="service-actions" id="elasticsearch-actions"></span></div>
            <div><span id="logstash-status" class="status" style="margin-right: 5px;"><i class="fa fa-spinner fa-pulse fa-fw fa-loader"></i></span> <?= _('Logstash Collector') ?> <span data-service="logstash" class="service-actions" id="logstash-actions"></span></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    // Required by status-check.js functions
    var apikey = '<?= $apikey ?>';

    $(document).ready(function() {

        // Add changing the selection box
        $('#node-select').change(function() {
            clear_all_status();

            var key = $(this).val();

            check_service(key, 'logstash');
            check_service(key, 'elasticsearch');
        });

        // Do ajax calls to update service information
        check_all_services();

        // Bind click action for starting/stopping/restarting
        $('.service-actions').bind('click', 'a', run_action);
    });

    function check_all_services()
    {
        var key = $('#node-select option:selected').val();

        check_service(key, 'logstash');
        check_service(key, 'elasticsearch');
    }

    // For status-check.js
    var base_url = "<?= base_url() ?>";

    var stopText = "<?= _('Stop') ?>";
    var startText = "<?= _('Start') ?>";
    var restartText = "<?= _('Restart') ?>";

</script>

<script type="text/javascript" src="<?= base_url('media') ?>/js/status-check.js"></script>

<?= $footer ?>