<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <h1><?php echo _('Unique Hosts'); ?></h1>
                    <p><?php echo _('Showing logs received from hosts in the last 24 hours.'); ?></p>
                    <p><?php if (count($hosts) > 0) { echo _('Amount of hosts') . ": <b>" . number_format(count($hosts)) . "</b>"; } ?></p>

                    <table class="table table-striped table-condensed table-bordered table-auto-width" style="margin-top: 10px; min-width: 300px;">
                        <thead>
                            <tr>
                                <th><?php echo _("IP Address (Hostname)"); ?></th>
                                <th><?php echo _("Log Count"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $ci =& get_instance();
                            $ci->load->helper('network');
                            foreach ($hosts as $host => $logs) {
                                $hostname = dns_reverse_lookup($host);
                                $display = $host;
                                if (!empty($hostname) && $hostname != $host) {
                                    $display = htmlentities($host . " (" . $hostname . ")", ENT_QUOTES, 'UTF-8');
                                }
                                $query = $host;
                                $query = '"' . $query . '"';
                            ?>
                            <tr>
                                <td><a href="<?php echo site_url('dashboard#/dashboard/script/logserver.js?query=host:'.urlencode($query)); ?>"><?php echo $display; ?></a></td>
                                <td><?php echo number_format($logs); ?></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <?php if (count($not_sending) > 0) { ?>
                    <div style="margin-top: 10px;">
                        <h2><?php echo _('Not Sending'); ?></h2>
                        <p>
                            <?php echo _('This is a list of hosts that Log Server has received logs from in the past. Hosts in this list did not send any logs during the hourly log sending check.'); ?><br>
                            <?php echo _('Last sending check was') . " " . date('r', get_option('known_hosts_last_check')) . "."; ?>
                        </p>
                        <table class="table table-striped table-condensed table-bordered table-auto-width" style="margin-top: 10px; min-width: 300px;">
                            <thead>
                                <tr>
                                    <th><?php echo _("IP Address (Hostname)"); ?></th>
                                    <th><?php echo _("Last Sending Check") . " " . question_tooltip(_('This is the time of the last check that returned logs for the host.')); ?></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($not_sending as $host => $time) {
                                    $hostname = dns_reverse_lookup($host);
                                    $display = $host;
                                    if (!empty($hostname) && $hostname != $host) {
                                        $display = htmlentities($host . " (" . $hostname . ")", ENT_QUOTES, 'UTF-8');
                                    }
                                    $query = $host;
                                    if (strpos($query, ':') !== false) { $query = '"' . $query . '"'; }
                                ?>
                                <tr>
                                    <td><a href="<?php echo site_url('dashboard#/dashboard/script/logserver.js?from=1h&query=host:'.urlencode($query)); ?>"><?php echo $display; ?></a></td>
                                    <td><?php echo date('r', $time); ?></td>
                                    <td><a href="<?php echo site_url('admin/hosts/remove/'.urlencode($host)); ?>"><i class="fa fa-14 fa-times tt-bind" data-placement="right" title="<?php echo _("Remove"); ?>"></i></a></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>