<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    update_datetimepicker();
    $('input.date-picker').datetimepicker();

    $('select[name="time"]').change(function() {
        update_datetimepicker();
    });

    $('.show-query').click(function() {
        var id = $(this).data('id');
        $.get('<?php echo site_url("api/check/history_alert_query"); ?>', { id: id }, function(data) {
            if (data.error) {
                alert(data.error);
            } else {
                $('#query').html(JSON.stringify(JSON.parse(data._source.query), null, 4));
                $('#show-query').modal('show');
            }
        });
    });

    if ($('#form_deleted_alert').val()) {
        $('#form_alert').val("");
    }

    $('#form_alert').change(function() {
        $('#form_deleted_alert').val('');
    });
    $('#form_deleted_alert').change(function() {
        $('#form_alert').val('');
    });

    $('#trim-alert-history').click(function(e) {
        e.preventDefault();
        $.post(site_url+'api/system/trim_history', { type: 'alert' }, function(data) {
            data = JSON.parse(data);
            if (data.error.length) {
                alert(data.error);
            } else if (data.curl_response.length) {
                var response = JSON.parse(data.curl_response);
                if (response._indices.nagioslogserver_history._shards.failed == 0) {
                    alert('Trimmed Alert History to remove entries older than ' + data.days_to_trim + ' days.');
                }
            }
        });
    });
});


function update_datetimepicker() {
    if ($('.time-select').val() == 'c') {
        $('.date-picker').show();
    } else {
        $('.date-picker').hide();
    }
}
</script>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="well report-header">
            <h1 class="fl"><?php echo _("Alert History"); ?></h1>
            <?php echo form_open('alerts/history', array('class' => 'form-inline fl', 'method' => 'get')); ?>
                <div class="input-group">
                    <div class="input-group-addon"><?php echo _('Time Frame'); ?></div>
                    <select class="form-control time-select" name="time">
                        <option value="24h"<?php if ($time == '24h' || $time == '') { echo ' selected'; } ?>><?php echo _('Last 24 Hours'); ?></option>
                        <option value="7d"<?php if ($time == '7d') { echo ' selected'; } ?>><?php echo _('Last 7 Days'); ?></option>
                        <option value="30d"<?php if ($time == '30d') { echo ' selected'; } ?>><?php echo _('Last 30 Days'); ?></option>
                        <option value="c"<?php if ($time == 'c') { echo ' selected'; } ?>><?php echo _('Custom'); ?></option>
                    </select>
                    <div class="input-group-addon date-picker"><?php echo _('From'); ?></div>
                    <input type="text" name="start" class="form-control date-picker" value="<?php if (!empty($start)) { echo $start; } ?>">
                    <div class="input-group-addon date-picker"><?php echo _('to'); ?></div>
                    <input type="text" name="end" class="form-control date-picker" value="<?php if (!empty($end)) { echo $end; } ?>">
                </div>
                <div class="input-group">
                    <div class="input-group-addon"><?php echo _('Alert'); ?></div>
                    <select class="form-control" id="form_alert" name="alert">
                        <option value="[showing-history-for-all-alerts]"><?php echo _('All'); ?></option>
                        <?php $found_alert = false; ?>
                        <?php foreach ($alerts as $alert) { ?>
                        <option value="<?php echo $alert['id']; ?>"<?php if ($alert_id == $alert['id']) { $found_alert = true; echo ' selected'; } ?>><?php echo html_escape($alert['name']); ?></option>
                        <?php } ?>
                        <option value=""><?php echo _('[Using Deleted Alerts]'); ?></option>
                    </select>
                </div>
                <div class="input-group">
                    <div class="input-group-addon"><?php echo _('Deleted Alert'); ?></div>
                    <select class="form-control" id="form_deleted_alert" name="deleted_alert">
                        <option value=""><?php echo _("[Using Alert Selector]"); ?></option>
                        <?php foreach ($deleted_alerts as $alert) { 
                        $alert = $alert['_source'];?>
                        <option value="<?php echo $alert['id']; ?>"<?php if ($alert_id == $alert['id']) { echo ' selected'; } ?>><?php echo html_escape($alert['name']); ?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="input-group">
                    <div class="input-group-addon"><?php echo _('Status'); ?></div>
                    <select class="form-control" name="status">
                        <option value=""><?php echo _('All'); ?></option>
                        <option value="0"<?php if ($status === '0') { echo ' selected'; } ?>><?php echo _('OK'); ?></option>
                        <option value="1"<?php if ($status == 1) { echo ' selected'; } ?>><?php echo _('WARNING'); ?></option>
                        <option value="2"<?php if ($status == 2) { echo ' selected'; } ?>><?php echo _('CRITICAL'); ?></option>
                        <option value="3"<?php if ($status == 3) { echo ' selected'; } ?>><?php echo _('UNKNOWN'); ?></option>
                    </select>
                </div>
                <button type="submit" class="btn btn-sm btn-default"><i class="fa fa-filter fa-l"></i> <?php echo _('Filter'); ?></button>
                <button id="trim-alert-history" class="btn btn-sm btn-default"><i class="fa fa-scissors fa-l"></i> <?php echo _('Trim Alert History'); ?></button>
            <?php echo form_close(); ?>
            <div class="clear"></div>
        </div>

        <div class="table-bar">
            <?php
            if (!empty($record_total)) {
                echo '<span style="display: inline-block;">' . _('Page') . ' ' . $page . ' of ' . $total_pages . ' &nbsp;&middot;&nbsp; ';
                if (!empty($limiting)) {
                    echo $limiting . ' (' .  number_format($record_total) .  ' ' . _('total records') . ')';
                } else {
                    echo number_format($record_total) .  ' ' . _('records');
                }
                echo '</span>';
            } else {
                echo '<span style="display: inline-block;">0 ' . _(' records') . '</span>';
            }
            ?>
            <div class="page-numbers fr">
                <?php echo $pagination; ?>
            </div>
            <div class="clear"></div>
        </div>

        <table class="table table-striped table-condensed table-bordered">
            <thead>
                <th><?php echo _('Alert Name'); ?></th>
                <th style="width: 240px;"><?php echo _('Run Time'); ?></th>
                <th style="width: 90px;"><?php echo _('Status'); ?></th>
                <th><?php echo _('Alert Output'); ?></th>
                <th style="width: 70px;"><?php echo _('Interval'); ?></th>
                <th style="width: 70px;"><?php echo _('Lookback'); ?></th>
                <th style="width: 70px;"><?php echo _('Warning'); ?></th>
                <th style="width: 70px;"><?php echo _('Critical'); ?></th>
                <th style="width: 90px; text-align: center;"><?php echo _('Actions'); ?></th>
            </thead>
            <tbody id="alert-list">
                <?php
                if (!empty($halerts)) {
                    foreach ($halerts as $alert) {
                        $status = get_alert_status($alert['status']);
                ?>
                <tr>
                    <td><?php echo html_escape($alert['name']); ?></td>
                    <td><?php echo date('r', $alert['ran']); ?></td>
                    <td class="status-output <?php echo $status; ?>"><?php echo $status; ?></td>
                    <td><?php echo $alert['output']; ?></td>
                    <td><?php echo $alert['check_interval']; ?></td>
                    <td><?php echo $alert['lookback_period']; ?></td>
                    <td><?php echo $alert['warning']; ?></td>
                    <td><?php echo $alert['critical']; ?></td>
                    <td class="actions">
                        <?php if (!array_key_exists('alert_type', $alert) || $alert['alert_type'] === 'query') { ?>
                        <a data-placement="left" data-id="<?php echo $alert['id']; ?>" target="_new" class="show-query ls-tooltip" title="<?php echo _("Show query"); ?>"><i class="fa fa-fw fa-search"></i></a>
                        <a href="<?php echo site_url('alerts/history/show/'.$alert['id']); ?>" data-placement="left" target="_new" class="ls-tooltip" title="<?php echo _("Show results"); ?>"><i class="fa fa-fw fa-list"></i></a>
                        <a href="<?php echo site_url('alerts/history/export/'.$alert['id']); ?>" data-placement="left" target="_new" class="ls-tooltip" title="<?php echo _("Download as CSV"); ?>"><i class="fa fa-fw fa-download"></i></a>
                        <?php } /* if alert type is query */ 
                        else {?>
                        <i class="fa fa-question-circle ls-tooltip" title="<?php echo _('Actions are only available for query-based alerts.'); ?>"></i>
                        <?php } ?>
                    </td>
                </tr>
                <?php
                    } 
                } else {
                ?>
                <tr>
                    <td colspan="9"><?php echo _("No alerts found."); ?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

        <div class="table-bar">
            <?php
            $url = (!empty($_SERVER['QUERY_STRING'])) ? 'alerts/history?' . $_SERVER['QUERY_STRING'] : 'alerts/history';
            echo form_open($url, array('class' => 'pp-form'));
            ?>
            <input type="hidden" name="pp" class="pp" value="<?php echo $page_size; ?>">
            <?php echo form_close(); ?>
            <div class="fl form-inline" style="margin-right: 4px;">
                <div class="input-group">
                    <label class="input-group-addon"><?php echo _('Results per page'); ?></label>
                    <select class="form-control results-per-page">
                        <option value="10"<?php if ($page_size == 10) { echo ' selected'; } ?>>10</option>
                        <option value="25"<?php if ($page_size == 25) { echo ' selected'; } ?>>25</option>
                        <option value="50"<?php if ($page_size == 50) { echo ' selected'; } ?>>50</option>
                        <option value="100"<?php if ($page_size == 100) { echo ' selected'; } ?>>100</option>
                        <option value="c"><?php echo _("Custom"); ?></option>
                        <?php if (!in_array($page_size, array(10, 25, 50, 100))) { echo '<option value="' . $page_size . '" selected>' . _('Custom') . ' - ' . $page_size . '</option>'; } ?>
                    </select>
                </div>
            </div>
            <div class="fl custom-box">
                <label>
                <input type="text" class="form-control custom" placeholder="#" value="">
                <button type="button" class="btn btn-sm btn-default save-custom"><?php echo _("Save"); ?></button>
                </label>
            </div>
            <div class="page-numbers fr">
                <?php echo $pagination; ?>
            </div>
            <div class="clear"></div>
        </div>

    </div>
</div>

<!-- Show a query -->
<div class="modal hide fade" id="show-query" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h2><?php echo _("Showing Query"); ?></h2>
            </div>
            <div class="modal-body">
                <pre id="query"></pre>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-sm btn-default" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>