<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div id="messages">
            <?php if (!empty($success)) { ?>
            <div class="alert alert-success"><?php echo $success; ?> <a class="close" data-dismiss="alert" href="#">&times;</a></div>
            <?php } ?>
        </div>

        <h1><?php echo _("Email Templates"); ?></h1>
        <div style="margin: 10px 0 20px 0;">
            <button class="btn btn-sm btn-default" id="add-template" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?>><i class="fa fa-plus"></i> <?php echo _("Add Template"); ?></button>
            <button class="btn btn-sm btn-default" id="view-macros" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?>> <?php echo _("View Macros"); ?></button>
        </div>

        <p>
            <b><?php echo _('Default Email Template'); ?></b> <i class="fa fa-question-circle ls-pop" title="<?php echo _('Default Email Template'); ?>" data-content="<?php echo _('The default template will be used when an alert is set to use \'default template\' or if the alerts was never given a template.'); ?>"></i> - <a id="view-default"><?php echo $default_template; ?></a> <?php if (user_has_permission('alerts', array('all')) ) { ?>- <a id="change-default"><i class="fa fa-pencil"></i> <?php echo _('Change'); ?></a><?php } ?>
        </p>

        <div>
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th><?php echo _("Template Name"); ?></th>
                        <th style="width: 220px;"><?php echo _("Last modified"); ?></th>
                        <th><?php echo _("Last modified by"); ?></th>
                        <th><?php echo _("Created by"); ?></th>
                        <th style="width: 60px; text-align: center;"><?php echo _("Actions"); ?></th>
                    </tr>
                </thead>
                <tbody id="template-list">
                </tbody>
            </table>
        </div>

    </div>
</div>

<!-- Manage a email template -->
<div class="modal hide fade" data-backdrop="static" id="manage-template" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h2><span class="template-action-type"><?php echo _("Add"); ?></span> <?php echo _("Email Template"); ?></h2>
            </div>
            <div class="modal-body">
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-danger" style="margin: 0 0 15px 0;">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
                <p style="margin-bottom: 10px;"><?php echo _("Manage email templates for alerts. You can use the macros below inside the email message and they will be populated before the message is sent."); ?></p>
                <div id="manage-template-alerts"></div>
                <div class="form-horizontal">
                    <div style="margin-bottom: 10px;">
                        <input class="form-control" style="width: 100%; font-size: 12px; line-height: 15px;" type="text" value="" id="tpl-name" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Template name'); ?>">
                    </div>
                    <div style="margin-bottom: 10px;">
                        <input class="form-control" style="width: 100%; font-size: 12px; line-height: 15px;" type="text" value="" id="tpl-subject" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Subject'); ?>">
                    </div>
                    <div>
                        <textarea class="form-control" style="width: 100%; min-height: 240px; font-size: 12px; line-height: 15px;" id="tpl-body" <?php if (!user_has_permission('alerts', array('all')) ) { echo 'disabled'; } ?> placeholder="<?php echo _('Message body'); ?>"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="fl">
                    <?php if (user_has_permission('alerts', array('all'))) { ?>
                    <div class="dropdown">
                        <button type="button" class="btn btn-sm btn-info" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo _('Load'); ?>
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="tpl-load-default"><?php echo _('System Default'); ?></a></li>
                            <li><a class="tpl-load-current-default"><?php echo _('Current Default'); ?></a></li>
                        </ul>
                    </div>
                    <?php } ?>
                </div>
                <div class="fl" style="margin-left: 8px;"><button type="button" id="clear" class="btn btn-sm btn-default"><?php echo _('Clear'); ?></button></div>
                <button class="btn btn-sm btn-primary template-action-type" id="manage-template-button" <?php if (!user_has_permission('alerts', array('all')) || is_demo_mode()) { echo 'disabled'; } ?>><?php echo _("Add"); ?></button>
                <a href="#" class="btn btn-sm btn-default" data-dismiss="modal"><?php echo _("Cancel"); ?></a>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>

<!-- View default email template -->
<div class="modal hide fade" id="view-default-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h2><?php echo _("Default Email Template"); ?></h2>
            </div>
            <div class="modal-body">
                <p style="margin-bottom: 5px;"><?php echo _("The template used for alerts with no template and alerts set to use default."); ?></p>
                <p style="margin-bottom: 5px; font-weight: bold;"><?php echo $default_template; ?></p>
                <div class="form-horizontal">
                    <div style="margin-bottom: 10px;">
                        <input class="form-control" style="width: 100%; font-size: 12px; line-height: 15px;" type="text" value="<?php echo $default_template_subject; ?>" placeholder="<?php echo _('Subject'); ?>" readonly>
                    </div>
                    <div>
                        <textarea class="form-control" style="width: 100%; min-height: 280px; font-size: 12px; line-height: 15px;" readonly><?php echo $default_template_body; ?></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-sm btn-default" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<!-- Template macros -->
<div class="modal hide fade" id="view-macros-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h2><?php echo _("Email Template Macros"); ?></h2>
            </div>
            <div class="modal-body">
                <p style="margin-bottom: 10px;"><?php echo _("The following macros will be interpreted before sending emails. If a macro is used for an alert with an unsupported type, it may be filled with irrelevant information."); ?></p>
                <table class="table table-condensed table-striped table-hover table-no-margin table-no-border">
                    <thead>
                        <tr>
                            <th style="font-weight: bold;"><?php echo _('Macro Name'); ?></th>
                            <th><?php echo _('Supported Types'); ?></th>
                            <th><?php echo _('Description'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="font-weight: bold;">%time%</td>
                            <td><?php echo _('Any'); ?></td>
                            <td><?php echo _('The time the alert was sent'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%alertname%</td>
                            <td><?php echo _('Any'); ?></td>
                            <td><?php echo _('The name of the alert that is sending a message'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%count%</td>
                            <td><?php echo _('Any'); ?></td>
                            <td><?php echo _("The total number of events");?></td>
                        <tr>
                            <td style="font-weight: bold;">%state%</td>
                            <td><?php echo _('Any'); ?></td>
                            <td><?php echo _('The state of the alert, OK, WARNING, CRITICAL, UNKNOWN'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%lookback%</td>
                            <td><?php echo _('Query'); ?></td>
                            <td><?php echo _('The alert lookback period (example: 5m)'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%warning%</td>
                            <td><?php echo _('Query, Host&nbsp;Freshness'); ?></td>
                            <td><?php echo _('The warning threshold value'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%critical%</td>
                            <td><?php echo _('Query, Host&nbsp;Freshness'); ?></td>
                            <td><?php echo _('The critical threshold value'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%fields.[fieldname]%</td>
                            <td><?php echo _('Query, Real&nbsp;Time'); ?></td>
                            <td><?php echo _('The data in the specified [fieldname]'); ?><br><?php echo _('Example'); ?>:<br>%fields.message%<br><?php echo _('This will include the message from the last included log in the alert'); ?></td>
                        </tr>
                    </tbody>
                </table>
                <p style="margin: 20px 0 10px 0;"><b><?php echo _('Message Body Only'); ?></b> - <?php echo _('These values can only be used in the body of the email, not the title.'); ?></p>
                <table class="table table-condensed table-striped table-hover table-no-margin table-no-border">
                    <thead>
                        <tr>
                            <th style="font-weight: bold;"><?php echo _('Macro Name'); ?></th>
                            <th><?php echo _('Supported Types'); ?></th>
                            <th><?php echo _('Description'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="font-weight: bold;">%output%</td>
                            <td><?php echo _('Any'); ?></td>
                            <td><?php echo _('The command line check output'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%url%</td>
                            <td><?php echo _('Query'); ?></td>
                            <td><?php echo _('The url that will show the data returned from the alert'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%uniquehosts%</td>
                            <td><?php echo _('Query'); ?></td>
                            <td><?php echo _('A newline separated list of unique hosts in the alert query.'); ?><br><?php echo _('Example'); ?>:<br>192.68.1.5 (28)<br>192.168.5.112 (1220)<br><?php echo _('The value inside the parentheses is the amount of matching logs for the alert time period for the hosts.'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%lastalertlog%</td>
                            <td><?php echo _('Query, Real&nbsp;Time'); ?></td>
                            <td><?php echo _('The last log from the alert query.'); ?><br><?php echo _('Can only use one of %lastalertlog% OR %last10alertlogs% per email.'); ?></td>
                        </tr>
                        <tr>
                            <td style="font-weight: bold;">%last10alertlogs%</td>
                            <td><?php echo _('Query, Real&nbsp;Time'); ?></td>
                            <td><?php echo _('The last 10 logs from the alert query.'); ?><br><?php echo _('Can only use one of %lastalertlog% OR %last10alertlogs%s per email.'); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <a href="#" class="btn btn-sm btn-default" data-dismiss="modal"><?php echo _("Close"); ?></a>
            </div>
        </div>
    </div>
</div>

<!-- Set default template -->
<div class="modal hide fade" id="change-default-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h2><?php echo _("Set Default Template"); ?></h2>
            </div>
            <div class="modal-body">
                <p><?php echo _('Set the default email template that will be used for all alerts that do not have a template specified.'); ?></p>
                <div class="form-horizontal">
                    <div class="form-group" style="margin: 0;">
                        <label class="col-sm-3 control-label"><?php echo _('Template'); ?></label>
                        <div class="col-sm-9">
                            <select id="tpl-select" class="form-control"></select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-primary" id="set-default-button"><?php echo _("Set Default"); ?></button>
                <a href="#" class="btn btn-sm btn-default" data-dismiss="modal"><?php echo _("Cancel"); ?></a>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
var CURRENT_ACTION = 'add';
var CURRENT_EDIT_ID = '';

$(document).ready(function() {

    $('.ls-pop').popover();
    $('.dropdown-toggle').dropdown();

    load_templates();

    $('#view-default').click(function() {
        $('#view-default-modal').modal('show');
    });

    $('#view-macros').click(function() {
        $('#view-macros-modal').modal('show');
    });

    $('#change-default').click(function() {
        $.get('<?php echo site_url("api/check/get_templates"); ?>', { }, function(data) {
            $('#tpl-select').html('<option value="system"><?php echo _("System Default"); ?></option>');
            $(data).each(function(k, v) {
                $('#tpl-select').append('<option value="'+v._id+'">'+v._source.name+'</option>');
            });
            $('#change-default-modal').modal('show');
        });
    });

    $('#set-default-button').click(function() {
        $.post('<?php echo site_url("api/check/set_default_tpl"); ?>', { id: $('#tpl-select').val() }, function(d) {
            if (d.success) {
                window.location.reload();
            } else {
                // Error
            }
        }, 'json');
    });

    $('#add-template').click(function() {
        CURRENT_ACTION = "add";
        clear_template_modal('add');
        $('#manage-template').modal('show');
    });

    $('.tpl-load-default').click(function() {
        $.get('<?php echo site_url("api/check/get_default_tpl"); ?>', { force: 1 }, function(tpl) {
            $('#tpl-body').val(tpl.body);
            $('#tpl-subject').val(tpl.subject);
        });
    });

    $('#clear').click(function() {
        $('#tpl-body').val('');
        $('#tpl-subject').val('');
    });

    $('.tpl-load-current-default').click(function() {
        $.get('<?php echo site_url("api/check/get_default_tpl"); ?>', { }, function(tpl) {
            $('#tpl-body').val(tpl.body);
            $('#tpl-subject').val(tpl.subject);
        });
    });

    $('#manage-template-button').click(function() {
        if ($('#tpl-name').val() == '' || $('#tpl-subject').val() == '' || $('#tpl-body').val() == '') {
            // Display error
            $('#manage-template-alerts').html('<div class="alert alert-danger" style="margin: 0 0 20px 0;"><?php echo _("You must fill out all the fields."); ?></div>');
            return;
        }

        var data = { name: $('#tpl-name').val(),
                     subject: $('#tpl-subject').val(),
                     body: $('#tpl-body').val() }

        // For editing only
        if (CURRENT_ACTION == "edit") {
            data['id'] = CURRENT_EDIT_ID;
        }
        data['action'] = CURRENT_ACTION;

        $.post('<?php echo site_url("api/check/template"); ?>', data, function(result) {
            if (result.status == "success") {
                $('#manage-template').modal('hide');
                load_templates();
                $('#messages').html('<div class="alert alert-success"><?php echo _("Successfully updated email template"); ?> <a class="close" data-dismiss="alert" href="#">&times;</a></div>');
            } else {
                $('#manage-template-alerts').html('<div class="alert alert-danger">'+result.msg+'</div>');
            }
        }, 'json');
    });

    $('#template-list').on('click', '.delete', function() {

        if (is_demo_mode) {
            alert("<?php echo _('This function is not available in demo mode.'); ?>");
            return;
        }

        var id = $(this).parents('td').data('id');
        $.post('<?php echo site_url("api/check/template"); ?>', { id: id, action: 'delete' }, function(result) {
            load_templates();
        });
    });

    $('#template-list').on('click', '.edit', function() {
        CURRENT_EDIT_ID = $(this).parents('td').data('id');
        CURRENT_ACTION = "edit";
        $.get('<?php echo site_url("api/check/get_templates"); ?>', { id: CURRENT_EDIT_ID }, function(tpl) {
            clear_template_modal('edit');
            $('#tpl-name').val(tpl._source.name);
            $('#tpl-subject').val(tpl._source.subject);
            $('#tpl-body').val(tpl._source.body);
            $('#manage-template').modal('show');
        });
    });

});

function load_templates()
{
    $.get('<?php echo site_url("api/check/get_templates"); ?>', { }, function(data) {
        html = '';
        if (data.length == 0) {
            html = '<tr><td colspan="9"><?php echo _("No email templates have been created."); ?></td></tr>';
        } else {
            $.each(data, function(k, v) {
                var actions = '<a title="<?php echo _("Edit"); ?>"><i class="edit fa fa-pencil"></i></a> <?php if (user_has_permission('alerts', array('all'))) { ?><a title="<?php echo _("Remove"); ?>"><i class="delete fa fa-trash-o"></i></a><?php } ?>';
                html += '<tr><td class="name">'+v._source.name+'</td><td>'+v._source.last_edit+'</td><td class="modified">'+v._source.modified_by+'</td><td class="created">'+v._source.created_by+'</td><td class="actions" data-id="'+v._id+'">'+actions+'</td></tr>';
            });
        }
        $('#template-list').html(html);
    });
}

function clear_template_modal(type)
{
    $('#manage-template input').val('');
    $('#manage-template textarea').val('');
    $('#manage-template-alerts').html('');
    if (type == 'add') {
        $('.template-action-type').html('<?php echo _("Add"); ?>');
    } else {
        $('.template-action-type').html('<?php echo _("Edit"); ?>');
        $('.btn.template-action-type').html('<?php echo _("Save"); ?>');
    }
}
</script>

<?php echo $footer; ?>