<?php echo $header; ?>

<script type="text/javascript">
    function checkForInputs() {
        let allowSubmit = true;

        // Verify we have username input
        if (!$("#username_box").val()) {
            allowSubmit = false;
            $("#username_box").addClass("error");
            $("#username-error-text").removeClass("no-show");
        } else {
            $("#username_box").removeClass("error");
            $("#username-error-text").addClass("no-show");
        }

        // Verify we have password input
        if (!$("#password_box").val()) {
            allowSubmit = false;
            $("#password_box").addClass("error");
            $("#password-error-text").removeClass("no-show");
        } else {
            $("#password_box").removeClass("error");
            $("#password-error-text").addClass("no-show");
        }

        return allowSubmit;
    }
    $(document).ready(function() {

        // Get url hash and send it to the backend...
        // since we need to somehow get the browser to redirect properly
        // to the kibana dashboards when not logged in
        var hash = window.location.hash;
        if (hash != '') {
            $.post(site_url+'auth/set_redirect_hash', { hash: hash });
        }

        // Frame buster
        if (top.location != self.location) {
            top.location = self.location.href;
        }

        $("#header").addClass("no-show");       
       
    });
</script>


<div class="modern-login-wrapper">    
    <div class="modern-login-container width-40">
        <div style="width: 100%; display: flex; justify-content: center; margin-bottom: 50px;">
            <img src="<?php echo base_url('media/images/' . $logo); ?>" class="hero-logo"></img>
        </div>
        
        <div class="login-card">            
            <div class="title-row">                    
                <h1 id="login-title"><?php echo _('Log in to Nagios Log Server'); ?></h1>                
            </div>
            <?php echo form_open(htmlentities($url, ENT_COMPAT, 'UTF-8'), array('class' => 'loginForm', 'onSubmit' => 'return checkForInputs()')); ?>
                <?php if ($error) { echo '<div class="fixed-login-message error"><i class="fa fa-exclamation-circle fa-2x" aria-hidden="true"></i>' . $error . '</div>'; } ?>
                <?php if ($message) { echo '<div class="fixed-login-message info"><i class="fa fa-info-circle fa-2x" aria-hidden="true"></i>' . $message . '</div>'; } ?>
                <div class="login-input-wrapper">
                    <input id="username_box" type="text" name="username" class="form-control" value="<?php echo html_escape($username); ?>" placeholder="<?php echo _('Username'); ?>" autofocus style="margin-bottom: 10px;">
                    <div id="username-error-text" class="login-input-error-text no-show">
                        <span><?php echo _("Username is required."); ?></span>
                    </div>
                    <input id="password_box" type="password" name="password" class="form-control" placeholder="<?php echo _('Password'); ?>" style="margin-bottom: 10px;">
                    <div id="password-error-text" class="login-input-error-text no-show">
                        <span><?php echo _("Password is required."); ?></span>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" name="remember" value="1"> <?php echo _('Keep me logged in');?></label>
                    </div>                    
                    <button type="submit" class="submitbutton login btn btn-primary btn-lg" id="loginButton" name="loginButton"><?php echo _('Login'); ?></button>                    
                    <div id="forgot-password-wrapper">
                        <a href="<?php echo site_url('forgot_password'); ?>" id="forgot-password-link"><?php echo _('Forgot your password?'); ?></a>
                    </div>
                </div>

            <?php echo form_close(); ?>
            
            <div class="clear"></div>
        </div>

        <h3 id="contact-text"><?php echo _("Contact Us"); ?></h3>
        <div id="contact-card">
            <div class="contact-detail-container">
                <i class="fa fa-phone fa-lg contact-icon" title="Phone" aria-hidden="true"></i>
                <a href="tel:+16512049102">651-204-9102</a>
            </div>
            <div class="contact-detail-container">
                <i class="fa fa-envelope fa-lg contact-icon" title="Email" aria-hidden="true"></i>
                <a href="mailto:sales@nagios.com">sales@nagios.com</a>
            </div>
            <div class="contact-detail-container">
                <i class="fa fa-life-ring fa-lg contact-icon" aria-hidden="true"></i>
                <a href="https://support.nagios.com/" target="_blank" rel="noreferrer"><?php echo _("Support"); ?></a>
            </div>
        </div>       
    </div>
</div>

<?php echo $footer; ?>
