<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="rside">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">
                    <h1><?php echo _("Configuration Editor"); ?></h1>
                    <?php if (get_option('configuration_required', 0)) { ?>
                    <div class="alert alert-danger" style=" margin: 10px 0 20px 0;">
                        <?php echo _("<strong>Apply configuration required!</strong> Your configuration in the database does not match the configuration applied."); ?>
                    </div>
                    <?php } ?>
                    <p><?php echo _("The configuration editor is used to write configurations for Logstash running on each of the Log Server instances. The local configurations can be written to Logstash on each of the instances in your cluster. You can also add <strong>global config options</strong> which will be applied to the top of all configuration files on every Log Server instance in the cluster. Global configurations are an easy way to set up the same Logstash configuration on all your instances."); ?></p>
                    <?php if (!empty($ports)) { ?>
                    <div class="alert alert-info" style="display: inline-block; margin: 10px 0;">
                        <?php echo _("<strong>Logstash</strong> is currently collecting locally on"); ?>: <strong style="margin-left: 5px;"><?php echo $_SERVER['SERVER_ADDR'] ?></strong> <?php foreach ($ports as $type => $p) { echo '<span style="margin: 0 5px;"><strong>'.$type.": ".implode(', ', $p)."</strong></span>"; } ?>
                    </div><br>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

</div>

<?php echo $footer; ?>