<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="rside">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                <?php
                $extra = 0;
                if ($node['_id'] == 'global') { ?>
                <h1><?php echo _("Global Config"); ?> <span id="not-saved" class="hide label label-important ls-tooltip" style="vertical-align: middle; margin-left: 10px;" title="<?php echo _('The changes to the config files have not been saved or applied.'); ?>"><?php echo _("Changes Not Saved"); ?></span></h1>
                <p style="margin-bottom: 10px;"><?php echo _("Manage logstash config options that will be added to all instances. Note that all applied global filters will happen before the local filters. Keep in mind the flow of the log data through the filters when creating global filters."); ?> <a href="https://www.elastic.co/guide/en/logstash/2.4/configuration.html" target="_blank"><?php echo _("View Logstash config language documentation"); ?> <i class="fa fa-external-link"></i></a></p>
                <?php } else { ?>
                <h1><?php echo _("Instance Config"); ?> - <?php echo $node['_source']['address']; if ($node['_source']['hostname'] != $node['_source']['address']) { echo " (".$node['_source']['hostname'].")"; } ?></h1>
                <div class="alert alert-info" style="margin-bottom: 15px;">
                    <?php echo '<strong>' . _("Advanced users only!") . '</strong> ' . _("Making changes here applies to this instance only and changes will be applied to Logstash when the apply configuration is run."); ?>
                </div>
                <?php } ?>

                <?php if (!empty($msg)) { ?>
                <div class="alert alert-<?php echo $msg_type; ?>" style="margin-bottom: 15px;">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $msg; ?>
                </div>
                <?php } ?>

                <?php
                if (array_key_exists('last_updated', $node['_source'])) {
                    if ($node['_source']['last_updated'] < time()-300 && $node['_id'] != 'global') {
                    // If the instance hasn't been updated in more than 5 minutes show an error page
                    ?>
                <div class="alert alert-error alert-offline" style="margin-bottom: 15px;">
                    <div><?php echo _("It looks like this instance hasn't checked in the last 5 minutes."); ?></div>
                    <div style="font-weight: bold;"><?php echo _("Normally this means it is not online or elasticsearch is not running."); ?></div>
                    <div style="margin: 10px 0;"><button id="prim" class="btn btn-default btn-m"><?php echo _("I've taken this instance offline permanently"); ?></button></div>
                    <div style="margin: 10px 0;"><button id="dk" class="btn btn-default btn-m"><?php echo _("I don't know why it's not online"); ?></button></div>
                    <div id="permanent" class="hide">
                        <div style="margin-top: 10px;"><?php echo _("If you have taken this instance offline permanently"); ?>:</div>
                        <div style="margin: 10px 0;">
                            <a href="<?php echo site_url("configure/remove_instance/".$node['_id']); ?>" class="btn btn-default"><?php echo _("Remove Instance from Database"); ?></a>
                        </div>
                    </div>
                    <div id="dont-know" class="hide">
                        <div style="margin-top: 10px;"><?php echo _("If you don't know why it's offline, try these"); ?>:</div>
                        <ul style="margin: 10px 30px;">
                            <li><?php echo _("Verify that elasticsearch is running on the instance and start elasticsearch if necessary"); ?></li>
                            <li><?php echo _("Check the connection (firewall, cable link) to the instance from this instance"); ?></li>
                            <li><?php echo _("Wait for the instance to return to an online state and check in"); ?></li>
                        </ul>
                    </div>
                </div>
                <?php
                    }
                }
                ?>

                <?php
                if (array_key_exists('logstash', $node['_source'])) {
                    if ($node['_source']['logstash']['status'] == 'stopped') { ?>
                    <div class="alert alert-danger" style="margin-bottom: 15px;">
                        <?php echo _("The instance reports that it's local"); ?> <strong><?php echo _("Logstash"); ?></strong> <?php echo _("is not running. You will not be able to collect logs on this instance until you start Logstash."); ?>
                    </div>
                <?php }
                } ?>

                <?php echo form_open('configure/save/'.$node['_id']); ?>
                <div class="container-fluid">
                <div class="row" style="padding-bottom: 15px;">
                    <div class="col-sm-6">
                        <input id="apply-after" type="hidden" value="0" name="apply_after">
                        <?php if (user_has_permission('configure', array('all'))) { ?>
                        <button disabled type="submit" class="save-btn btn btn-sm"><?php echo _("Save"); ?></button>
                        <button disabled type="button" id="save-and-apply" class="btn btn-sm btn-default ls-tooltip" title="<?php echo _("Save configuration and apply to ALL available instances. This will cause logstash to restart on all instances."); ?>"><i class="fa fa-external-link"></i> <?php echo _("Save &amp; Apply"); ?></button>
                        <button type="button" id="verify" class="btn btn-sm btn-default ls-tooltip" title="<?php echo _("Verify the syntax of this portion")." (".$node_name.") "._("of the config file."); ?>"><i class="fa fa-check-square-o"></i> <?php echo _("Verify"); ?></button>
                        <?php } ?>
                        <div class="btn-group">
                            <a class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" href="#"><i class="icon-file"></i><?php echo _("View"); ?> <span style="margin-left: 4px;" class="caret"></span></a>
                            <ul class="dropdown-menu">
                                <li><a class="view-file" data-type="input"><?php echo _("Inputs File"); ?></a></li>
                                <li><a class="view-file" data-type="filter"><?php echo _("Filters File"); ?></a></li>
                                <li><a class="view-file" data-type="output"><?php echo _("Outputs File"); ?></a></li>
                                <li class="divider"></li>
                                <li><a class="view-file" data-type="all"><?php echo _("All Files Combined"); ?></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-sm-6" style="text-align: right;">
                        <a id="output-manager" class="btn btn-sm btn-default"><?php echo _("Show Outputs"); ?></a>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6" id="input-col">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4 class="fl"><?php echo _("Inputs"); ?></h4>
                                    <div class="fl" style="margin: 11px 20px; font-weight: bold;"><a href="https://assets.nagios.com/downloads/nagios-log-server/docs/Listening-On-Privileged-Ports-With-Nagios-Log-Server.pdf" target="_blank"><?php echo _("Need ports < 1024?");?></a></div>
                                    <div class="clear"></div>
                                </div>
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                <div class="col-sm-6" style="text-align: right;">
                                    <div class="btn-group">
                                        <a class="btn btn-xs btn-default btn-mini dropdown-toggle" data-toggle="dropdown" href="#">
                                            <i class="fa fa-plus"></i>
                                            <span class="text"><?php echo _("Add Input"); ?></span>
                                            <span class="caret"></span>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right" style="margin-left: -70px;">
                                            <!--<li><a href="#"><i class="fa fa-magic"></i> <?php echo _("Run Wizard"); ?></a></li>-->
                                            <li><a class="custom" data-type="input"><i class="fa fa-file-code-o"></i> <?php echo _("Custom"); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="well">
                            <div class="config-box input" data-type="input">
                                <?php
                                if (count($node_inputs) > 0) {
                                foreach ($node_inputs as $k => $input) { ?>
                                <div class="block">
                                    <div>
                                        <div class="fl name">
                                            <?php if (!user_has_permission('configure', array('all'))) {
                                                    if ($input['active']) { ?>
                                                <span class="label label-success active"><?php echo _("Active"); ?></span>
                                                <?php } else { ?>
                                                <span class="label label-success inactive"><?php echo _("Inactive"); ?></span>
                                            <?php } } else { ?>
                                            <span class="label label-success toggle-activity active ls-tooltip <?php if ($input['active'] == 0) { echo "hide"; } ?>" title="<?php echo _("Make this block inactive"); ?>"><?php echo _("Active"); ?></span>
                                            <span class="label label-default toggle-activity inactive ls-tooltip <?php if ($input['active'] == 1) { echo "hide"; } ?>" title="<?php echo _("Make this block active"); ?>"><?php echo _("Inactive"); ?></span>
                                            <?php } ?>
                                            <span class="name"><?php echo html_escape($input['name']); ?></span>
                                            <input type="hidden" class="name form-control" name="input_names[<?php echo $k; ?>]" value="<?php echo html_escape($input['name']); ?>">
                                            <input type="hidden" class="active" name="input_active[<?php echo $k; ?>]" value="<?php echo $input['active']; ?>">
                                        </div>
                                        <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <a class="edit fl"><i class="fa fa-pencil"></i></a>
                                        <?php } ?>
                                        <div class="fr actions">
                                            <a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-plus"></i></a>
                                            <?php if (user_has_permission('configure', array('all'))) { ?>
                                            <a class="copy" title="<?php echo _('Copy'); ?>"><i class="fa fa-files-o"></i></a>
                                            <a class="delete" title="<?php echo _('Remove'); ?>"><i class="fa fa-trash-o"></i></a>
                                            <?php } ?>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                    $height = '100';
                                    $numlines = substr_count($input['raw'], "\n")+1;
                                    foreach (explode("\n", $input['raw']) as $line) {
                                        if (strlen($line) > 100) {
                                            $extra = ceil(strlen($line) / 100);
                                        }
                                    }
                                    if ($numlines > 4) {
                                        $height = $numlines * 25 + ($extra * 20);
                                    }
                                    ?>
                                    <div class="raw hide"><textarea name="inputs[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;"><?php echo html_escape($input['raw']); ?></textarea></div>
                                </div>
                                <?php }
                                } else { ?>
                                <div class="no-blocks"><?php echo _("There are no inputs created for this configuration."); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6" id="filter-col">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4><?php echo _("Filters"); ?></h4>

                                </div>
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                <div class="col-sm-6" style="text-align: right;">
                                    <div class="btn-group">
                                        <a class="btn btn-xs btn-default btn-mini dropdown-toggle" data-toggle="dropdown" href="#">
                                            <i class="fa fa-plus"></i>
                                            <span class="text"><?php echo _("Add Filter"); ?></span>
                                            <span class="caret"></span>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right" style="margin-left: -70px;">
                                            <!--<li><a href="#"><i class="fa fa-magic"></i> <?php echo _("Run Wizard"); ?></a></li>-->
                                            <li><a class="custom" data-type="filter"><i class="fa fa-file-code-o"></i> <?php echo _("Custom"); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="well">
                            <div class="config-box filter" data-type="filter">
                                <?php 
                                if (count($node_filters) > 0) {
                                    foreach ($node_filters as $k => $filter) { ?>

                                <div class="block">
                                    <div>
                                        <div class="fl name">
                                            <?php if (!user_has_permission('configure', array('all'))) {
                                                    if ($filter['active']) { ?>
                                                <span class="label label-success active"><?php echo _("Active"); ?></span>
                                                <?php } else { ?>
                                                <span class="label label-success inactive"><?php echo _("Inactive"); ?></span>
                                            <?php } } else { ?>
                                            <span class="label label-success toggle-activity active ls-tooltip <?php if ($filter['active'] == 0) { echo "hide"; } ?>" title="<?php echo _("Make this block inactive"); ?>"><?php echo _("Active"); ?></span>
                                            <span class="label label-default toggle-activity inactive ls-tooltip <?php if ($filter['active'] == 1) { echo "hide"; } ?>" title="<?php echo _("Make this block active"); ?>"><?php echo _("Inactive"); ?></span>
                                            <?php } ?>
                                            <span class="name"><?php echo html_escape($filter['name']); ?></span>
                                            <input type="hidden" class="name" style="margin: 0;" name="filter_names[<?php echo $k; ?>]" value="<?php echo html_escape($filter['name']); ?>">
                                            <input type="hidden" class="active" style="margin: 0;" name="filter_active[<?php echo $k; ?>]" value="<?php echo $filter['active']; ?>">
                                        </div>
                                        <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <a class="edit fl"><i class="fa fa-pencil"></i></a>
                                        <?php } ?>
                                        <div class="fr actions">
                                            <a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-plus"></i></a>
                                            <?php if (user_has_permission('configure', array('all'))) { ?>
                                            <a class="copy" title="<?php echo _('Copy'); ?>"><i class="fa fa-files-o"></i></a>
                                            <a class="delete" title="<?php echo _('Remove'); ?>"><i class="fa fa-trash-o"></i></a>
                                            <?php } ?>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                    $height = '100';
                                    $numlines = substr_count($filter['raw'], "\n")+1;
                                    foreach (explode("\n", $filter['raw']) as $line) {
                                        if (strlen($line) > 100) {
                                            $extra = ceil(strlen($line) / 100);
                                        }
                                    }
                                    if ($numlines > 4) {
                                        $height = $numlines * 17 + ($extra * 17);
                                    }
                                    ?>
                                    <div class="raw hide">
                                        <textarea name="filters[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;"><?php echo html_escape($filter['raw']); ?></textarea>
                                    </div>
                                </div>


                                    <?php }
                                } else { ?>
                                <div class="no-blocks"><?php echo _("There are no filters created for this configuration."); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4 hide" id="output-col">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4><?php echo _("Outputs"); ?></h4>
                                </div>
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                <div class="col-sm-6" style="text-align: right;">
                                    <div class="btn-group">
                                        <a class="btn btn-xs btn-default btn-mini dropdown-toggle" data-toggle="dropdown" href="#">
                                            <i class="fa fa-plus"></i>
                                            <span class="text"><?php echo _("Add Output"); ?></span>
                                            <span class="caret"></span>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right" style="margin-left: -60px;">
                                            <!--<li><a href="#"><i class="fa fa-magic"></i> <?php echo _("Run Wizard"); ?></a></li>-->
                                            <li><a class="custom" data-type="output"><i class="fa fa-file-code-o"></i> <?php echo _("Custom"); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="well">
                            <div class="config-box output" data-type="output">
                                <?php
                                if (count($node_outputs) > 0) {
                                    foreach ($node_outputs as $k => $output) { ?>


                                <div class="block">
                                    <div>
                                        <div class="fl name">
                                            <?php if (!user_has_permission('configure', array('all'))) {
                                                    if ($output['active']) { ?>
                                                <span class="label label-success active"><?php echo _("Active"); ?></span>
                                                <?php } else { ?>
                                                <span class="label label-success inactive"><?php echo _("Inactive"); ?></span>
                                            <?php } } else { ?>
                                            <span class="label label-success toggle-activity active ls-tooltip <?php if ($output['active'] == 0) { echo "hide"; } ?>" title="<?php echo _("Make this block inactive"); ?>"><?php echo _("Active"); ?></span>
                                            <span class="label label-default toggle-activity inactive ls-tooltip <?php if ($output['active'] == 1) { echo "hide"; } ?>" title="<?php echo _("Make this block active"); ?>"><?php echo _("Inactive"); ?></span>
                                            <?php } ?>
                                            <span class="name"><?php echo html_escape($output['name']); ?></span>
                                            <input type="hidden" class="name" style="margin: 0;" name="output_names[<?php echo $k; ?>]" value="<?php echo html_escape($output['name']); ?>">
                                            <input type="hidden" class="active" style="margin: 0;" name="output_active[<?php echo $k; ?>]" value="<?php echo $output['active']; ?>">
                                        </div>
                                        <?php if (user_has_permission('configure', array('all'))) { ?>
                                        <a class="edit fl"><i class="fa fa-pencil"></i></a>
                                        <?php } ?>
                                        <div class="fr actions">
                                            <a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-plus"></i></a>
                                            <?php if (user_has_permission('configure', array('all'))) { ?>
                                            <a class="copy" title="<?php echo _('Copy'); ?>"><i class="fa fa-files-o"></i></a>
                                            <a class="delete" title="<?php echo _('Remove'); ?>"><i class="fa fa-trash-o"></i></a>
                                            <?php } ?>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                    $height = '100';
                                    $numlines = substr_count($output['raw'], "\n")+1;
                                    foreach (explode("\n", $output['raw']) as $line) {
                                        if (strlen($line) > 100) {
                                            $extra = ceil(strlen($line) / 100);
                                        }
                                    }
                                    if ($numlines > 4) {
                                        $height = $numlines * 17 + ($extra * 17);
                                    }
                                    ?>
                                    <div class="raw hide">
                                        <textarea name="outputs[<?php echo $k; ?>]" style="height: <?php echo $height; ?>px;"><?php echo html_escape($output['raw']); ?></textarea>
                                    </div>
                                </div>

                                    <?php }
                                } else { ?>
                                <div class="no-blocks"><?php echo _("There are no outputs created for this configuration."); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">

            <!-- REAL TIME ALERTS-->
            <?php if ($node['_id'] == 'global') { ?>
                    <h3><?php echo _("Real-Time Alerts (Read-Only)");?></h3>
                    <div class="col-sm-6" id="rta-filters">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-sm-12">
                                    <h4><?php echo _("Filters"); ?></h4>
                                </div>
                            </div>
                        </div>
                        <div class="well">
                            <div class="config-box rta-filter" data-type="rta-filter">
                                <?php 
                                if (count($node_livealert_filters) > 0) {
                                    foreach ($node_livealert_filters as $k => $filter) { ?>
                                        
                                <div class="block">
                                    <div>
                                        <div class="fl name">
                                            <?php if ($filter['active']) { ?>
                                                <span class="label label-success active"><?php echo _("Active"); ?></span>
                                            <?php } else { ?>
                                                <span class="label label-success inactive"><?php echo _("Inactive"); ?></span>
                                            <?php }?>
                                            <span class="name"><?php echo html_escape($filter['name']); ?></span>
                                        </div>
                                        <div class="fr actions">
                                            <a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-plus"></i></a>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                    $height = '100';
                                    $numlines = substr_count($filter['raw'], "\n")+1;
                                    foreach (explode("\n", $filter['raw']) as $line) {
                                        if (strlen($line) > 100) {
                                            $extra = ceil(strlen($line) / 100);
                                        }
                                    }
                                    if ($numlines > 4) {
                                        $height = $numlines * 17 + ($extra * 17);
                                    }
                                    ?>
                                    <div class="raw hide">
                                        <textarea style="height: <?php echo $height; ?>px;" disabled><?php echo html_escape($filter['raw']); ?></textarea>
                                    </div>
                                </div>

                                    <?php } // endforeach
                                } else { ?>
                                <div class="no-blocks"><?php echo _("There are no filters for real-time alerts."); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-6" id="rta-outputs">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-sm-6">
                                    <h4><?php echo _("Outputs"); ?></h4>
                                </div>
                            </div>
                        </div>
                        <div class="well">
                            <div class="config-box rta-output" data-type="rta-output">
                                <?php 
                                if (count($node_livealert_outputs) > 0) {
                                    foreach ($node_livealert_outputs as $k => $output) { ?>

                                <div class="block">
                                    <div>
                                        <div class="fl name">
                                                <?php if ($output['active']) { ?>
                                                    <span class="label label-success active"><?php echo _("Active"); ?></span>
                                                <?php } else { ?>
                                                    <span class="label label-success inactive"><?php echo _("Inactive"); ?></span>
                                                <?php } ?>
                                            <span class="name"><?php echo html_escape($output['name']); ?></span>
                                        </div>
                                        <div class="fr actions">
                                            <a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-plus"></i></a>
                                        </div>
                                        <div class="clear"></div>
                                    </div>
                                    <?php
                                    $height = '100';
                                    $numlines = substr_count($output['raw'], "\n")+1;
                                    foreach (explode("\n", $output['raw']) as $line) {
                                        if (strlen($line) > 100) {
                                            $extra = ceil(strlen($line) / 100);
                                        }
                                    }
                                    if ($numlines > 4) {
                                        $height = $numlines * 17 + ($extra * 17);
                                    }
                                    ?>
                                    <div class="raw hide">
                                        <textarea style="height: <?php echo $height; ?>px;" disabled><?php echo html_escape($output['raw']); ?></textarea>
                                    </div>
                                </div>
                                <?php }
                                } else { ?>
                                    <div class="no-blocks"><?php echo _("There are no outputs for real-time alerts."); ?></div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>

            <?php } ?>

                </div>
                </div>
                <?php if (user_has_permission('configure', array('all'))) { ?>
                <button disabled type="submit" class="save-btn btn btn-sm"><?php echo _("Save"); ?></button>
                <?php
                }
                echo form_close();
                ?>
                </div>
            </div>
        </div>
    </div>

</div>

<script type="text/javascript">
$(document).ready(function() {

    $('.view-file').click(function() {
        var type = $(this).data("type");
        $('#view').modal('show');
        $('#view-title').html($(this).text());

        // Grab the actual file and insert it into the textarea
        $.post(site_url+"api/system/view_file_by_type", { type: type, node: '<?php echo $node['_id']; ?>' }, function(file) {
            $('#view-file').html(file);
        });
    });

    $('#verify').click(function() {
        $('#verify-modal').modal({backdrop: 'static'});
        $('#verify-loader').show();
        $('#verify-message').hide();
        $('#verify-config-output').hide();
        $('#verify-running').html('<?php echo _("Verifying configuration... This may take a moment."); ?>');

        // Do the actual config verification...
        $.post(site_url+"api/system/verify_config_syntax", { node: '<?php echo $node['_id']; ?>' }, function(data) {
            $('#verify-loader').hide();
            if (data.result == "success") {
                $('#verify-message').removeClass('alert-danger').addClass('alert-success').html('<?php echo _("Configuration is OK!"); ?>').show();
            } else {
                $('#verify-message').removeClass('alert-success').addClass('alert-danger').html('<?php echo _("There was an error in the configuration!"); ?>').show();
                
                var error = "";
                $.each(data.output, function(k, v) {
                    error += v + "\n";
                });

                $('#verify-config-output').html(error).show();
            }
        }, 'json');

    });

    $('#save-and-apply').click(function() {
        $('#apply-after').val('1');
        $('form').submit();
    });

    // Make a new custom block
    $('.custom').click(function() {
        var type = $(this).data('type');
        // Verify there is no "no xxx" div's
        $('.config-box.'+type).find('.no-blocks').hide();
        $('.config-box.'+type).append(create_new_block_string(type));
        save_needed();
    });

    // When clicking on the edit button for any type of thing...
    $(".configure-layout").on('click', 'a.edit', function() {
        $(this).hide();
        $(this).parents('.block').find('.name span.name').hide();
        $(this).parents('.block').find('.name input.name').attr('type', "text");
    });

    // When clicking the active/inactive button
    $(".configure-layout").on('click', '.toggle-activity', function() {
        $(this).hide();
        if ($(this).hasClass('active')) {
            $(this).parents('.block').find('.name input.active').val('0');
            $(this).parents('.block').find('.inactive').show();
        } else {
            $(this).parents('.block').find('.name input.active').val('1');
            $(this).parents('.block').find('.active').show();
        }
        save_needed();
    });

    // When clicking on the edit button for any type of thing...
    $(".configure-layout").on('click', 'a.open', function() {
        if ($(this).parents('.block').find('.raw').is(':visible')) {
            $(this).html('<i class="fa fa-plus"></i>');
            $(this).parents('.block').find('.raw').hide();
        } else {
            $(this).html('<i class="fa fa-minus"></i>');
            $(this).parents('.block').find('.raw').show();
        }
    });

    // Copy a block
    $(".configure-layout").on('click', 'a.copy', function() {
        var type = $(this).parents('.config-box').data('type');
        var name = $(this).parents('.block').find('input').val();
        var raw = $(this).parents('.block').find('textarea').text();
        $('.config-box.'+type).append(create_new_block_string(type, name, raw));
        save_needed();
    });

    // Remove the block from the config area
    $(".configure-layout").on('click', 'a.delete', function() {
        if ($(this).parents('.config-box').find('.block').length == 1) {
            if ($(this).parents('.config-box').find('.no-blocks').length == 0) {
                $(this).parents('.config-box').append('<div class="no-blocks">' + <?php echo json_encode(_("There are no blocks for this configuration.")); ?> + '</div>');
            } else {
                $(this).parents('.config-box').find('.no-blocks').show();
            }
        }
        $(this).parents('.block').remove();
        save_needed();
    });


    $('#prim').click(function() {
        $('.alert-offline button.btn-m').hide();
        $('#permanent').show();
    });

    $('#dk').click(function() {
        $('.alert-offline button.btn-m').hide();
        $('#dont-know').show();
    });

    // Set up sortability
    $('.config-box').sortable({
        items: ".block",
        placeholder: "whitespace-holder",
        delay: 200,
        stop: function(event, ui) {
            var type = $(ui.item).parents('.config-box').data('type');
            reorder_input_names(type);
            save_needed();
        }
    });

    // Output hiding...
    $('#output-manager').click(function() { 
        if ($('#output-col').is(":visible")) {
            $('#output-manager').html('<?php echo _("Show Outputs"); ?>');
            $('#output-col').hide();
            $('#input-col').removeClass('col-sm-4').addClass('col-sm-6');
            $('#filter-col').removeClass('col-sm-4').addClass('col-sm-6');
        } else {
            $('#output-manager').html('<i class="fa fa-eye-slash"></i> <?php echo _("Hide Outputs"); ?>');
            $('#output-col').show();
            $('#input-col').removeClass('col-sm-6').addClass('col-sm-4');
            $('#filter-col').removeClass('col-sm-6').addClass('col-sm-4');
        }
    });

    $('textarea').on('keydown', function(e) {
        if ((e.which < 16 || e.which > 45) && e.which != 91 && e.which != 92 && (e.which < 112 || e.which > 123)) {
            save_needed();
        }
    });

    $('textarea').on('keydown', function(event) {
        if (event.key == "Tab") {
            event.preventDefault();
            var currentPos = this.selectionStart;
            let replacementText = this.value.slice(0, currentPos) + '    ' + this.value.slice(currentPos)
            this.value = replacementText;
            this.selectionEnd = currentPos + 4;
        }
    });

    $('.name input.name').on('keydown', function(e) {
        if ((e.which < 16 || e.which > 45) && e.which != 91 && e.which != 92 && (e.which < 112 || e.which > 123)) {
            save_needed();
        }
    });
});

function create_new_block_string(type, name, raw)
{
    if (name == undefined) { name = ''; }
    if (raw == undefined) { raw = ''; }
    html = '<div class="block"><div><div class="fl name"><span class="label label-success toggle-activity active ls-tooltip" title="<?php echo _("Make this block inactive"); ?>"><?php echo _("Active"); ?></span><span class="label label-default toggle-activity inactive ls-tooltip hide" title="<?php echo _("Make this block active"); ?>"><?php echo _("Inactive"); ?></span><input type="text" class="name" name="'+type+'_names[]" placeholder="<?php echo _('Block Name'); ?>" style="margin-left: 3px;" value="'+name+'"><input type="hidden" class="active" style="margin: 0;" name="'+type+'_active[]" value="1"></div><div class="fr actions"><a class="open" title="<?php echo _('Open configuration'); ?>"><i class="fa fa-minus"></i></a> <a class="copy" title="<?php echo _('Copy'); ?>"><i class="fa fa-files-o"></i></a> <a class="delete" title="<?php echo _('Remove'); ?>"><i class="fa fa-trash-o"></i></a></div><div class="clear"></div></div><div class="raw"><textarea name="'+type+'s[]">'+raw+'</textarea></div></div>';
    return html;
}

// Goes through the list of items and re-orders them one by one
function reorder_input_names(type)
{
    $('.config-box.'+type+' .block').each(function(k, v) {
        $(v).find('input.name').prop('name', type+'_names['+k+']');
        $(v).find('input.active').prop('name', type+'_active['+k+']');
        $(v).find('textarea').prop('name', type+'s['+k+']');
    });
}

function save_needed()
{
    $('.save-btn').prop('disabled', false).addClass('btn-danger');
    $('#save-and-apply').prop('disabled', false);
    $('#not-saved').show();
}
</script>

<!-- View config modal -->
<div id="view" class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 id="myModalLabel"><?php echo _("View"); ?> - <span id="view-title"></span></h2>
            </div>
            <div class="modal-body configure">
                <textarea id="view-file"></textarea>
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _("Close"); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Verify configuration modal -->
<div id="verify-modal"class="modal hide fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h2 id="myModalLabel"><?php echo _("Verify Configuration"); ?></h2>
            </div>
            <div class="modal-body">
                <div>
                    <div id="verify-loader" class="hide"><i class="fa fa-spinner fa-13 fa-pulse"></i>&nbsp; <span id="verify-running"></span></div>
                    <div id="verify-message" class="alert hide"></div>
                </div>
                <div class="configure">
                    <div class="box-wrapper">
                        <textarea id="verify-config-output" class="hide"></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _("Close"); ?></button>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>