<div class="lside config-leftbar">
    <ul class="nav nav-list nav-list-nls">

        <li class="nav-header"><?php echo _("Configure"); ?></li>
        <li>
            <a href="<?php echo site_url('configure/apply'); ?>">
                <?php if (get_option('configuration_required', 0)) { ?>
                    <i class="fa fa-asterisk tt-bind" style="color: #CC0000;" data-placement="right" title="<?php echo _('New configuration needs to be applied.'); ?>"></i>
                <?php } else { ?>
                    <i class="fa fa-asterisk"></i>
                <?php } ?>
                <?php echo _("Apply Configuration"); ?>
            </a>
        </li>
        <li><a href="<?php echo site_url('configure/snapshots'); ?>"><i class="fa fa-clock-o"></i> <?php echo _("Config Snapshots"); ?></a></li>
        <li class="spacer"></li>
        <li><a href="<?php echo site_url('configure/add-log-source'); ?>"><i class="fa fa-share"></i> <?php echo _("Add Log Source"); ?></a></li>

        <li class="nav-header"><?php echo _("Global (All Instances)"); ?></li>
        <li><a href="<?php echo site_url('configure/instance/global'); ?>"><i class="fa fa-sticky-note-o"></i> <?php echo _("Global Config"); ?></a></li>

        <li class="nav-header nodes-toggle-advanced"><i class="fa <?php if (!empty($show_advanced)) { $show = 'no-display'; echo "fa-caret-up"; } else { $show = ''; echo "fa-caret-down"; } ?> nodes-icon"></i> <?php echo _("Per Instance (Advanced)"); ?></li>
        <?php foreach ($nodes as $n) {
                 echo '<li class="nodes '.$show.'">';

                // Default icons
                $icon = array('title' => _("This instance is currently not running either logstash or elasticsearch"),
                              'icon' => "fa-circle-o");

                // Check if it's been updated recently
                if (time() - $n['_source']['last_updated'] > 60*5) {
                    $icon['title'] = _("This instance may not be running... It hasn't checked in for over 5 minutes.");
                } else {
                    // Check if elasticsearch and logstasg is currently running
                    $ls_bool = ($n['_source']['logstash']['status'] == "running");
                    $es_bool = ($n['_source']['elasticsearch']['status'] == "running");
                    if ($ls_bool && $es_bool) {
                        $icon['icon'] = "fa-circle";
                        $icon['title'] = _("This instance is OK");
                    } else if (!$es_bool) {
                        $icon['icon'] = "fa-adjust";
                        $icon['title'] = _("This instance is not running elasticsearch");
                    } else if (!$ls_bool) {
                        $icon['icon'] = "fa-adjust";
                        $icon['title'] = _("This instance is not running logstash");
                    }
                }

                // Add icon to html...
                $icon['html'] = '<i class="fa '.$icon['icon'].'"></i>';
                ?>
                <a href="<?php echo site_url('configure/instance/'.$n['_id']); ?>" title="<?php echo _("Instance UUID") . ": " . $n['_id']; ?>">
                    <span class="config-editor-icon tt-bind" title="<?php echo $icon['title']; ?>"><?php echo $icon['html']; ?></span>
                    <?php if ($_SERVER['SERVER_ADDR'] == $n['_source']['address']) { ?>
                    <span class="config-editor-icon tt-bind" title="<?php echo _("This is the server you're currently logged into."); ?>"><i class="fa fa-check"></i></span>
                    <?php } ?>
                    <?php echo $n['_source']['hostname']; ?>
                </a>
            </li>
        <?php } ?>

    </ul>
</div>