<?php echo $header; ?>

<div class="configure-layout">

    <?php echo $leftbar; ?>

    <div class="rside">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                <h1><?php echo _("Config Snapshots"); ?></h1>
                <p style="padding-bottom: 20px;"><?php echo _("Save your configs for later. Configs for <em>all</em> instances are saved. When a snapshot is restored it will restore <em>all</em> configs on <em>all</em> instances. Snapshots are stored in <strong>/usr/local/nagioslogserver/snapshots</strong>"); ?></p>

                <?php if (!empty($snapshot_success)) { ?>
                <div class="alert alert-success" style="margin: 0 0 15px 0;">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $snapshot_success; ?>
                </div>
                <?php } ?>

                <?php if (!empty($snapshot_error)) { ?>
                <div class="alert alert-danger" style="margin: 0 0 15px 0;">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $snapshot_error; ?>
                </div>
                <?php } ?>

                <?php 
                if (user_has_permission('configure', array('all'))) {
                    echo form_open('configure/create_snapshot', array("style" => "margin-bottom: 15px;"));
                ?>
                    <input type="text" name="snapshot_name" class="form-control" style="margin: 0 10px 0 0; width: 300px;" placeholder="<?php echo _("Snapshot name &amp; description"); ?>"><button type="submit" class="btn btn-sm btn-default" style="vertical-align: top;"><?php echo _("Create"); ?></button>
                <?php
                    echo form_close();
                }
                ?>

                <table class="table table-striped table-condensed table-va-middle table-bordered table-auto-width">
                    <thead>
                        <tr>
                            <th><?php echo _("Name & Description"); ?></th>
                            <th style="width: 260px;"><?php echo _("Filename"); ?></th>
                            <th style="width: 230px;"><?php echo _("Creation Date"); ?></th>
                            <th style="width: 100px;"><?php echo _("Actions"); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (count($snapshots) > 0) {
                        foreach ($snapshots as $snapshot) {
                            if (!array_key_exists('filename', $snapshot)) {
                                $snapshot['filename'] = '';
                            }
                        ?>
                        <tr>
                            <td><?php echo htmlentities($snapshot['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                            <td><?php if (!empty($snapshot['filename'])) { echo htmlentities($snapshot['filename'], ENT_QUOTES, 'UTF-8'); } else { echo '<span id="ss-'.$snapshot['id'].'"><img style="width: 16px; height: 16px;" src="'.base_url('media/images/ajax-loader.gif').'"> '._("Creating..."); } ?></td>
                            <td><?php if (!empty($snapshot['created'])) { echo date("r", $snapshot['created']); } else { echo '<span id="ss-time-'.$snapshot['id'].'"></span>'; } ?></td>
                            <td style="font-size: 14px; text-align: center;">
                                <a <?php if (!empty($snapshot['filename'])) { ?> href="<?php echo site_url('configure/download_snapshot/'.$snapshot['filename']); ?>"<?php } ?>
                                   <?php echo 'id="ss-download-'.$snapshot['id'].'"'; ?> 
                                   class="tt-bind" 
                                   title="<?php echo empty($snapshot['filename']) ? _("File does not exist yet!") : _("Download the .tar.gz file"); ?>">
                                   <i class="fa fa-download"></i></a>
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                &nbsp; 
                                <a data-name="<?php echo htmlentities($snapshot['name'], ENT_COMPAT, 'UTF-8'); ?>" data-id="<?php echo $snapshot['id']; ?>" class="restore tt-bind" title="<?php echo _("Restore instances to this configuration"); ?>"><i class="fa fa-history"></i></a> &nbsp; 
                                <a href="<?php echo site_url('configure/delete_snapshot/'.$snapshot['id']); ?>" class="tt-bind" title="<?php echo _("Remove"); ?>"><i class="fa fa-trash-o"></i></a>
                                <?php } ?>
                            </td>
                        </tr>
                        <?php }
                        } else { ?>
                        <tr>
                            <td colspan="9"><?php echo _("No snapshots have been created yet."); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>

                <div style="height: 20px;"></div>

                <h4><?php echo _("Auto-Created Snapshots"); ?></h4>
                <table class="table table-striped table-condensed table-va-middle table-bordered table-auto-width">
                    <thead>
                        <th><?php echo _("Name & Description"); ?></th>
                        <th style="width: 260px;"><?php echo _("Filename"); ?></th>
                        <th style="width: 230px;"><?php echo _("Creation Date"); ?></th>
                        <th style="width: 100px;"><?php echo _("Actions"); ?></th>
                    </thead>
                    <tbody>
                        <?php
                        if (count($auto_snapshots) > 0) {
                        foreach ($auto_snapshots as $snapshot) {
                        ?>
                        <tr>
                            <td><?php echo $snapshot['name']; ?></td>
                            <td><?php if (!empty($snapshot['filename'])) { echo $snapshot['filename']; } else { echo '<span id="ss-'.$snapshot['id'].'"><img style="width: 16px; height: 16px;" src="'.base_url('media/images/ajax-loader.gif').'"> '._("Creating..."); } ?></td>
                            <td><?php if (!empty($snapshot['created'])) { echo date("r", $snapshot['created']); } else { echo '<span id="ss-time-'.$snapshot['id'].'"></span>'; } ?></td>
                            <td style="font-size: 14px; text-align: center;">
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                <a href="<?php echo site_url('configure/archive_auto_snapshot/'.$snapshot['id']); ?>" class="tt-bind" title="<?php echo _("Archive this snapshot in the regular snapshots section"); ?>"><i class="fa fa-archive"></i></a> &nbsp; 
                                <?php } ?>
                                <a <?php if (!empty($snapshot['filename'])) { ?> href="<?php echo site_url('configure/download_snapshot/'.$snapshot['filename']); ?>"<?php } ?>
                                    <?php echo 'id="ss-download-'.$snapshot['id'].'"'; ?>
                                    class="tt-bind" 
                                    title="<?php echo empty($snapshot['filename']) ? _("File does not exist yet!") : _("Download the .tar.gz file"); ?>"><i class="fa fa-download"></i></a>
                                <?php if (user_has_permission('configure', array('all'))) { ?>
                                &nbsp; 
                                <a data-name="<?php echo $snapshot['name']; ?>" data-id="<?php echo $snapshot['id']; ?>" class="restore tt-bind" title="<?php echo _("Restore instances to this configuration"); ?>"><i class="fa fa-history"></i></a>
                                <?php } ?>
                            </td>
                        </tr>
                        <?php }
                        } else { ?>
                        <tr>
                            <td colspan="9"><?php echo _("No automatic snapshots have been created yet. You probably haven't run an apply command."); ?></td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>

                </div>
            </div>
        </div>
    </div>

</div>

<!-- Verify restore modal -->
<div id="restore-confirm" class="modal hide fade" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h3><?php echo _("Are You Sure?"); ?></h3>
            </div>
            <div class="modal-body">
                <p><?php echo _("Are you sure you want to restore to snapshot"); ?> <strong id="restore-snapshot-name"></strong> <em><strong><?php echo _("to all instances"); ?></strong></em></p>
                <div><?php echo _("All running logstash services will be restarted on each instance. This may take a couple minutes to restore the database and files on all instances. If a instance does not have a snapshot it will NOT be updated."); ?></div>
            </div>
            <div class="modal-footer">
                <a href="<?php echo site_url('configure/restore_snapshot'); ?>" id="restore-link" class="btn btn-primary"><?php echo _("Yes, Restore Now"); ?></a>
                <button class="btn btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
var UPDATE;
var UPDATE_ID = '<?php echo $cmd_id; ?>';
var SNAPSHOT_ID = '<?php echo $snapshot_id; ?>';

$(document).ready(function() {
    if (UPDATE_ID != '') {
        UPDATE = setInterval(check_if_completed, 1000);
    }

    // Restore a node... just checking if they want to
    $('.restore').click(function() {
        var id = $(this).data('id');
        $('#restore-snapshot-name').html($(this).data('name'));
        $('#restore-link').attr('href', $('#restore-link').attr('href') + "/" + id);
        $('#restore-confirm').modal({backdrop:"static"});
    });

});

function check_if_completed()
{
    $.get('<?php echo site_url("api/system/get_cmd_info"); ?>', { cmd_id: UPDATE_ID }, function(data) {
        if (data.status == "completed") {
            clearInterval(UPDATE);
            $.get('<?php echo site_url("api/system/get_snapshot_info"); ?>', { snapshot_id: SNAPSHOT_ID }, function(data) {
                $('#ss-'+SNAPSHOT_ID).html(data.filename);
                $('#ss-time-'+SNAPSHOT_ID).html(data.created_readable);
                var working_link = '<?php echo site_url('configure/download_snapshot/'); ?>' + data.filename;
                $('#ss-download-'+SNAPSHOT_ID).attr('href', working_link);
                var working_title = '<?php echo _("Download the .tar.gz file"); ?>';
                $('#ss-download-'+SNAPSHOT_ID).attr('title', working_title);
            });
        }
    }, 'json');
}
</script>

<?php echo $footer; ?>