<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-file-o"></i>
                        </div>
                        <h1><?php echo _('Import From File'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>
                    <p><?php echo _("If you have logs saved somewhere and you want to import them into Nagios Log Server, we have an easy utility script that can send them into Log Server for processing. Log Server will take the incoming logs and place them into the correct indexes based on timestamp data."); ?></p>

                    <h3><?php echo _("Configuration Setup"); ?></h3>
                    <p><?php echo _("Log Server ships with two inputs already configured in the"); ?> <a target="_new" href="<?php echo site_url('configure/instance/global'); ?>"><?php echo _("Global Configuration"); ?></a>. <?php echo _("The two inputs are for accepting file imports. One input is used for raw log files (TCP port 2056) and one input is used for JSON formatted (TCP port 2057) log files."); ?></p>

                    <?php if (!$import_input_available) { ?>
                    <p class="alert alert-danger"><?php echo _("<strong>It doesn't look like you have the default file import inputs configured.</strong> In order to use the import utility script you must have the following in your input configuration."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="1"><?php echo $step1; ?></code></pre>
                    </div>
                    <p><?php echo _("Make sure the ports are open on your Log Server. The example below assumes CentOS/RHEL 6 or 7 with iptables installed."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="2"><?php echo $step2; ?></code></pre>
                    </div>
                    <p><?php echo _("The exact firewall rules will depend on your organization's policies and firewall."); ?></p>
                    <?php } ?>

                    <h6><?php echo _("Utility Script"); ?></h6>

                    <p><?php echo _("Log Server includes a <code>shipper.py</code> script that reads log lines and writes out JSON messages for import into Log Server. Download the script from your Log Server with the following command."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="3"><?php echo $step3; ?></code></pre>
                    </div>

                    <h6><?php echo _("Script Requirements"); ?></h6>
                    <p><?php echo _("The usage of this utility requires netcat. If you don't already have netcat installed on the system that will be sending the log file to Log Server, run the following:"); ?></p>

                    <div class="tabbable" style="margin-bottom: 30px;">

                        <ul class="nav nav-tabs nav-tabs-help">
                            <li class="active"><a href="#centos" data-toggle="tab"><?php echo _("CentOS/RHEL"); ?></a></li>
                            <li><a href="#debian" data-toggle="tab"><?php echo _("Debian/Ubuntu"); ?></a></li>
                        </ul>

                        <div class="tab-content" style="margin-top: 10px;">

                            <div class="tab-pane active" id="centos">
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="4">yum install -y nc</code></pre>
                                </div>
                            </div>

                            <div class="tab-pane" id="debian">
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="5">sudo apt-get install netcat-openbsd</code></pre>
                                </div>
                            </div>

                        </div>

                    </div>

                    <h3><?php echo _("Sending Log Files"); ?></h3>
                    <p><?php echo _("The <code>shipper.py</code> script will read log lines from stdin if no file selection arguments are given. Data can be added to the JSON for use in filtering messages by passing <b>field:value</b> arguments after any file selection arguments. Piping the JSON messages that <code>shipper.py</code> writes to netcat will send them to Log Server."); ?></p>

                    <h6><?php echo _("Examples"); ?></h6>

                    <p><?php echo _("Setting <b>program:apache_access</b> for an archived Apache access_log will match the default Apache filter in Log Server, and the log messages will be parsed like normal live log data from Apache."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="6"><?php echo $step4; ?></code></pre>
                    </div>

                    <p><?php echo _("You can also read files by name, or matching a shell glob pattern. Plain text, gzip, and bzip2 compressed files are supported. This command will send all log lines in multiple gzipped access_log files to Log Server for processing."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="7"><?php echo $step5; ?></code></pre>
                    </div>

                    <p><?php echo _("The script can also send an entire directory, processing only files that match a pattern. The following example command will send all log lines in gzipped access_log archives in <code>/var/log/archive</code> and its subdirectories to Log Server."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="8"><?php echo $step6; ?></code></pre>
                    </div>

                    <p><?php echo _("Zip and tar (raw, gzip, and bzip2) archives are also supported. This command will send all log lines in access_log archives in archive.tar.bz2."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="9"><?php echo $step7; ?></code></pre>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p style="margin-bottom: 50px;"><?php echo _("Once you've sent your log messages, you can check your"); ?> <a target="_new" href="<?php echo site_url('dashboard'); ?>"><?php echo _("Dashboard"); ?></a> <?php echo _("to verify that the logs were sent successfully. Remember that if the logs were in the past, you may have to extend your search to the time frame of the logs that were sent."); ?></p>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>