<div class="lside config-leftbar">
    <ul class="nav nav-list nav-list-nls">

        <li class="nav-header"><?php echo _("Configure"); ?></li>
        <li><a href="<?php echo site_url('configure/add-log-source'); ?>"><i class="fa fa-plus"></i> <?php echo _('Add Log Source'); ?></a></li>
        <li class="spacer"></li>
        <li><a href="<?php echo site_url('configure'); ?>"><i class="fa fa-share"></i> <?php echo _("Configuration Editor"); ?></a></li>

        <li class="nav-header"><?php echo _("System Logs"); ?></li>
        <li><a href="<?php echo site_url('configure/source/linux'); ?>"><i class="fa fa-linux"></i> <?php echo _("Linux"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/windows'); ?>"><i class="fa fa-windows"></i> <?php echo _("Windows"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/network'); ?>"><i class="fa fa-exchange"></i> <?php echo _("Network Device"); ?></a></li>

        <li class="nav-header"><?php echo _("Application Logs"); ?></li>
        <li><a href="<?php echo site_url('configure/source/apache'); ?>"><i class="fa fa-cube"></i> <?php echo _("Apache"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/iis'); ?>"><i class="fa fa-cube"></i> <?php echo _("IIS Web Server"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/mysql'); ?>"><i class="fa fa-database"></i> <?php echo _("MySQL"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/mssql'); ?>"><i class="fa fa-database"></i> <?php echo _("MS SQL"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/php'); ?>"><i class="fa fa-code"></i> <?php echo _("PHP"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/linux-files'); ?>"><i class="fa fa-linux"></i> <?php echo _("Linux Files"); ?></a></li>
        <li><a href="<?php echo site_url('configure/source/windows-files'); ?>"><i class="fa fa-windows"></i> <?php echo _("Windows Files"); ?></a></li>

        <li class="nav-header"><?php echo _("Archived Logs"); ?></li>
        <li><a href="<?php echo site_url('configure/source/import'); ?>"><i class="fa fa-file-o"></i> <?php echo _("Import From File"); ?></a></li>

    </ul>
</div>

<script type="text/javascript">
$(document).ready(function() {

    $('pre code').each(function(i, block) {
        hljs.highlightBlock(block);
    });

    // Add enter key binding for verify
    $('input[name="sender_ip"]').keyup(function(event) {
        if (event.keyCode == 13) {
            $("#verify").click();
        }
    });

    // Verify incoming logs via ip and possibly type
    $('#verify').click(function() {
        var sender_ip = $('input[name="sender_ip"]').val();
        if (sender_ip) {
            $('#verify-loading').show();
            search = "q=host:" + sender_ip.replace(/:/g, '\\:');
 
            // Check for type
            var type = $(this).data('type');
            if (type) {
                search += ' AND type:' + type;
            }

            // Submit search to elasticsearch
            var index = "logstash-<?php echo date("Y.m.d", time()); ?>";
            var api_url = "<?php echo site_url('api/backend/'); ?>/" + index + "/_count?";
            api_url += search;

            $.get(api_url, { }, function(data) {
                $('#verify-loading').hide();
                if (data.count > 0) {
                    var type = '';
                    if (type) { type = ' <?php echo _("marked as"); ?> "' + type + '"'; }
                    text = "<b><?php echo _('Verified.'); ?></b> <?php echo _('There are '); ?> <b>" + data.count + "</b> <?php echo _('logs'); ?> " + type + " <?php echo _('for the host'); ?> <b>" + sender_ip + "</b>.";
                } else {
                    text = "<b><?php echo _('No logs found.'); ?></b> <?php echo _('No logs from that host in the database. The sender\'s firewall may be blocking the logs or the sender may be misconfigured.'); ?>";
                }
                $('#verify-output').html(text).show();
            });

        } else {
            $('#verify-output').html("<?php echo _('You must enter the IP address of the log sender you configured.'); ?>").show();
        }
    });

});
</script>
