<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-linux"></i>
                        </div>
                        <h1><?php echo _('Linux Files'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>
                    <p><?php echo _("This guide will walk you through the process of sending log files to Nagios Log Server. There are two setup methods, one using the automatic setup utility that comes with Log Server and one for manually setting up rsyslog."); ?></p>

                    <div class="tabbable">

                        <h3><?php echo _("Configuration Setup"); ?></h3>

                        <ul class="nav nav-tabs nav-tabs-help">
                            <li class="active"><a href="#script" data-toggle="tab"><i class="fa fa-file-code-o"></i> <?php echo _("Automatic"); ?></a></li>
                            <li><a href="#manual" data-toggle="tab"><i class="fa fa-terminal"></i> <?php echo _("Manual (rsyslog)"); ?></a></li>
                        </ul>

                        <div class="tab-content">
                            
                            <div class="tab-pane active" id="script" style="padding-top: 10px;">
                                <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                                <div>
                                    <ul style="margin: 0 0 10px 30px;">
                                        <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                                        <li><?php echo _('Ubuntu and Debian'); ?></li>
                                    </ul>
                                </div>
                                <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                                <h6><?php echo _("Run the Script"); ?></h6>
                                <p><?php echo _("Send a log file using the utility script"); ?>:</p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="1"><?php echo $step2; ?></code></pre>
                                </div>
                                <p><?php echo _("You will need to replace the "); ?><b>/path/to/file</b><?php echo _(" to be the path to the file you are monitoring. Replace "); ?><b>FILE_TAG</b><?php echo _(" with a tag to identify logs from the file. It is used for the 'program' field in Log Server."); ?></p>
                            </div>

                            <div class="tab-pane" id="manual" style="padding-top: 10px;">
                                <h6><?php echo _("Verify Spool and Config Location"); ?></h6>
                                <p><?php echo _("Put the following in your terminal window to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will give you the path you will need to add in the next section for <b>\$WorkDirectory</b> in the configuration. Then it will open the <code>rsyslog.conf</code> file."); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="2"><?php echo $step3; ?></code></pre>
                                </div>
                                <h6><?php echo _("Setup the Rsyslog Configuration File"); ?></h6>
                                <p><?php echo _("Add the following to the <code>rsyslog.conf</code>. Look for the 'begin forwarding rule.'"); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="apache" tabindex="3"><?php echo $step4; ?></code></pre>
                                </div>
                                <p><?php echo _("Replace each variable"); ?> <b>FILE_PATH</b> <?php echo _("with the unique file name you want to monitor and each"); ?> <b>FILE_TAG</b> <?php echo _("with an application name or nickname for the file."); ?></p>
                                <div style="margin: 10px; padding-left: 25px;">
                                    <p><i><?php echo _("Replace the following above:"); ?></i></p>
                                    <p><?php echo _("FILE_PATH: The absolute path to the file itself."); ?></p>
                                    <p><?php echo _("FILE_TAG: A tag to identify logs from the file. It is used for the 'program' field in Log Server."); ?></p>
                                    <p><?php echo _("FILE_ID: An identifier for this file. This must be unique on the host. Spaces are not allowed."); ?></p>
                                </div>
                                <p><?php echo _("You will also need to replace"); ?><b> $WorkDirectory</b> <?php echo _("with the unique file path of the rsyslog spool directory. This was displayed from the command on line 2 of the previous codeblock. If this isn't set correctly the rsyslog service will error on restart."); ?></p>
                                <p><?php echo _("Example: \$WorkDirectory /var/lib/rsyslog"); ?></p>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>
