<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-linux"></i>
                        </div>
                        <h1><?php echo _('Linux'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>

                    <p><?php echo _("This setup guide will go over both automatic and manual settings for Linux to send the system's logs to Log Server. After configuration you should immediately start receiving the logs that you would normally view in the <code>/var/log/messages</code> file on the Linux system you configured."); ?></p>

                    <div class="tabbable">

                        <h3><?php echo _("Configuration Setup"); ?></h3>

                        <ul class="nav nav-tabs nav-tabs-help">
                            <li class="active"><a href="#script" data-toggle="tab"><i class="fa fa-file-code-o"></i> <?php echo _("Automatic"); ?></a></li>
                            <li><a href="#manual" data-toggle="tab"><i class="fa fa-terminal"></i> <?php echo _("Manual (rsyslog)"); ?></a></li>
                            <li><a href="#syslog-ng" data-toggle="tab"><i class="fa fa-terminal"></i> <?php echo _("Manual (syslog-ng)"); ?></a></li>
                        </ul>

                        <div class="tab-content">

                            <div class="tab-pane active" id="script">
                                <div class="alert alert-info" style="margin: 20px 0;">
                                    <p><i class="fa fa-exclamation-circle fa-14" style="margin-right: 5px;"></i> <?php echo _("This uses a script to configure your syslogs to send to Log Server. To customize your syslog install, configure syslog manually by click on one of the tabs above."); ?></p>
                                </div>
                                <h6><?php echo _("Automatic Script - Supported Operating Systems"); ?></h6>
                                <div>
                                    <ul style="margin: 0 0 10px 30px;">
                                        <li><?php echo _('CentOS, Fedora, and RHEL'); ?></li>
                                        <li><?php echo _('Ubuntu and Debian'); ?></li>
                                    </ul>
                                </div>
                                <p><i><?php echo _('You must have rsyslog installed. If your operating system is not listed, you can manually configure syslog.'); ?></i></p>
                                <h6><?php echo _("Run the Script"); ?></h6>
                                <p><?php echo _("On the system you want to send logs from, run the following commands to download and run the script to automatically setup rsyslog."); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="1"><?php echo $step1; ?></code></pre>
                                </div>
                            </div>

                            <div class="tab-pane" id="manual" style="padding-top: 10px;">
                                <h6><?php echo _("Verify Spool and Config Location"); ?></h6>
                                <p><?php echo _("Put the following commands in your terminal window to verify the rsyslog spool directory and that the rsyslog.d folder exists. The second line will output the spool path you will need to add in the next section for \$WorkDirectory in the configuration."); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="2"><?php echo $step2; ?></code></pre>
                                </div>
                                <h6><?php echo _("Setup the Rsyslog Configuration File"); ?></h6>
                                <p><?php echo _("Edit your"); ?> <code>/etc/rsyslog.conf</code> <?php echo _("file"); ?>. <?php echo _("Add the following to to the configuration file, looking for the 'begin forwarding rule.'"); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="apache" tabindex="3"><?php echo $step3; ?></code></pre>
                                </div>
                                <p><?php echo _("You will need to replace "); ?><b>$WorkDirectory</b><?php echo _(" with the unique file path of the rsyslog spool directory. This was displayed from the command on line 2 of the previous code block. If there is no directory specified, or the directory specified doesn't exist, then the rsyslog service will error on restart."); ?></p>
                                <p><?php echo _("Example:  \$WorkDirectory /var/lib/rsyslog"); ?></p>
                                <p><?php echo _("Restart the rsyslog service"); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="4"><?php echo "sudo /etc/init.d/rsyslog restart"; ?></code></pre>
                                </div>
                            </div>

                            <div class="tab-pane" id="syslog-ng" style="padding-top: 10px;">
                                <h6><?php echo _("Setup the syslog-ng Configuration File"); ?></h6>
                                <p><?php echo _("Add the following to the syslog-ng configuration file, usually located at"); ?> <code>/etc/syslog-ng/syslog-ng.conf</code>.</p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="5"><?php echo $step4; ?></code></pre>
                                </div>
                                <p><?php echo _("Restart the syslog-ng service"); ?></p>
                                <div class="code-tooltip">
                                    <i class="fa fa-copy copy-button"></i>
                                    <pre><code class="shell" tabindex="6"><?php echo "sudo /etc/init.d/syslog-ng restart"; ?></code></pre>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" data-type="syslog" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>