<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-database"></i>
                        </div>
                        <h1><?php echo _('MS SQL'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>
                    <p><?php echo _("If you're running MS SQL you can get your logs through Nxlog, which sends Windows event logs to Nagios Log Server."); ?></p>

                    <h3><?php echo _("Requirements"); ?></h3>
                    <p><?php echo _("In order to send Windows event logs (including MS SQL logs) you will need to run the"); ?> <a href="<?php echo site_url('source/windows'); ?>"><?php echo _("Windows source setup"); ?></a> <?php echo _("guide to install Nxlog"); ?>.</p>

                    <h3><?php echo _("Configuration Setup"); ?></h3>
                    <p><?php echo _("Make sure you've followed the configuration for Windows in the requirements above. Once the Windows event logs are being sent to Log Server, your MS SQL servers logs will automatically be sent also. Verify below that you are receiving Windows event logs from the MS SQL server IP/hostname below."); ?> </p>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>