<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-exchange"></i>
                        </div>
                        <h1><?php echo _('Network Device'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>
                    <p><?php echo _("You can send your logs from any network device that allows log reporting. Below we have examples of Cisco and Juniper network devices and how to set them up. We also have a brief explanation of how to set up a generic device that is capable of log reporting."); ?></p>

                    <div class="tabbable">

                        <h3><?php echo _("Configuration Setup"); ?></h3>
                        <p><?php echo _("If the network device can send system logs to an external source, you can send network device logs to the location below."); ?></p>
                        <div style="margin-bottom: 20px;">
                            <table class="table table-condensed table-auto-width table-bordered">
                                <tr>
                                    <th><?php echo _("Log Server IP/Hostname"); ?></th>
                                    <th><?php echo _("TCP/UDP Port"); ?></th>
                                </tr>
                                <tr>
                                    <td><?php echo $hostname; ?></td>
                                    <td><?php echo $port; ?></td>
                                </tr>
                            </table>
                        </div>

                        <ul class="nav nav-tabs nav-tabs-help">
                            <li class="active"><a href="#generic" data-toggle="tab"><?php echo _("Generic"); ?></a></li>
                            <li><a href="#cisco" data-toggle="tab"><?php echo _("Cisco"); ?></a></li>
                            <li><a href="#juniper" data-toggle="tab"><?php echo _("Juniper"); ?></a></li>
                        </ul>

                        <div class="tab-content" style="margin-top: 20px;">

                            <div class="tab-pane active" id="generic">
                                <h6><?php echo _("Add a Syslog Server"); ?></h6>
                                <p>
                                    <?php echo _("Go to the network device's User Interface and log in. Got to the Administration section and find the event logging or system logging section. Devices normally have a configuration field that requires an IP address and port. Fill in the information with the server information above."); ?>
                                </p>
                                <p><?php echo _("Note: Some devices require you to turn on event or system logging before the device will send logs."); ?></p>
                            </div>

                            <div class="tab-pane" id="cisco">
                                <h6><?php echo _("Add a Syslog Server"); ?></h6>
                                <p><?php echo _("Go to <i>Administration > System Logs > Remote Log Servers</i> and you will see a table of currently configured syslog servers. Click on the add button to create a new <i>Remote Log Server</i> and you should see the second popup below."); ?></p>
                                <div style=" margin-bottom: 10px;">
                                    <img src="<?php echo base_url('media/images/cisco_syslog.png'); ?>">
                                </div>
                                <p><?php echo _("Fill in the required two fields with the IP/hostname and port given above."); ?></p>
                                <div style="position: relative; margin-bottom: 10px;">
                                    <img src="<?php echo base_url('media/images/cisco_syslog_add.png'); ?>">
                                    <div style="position: absolute; top: 130px; left: 210px; font-size: 9px;"><?php echo $hostname; ?></div>
                                    <div style="position: absolute; top: 161px; left: 210px; font-size: 9px;"><?php echo $port; ?></div>
                                </div>
                                <p><?php echo _("Once you're done, click apply and you should start seeing logs."); ?></p>
                            </div>

                            <div class="tab-pane" id="juniper">
                                <p><?php echo _("This section will show you how to set up your syslog configuration on a Juniper network device. Some routers may have a slightly different user interface. If you would like to configure your device from the command line or would like more information, you can take a look at"); ?> <a target="_new" href="https://www.juniper.net/documentation/us/en/software/junos/cli-reference/topics/ref/statement/syslog-edit-system.html"><?php echo _("Juniper's guide for syslog setup"); ?></a>.</p>
                                <h6><?php echo _("Enable Syslog"); ?></h6>
                                <p><?php echo _("In order to have your device send syslogs, go to <i>Configuration > Report Settings > Syslog</i> and make sure that the <i>Enable syslog messages</i> checkbox is checked."); ?></p>
                                <h6><?php echo _("Add a Syslog Server"); ?></h6>
                                <p><?php echo _("Also inside of the <i>Syslog</i> section you should see a section similar to the one shown below. We select the checkbox to enable syslog messages, set the IP/Hostname and Port. You can select both event log and traffic logs."); ?></p>
                                <div style="position: relative; margin-bottom: 10px;">
                                    <img src="<?php echo base_url('media/images/juniper_syslog.png'); ?>">
                                    <div style="position: absolute; top: 49px; left: 102px; font-size: 9px;"><?php echo $hostname; ?></div>
                                    <div style="position: absolute; top: 49px; left: 224px; font-size: 9px;"><?php echo $port; ?></div>
                                </div>
                                <p><?php echo _("Once you're done, click apply and you should start receiving logs."); ?></p>
                            </div>

                        </div>

                    </div>


                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>


                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>