<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-windows"></i>
                        </div>
                        <h1><?php echo _('Windows Files'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>
                    <p><?php echo _("This guide will show how to use NXLog to send logs from a file to Nagios Log Server."); ?></p>

                    <h3><?php echo _("Requirements"); ?></h3>
                    <p><?php echo _("In order to send Windows log files you will need to run the"); ?> <a href="<?php echo site_url('source/windows'); ?>"><?php echo _("Windows source setup"); ?></a> <?php echo _("guide to install NXLog"); ?>.</p>

                    <h3><?php echo _("Configuration Setup"); ?></h3>
                    <h6><?php echo _("Create the NXLog Input"); ?></h6>
                    <p><?php echo _("You can send logs from a specific Windows file to Nagios Log Server. Copy the following Input and add it into the nxlog.conf file on the host where the file is located. This is usually located in <code>C:\Program Files (x86)\\nxlog\conf\\nxlog.conf</code>. You can have multiple inputs, but be sure they are all included in the route section which is covered below."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="apache" tabindex="1"><?php echo $step2; ?></code></pre>
                    </div>
                    <p><?php echo _("You should rename "); ?><b>windowsfile</b><?php echo _(" to the name of the file you desire to monitor. <i>The nxlog.conf Input name must be unique.</i>"); ?></p>
                    <p><?php echo _("You should change "); ?><b>'C:\path\to\target\file'</b><?php echo _(" to the path of the file you desire to monitor. <i>The path must be inside single quotes.</i>"); ?></p>
                    <h6><?php echo _("Route the Output"); ?></h6>
                    <p><?php echo _("While adding the Input and filename of the file you are monitoring you will need to add to the route section in the configuration right under the input section above."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="apache" tabindex="2"><?php echo $step3; ?></code></pre>
                    </div>
                    <p><?php echo _("Again, You will need to rename "); ?><b>windowsfile</b><?php echo _(" to the name of the file you desire to monitor."); ?></p>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>