<?php echo $header; ?>

<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">

        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-12">

                    <div class="lgray-gradient-bg">
                        <div class="gray-gradient-bg gradient-logo">
                            <i class="fa fa-xl fa-fw fa-windows"></i>
                        </div>
                        <h1><?php echo _('Windows'); ?></h1>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Getting Started"); ?></h3>

                    <p><?php echo _("While there are many agents available for Windows that can send logs to Nagios Log Server, we recommend using NXLog. NXLog is an agent that will allow you to send your Windows event logs. Get started by downloading "); ?><a href="<?php echo base_url('scripts/nxlog-ce-latest.msi'); ?>"><?php echo _("NXLog CE"); ?></a> <?php echo _("and install it on the Windows desktop or server you want to receive logs from."); ?></p>

                    <h3><?php echo _("Configuration Setup"); ?></h3>
                        
                    <h6><?php echo _("Configure Windows Event Logs using NXLog"); ?></h6>
                    <p><?php echo _("Save the entire contents below to your nxlog.conf file usually located in"); ?> <code>C:\Program Files\nxlog\conf\nxlog.conf</code> or <code>C:\Program Files (x86)\nxlog\conf\nxlog.conf</code></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="apache" tabindex="1"><?php echo $step2; ?></code></pre>
                    </div>

                    <h6><?php echo _("Start the NXLog Service"); ?></h6>
                    <p><?php echo _("The NXLog service must be started to start sending the eventlog data. You can start it from the Services admin panel or in the command line, you can run the following command."); ?></p>
                    <div class="code-tooltip">
                        <i class="fa fa-copy copy-button"></i>
                        <pre><code class="shell" tabindex="2">net start nxlog</code></pre>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="col-sm-12 col-lg-8">

                    <h3><?php echo _("Verify Incoming Logs"); ?></h3>
                    <p><?php echo _("Once you have configured the log sender, you should start receiving logs right away. Put in the sender's IP address to see if you are receiving logs from that IP."); ?></p>
                    <div class="form-inline">
                        <div class="input-group">
                            <div class="input-group-addon"><?php echo _("IP Address"); ?></div>
                            <input type="text" name="sender_ip" class="form-control">
                        </div>
                        <button id="verify" class="btn btn-sm btn-default"><?php echo _("Verify"); ?></button>
                        <span id="verify-loading" class="hide"><i class="fa fa-spinner fa-pulse fa-fw"></i></span>
                    </div>
                    <div class="verify">
                        <div class="well hide" id="verify-output"></div>
                    </div>

                </div>
            </div>
        </div>
    
    </div>
</div>

<?php echo $footer; ?>
