<?php echo $header; ?>

<script type="text/javascript">

function load_highcharts()
{
    Highcharts.setOptions({
    lang: {
        thousandsSep: ','
    }
    });
    
    var hc_data = [];
    var alert_data = [];

    const log_count = Highcharts.chart('chart', {
        chart: {
            type: "spline"
        },
        credits: {
            enabled: false
        },
        title: {
            text: "<?php echo _('Number of Logs Per 15 Minutes'); ?>"
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        xAxis: {
            type: "datetime"
        },
        yAxis: {
            title: {
                text: ""
            }
        },
        series: [
            {
                name: "<?php echo _('Logs'); ?>",
                data: hc_data,
                color: "#03a645"
            }
        ]
    });
    log_count.showLoading();

    const column_weeks = Highcharts.chart('column2WKs', {
        credits: {
            enabled: false
        },
        chart: {
            type: 'column'
        },
        title: {
            text: "<?php echo _('Total Log Entries Within The Last Two Weeks'); ?>"
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        subtitle: {
            text: "<?php echo _('Logs Per Index - Sorted by Week Day'); ?>"
        },
        xAxis: {
            type: 'category',
        },
        yAxis: [{
            min: 0,
            title: {
                text: "<?php echo _('Log Entries'); ?>"
            }
        }],
        legend: {
            shadow: false
        },
        tooltip: {
            shared: false
        },
        plotOptions: {
            column: {
                grouping: false,
                shadow: false,
                borderWidth: 0
            },
            series: {
                cursor: 'pointer',
                point: {
                    events: {
                        click: function () {
                            location.href = '<?php $_SERVER['HTTP_REFERER'] ?>'+'admin/index_status';
                        }
                    }
                }
            }
        },
    });
    column_weeks.showLoading();

    const days_chart = Highcharts.chart('days-chart', {
        chart: {
            type: "spline"
        },
        credits: {
            enabled: false
        },
        title: {
            text: "<?php echo _('Total and Top 5 Senders Per 12 Hours'); ?>"
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        xAxis: {
            type: "datetime"
        },
        yAxis: {
            title: {
                text: ""
            }
        },
    });
    days_chart.showLoading();

    var hc_usage_data = [];

    const usage_chart = Highcharts.chart('usage-chart', {
        chart: {
            type: "spline"
        },
        credits: {
            enabled: false
        },
        title: {
            text: "<?php echo _('Disk Usage - Current Index');?>"
        },
        subtitle: {
            text: "<?php echo sprintf(_('Includes primary and replica shards across entire cluster - see %1$sIndex Status%2$s for primary shard only'), '<a href=\"'.site_url('admin/index_status').'\">', '</a>'); ?>",
            useHTML: true
        },
        lang: {
            noData: "<?php echo _(' '); ?>"
        },
        tooltip: {
            dateTimeLabelFormats: {
                millisecond:"%A, %b %e, %H:%M",
                second:"%A, %b %e, %H:%M",
                minute:"%A, %b %e, %H:%M",
                hour:"%A, %b %e, %H:%M",
                day:"%A, %b %e, %H:%M",
                week:"%A, %b %e, %H:%M",
                month:"%A, %b %e, %H:%M",
                year:"%A, %b %e, %H:%M"
            },
            valueSuffix: '<?php if (isset($hc_usage_data_human_unit)) { echo $hc_usage_data_human_unit; } ?>'
        },
        xAxis: {
            type: "datetime",
        },
        yAxis: {
            title: {
                text: ""
            }
        },
        series: [
            {
                name: "<?php echo sprintf(_('Total Size (%s)'), $hc_usage_data_human_unit); ?>",
                data: hc_usage_data,
                color: "#03a645"
            },

        ]
    });
    usage_chart.showLoading();

    var es_drive_node_names = '';
    var es_drive_series = '';

    const disk_chart = Highcharts.chart('disk-chart', {
        chart: {
            type: 'bar'
        },
        credits: {
            enabled: false
        },
        title: {
            text: '<?php echo _('Total Elasticsearch Disk Usage'); ?>'
        },
        xAxis: {
            categories: es_drive_node_names
        },
        yAxis: {
            min: 0,
            title: {
                text: '<?php echo _("Disk Usage (GiB)"); ?>'
            }
        },
        tooltip: {
            valueSuffix: "GiB"
        },
        legend: {
            reversed: true
        },
        plotOptions: {
            series: {
                stacking: 'normal'
            }
        },
        series: es_drive_series
    });
    disk_chart.showLoading();
}

$(document).ready(function() {

    load_highcharts();

    // Update check
    <?php if (is_admin()) { ?>
        $.get('<?php echo site_url('dashboard/do_update_check') ?>', {}, function(data) {
            if (data != "") {
                $('#updates').html(data);
            } else {
                $('#updates-box').hide();
            }
        });
    <?php } ?>

    var load_dashboards = function() {
        $.post(site_url + 'api/user/get_dashboards', function(data) {
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    $('#mydash tbody').append('<tr><td><a href="' + site_url + 'dashboard#/dashboard/elasticsearch/' + value.id + '">' + value.title + '</a></td></tr>');
                });
            } else {
                $('#mydash tbody').append("<tr><td>" + <?php echo json_encode(htmlentities(_("You don't have any dashboards"), ENT_QUOTES, 'UTF-8')); ?> + "</td></tr>");
            }
        }, 'json');
        $.post(site_url + 'api/system/get_global_dashboards', function(data) {
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    $('#globaldash tbody').append('<tr><td><a href="' + site_url + 'dashboard#/dashboard/elasticsearch/' + value.id + '">' + value.title + '</a></td></tr>');
                });
            } else {
                $('#globaldash tbody').append('<tr><td>' + JSON.parse(<?php echo json_encode(_("There are no global dashboards")); ?>) + '</td></tr>');
            }
        }, 'json');
    }

    var load_queries = function() {
        var cachebuster = Date.now(); 
        $.post(site_url + 'api/check/get_queries?cb=' +cachebuster, function(data) {
            var has_queries = false;
            if ($(data).length > 0) {
                $.each(data, function(index, value) {
                    if (value.show_everyone) {
                        $('#globalqueries tbody').append('<tr><td><a href="' + site_url + 'alerts/show_query/' + value.id + '">' + value.name + '</a></td></tr>');
                    } else {
                        has_queries = true;
                        $('#queries tbody').append('<tr><td><a href="' + site_url + 'alerts/show_query/' + value.id + '">' + value.name + '</a></td></tr>');
                    }
                });
            }

            if (!has_queries) {
                $('#queries tbody').append('<tr><td>' + JSON.parse('<?php echo json_encode(_("You have not created any queries")); ?>') + '</td></tr>');
            }

            // Display defaults for globals if none exist
            if ($('#globalqueries tbody tr').length == 0) {
                $('#globalqueries tbody').append('<tr><td>' + JSON.parse('<?php echo json_encode(htmlentities(_("There are no global queries"), ENT_QUOTES, 'UTF-8')); ?>') + '</td></tr>');
            }

        }, 'json');
    }

    load_dashboards();
    load_queries();

    // Auto-complete POC
    var searchables = [ "security breaches" ];
    $('#auto').autocomplete({
        source: searchables
    });

    //load Log Per 15 Minutes chart
    $.ajax({
        url: site_url + 'api/chart/log_count_15_minutes',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var hc_data = [];
            var alert_data = [];
            $.each(data_array, function(key, value) {
                hc_data.push([ value.key, value.doc_count ]);
            });
            document.getElementById('chart').highchart = Highcharts.chart('chart', {
                title: {
                    text: "<?php echo _('Number of Logs Per 15 Minutes'); ?>"
                },
                credits: {
                    enabled: false
                },
                lang: {
                    noData: "<?php echo _('No data to display'); ?>"
                },
                xAxis: {
                    type: "datetime"
                },
                series: [
                    {
                        name: "<?php echo _('Logs'); ?>",
                        data: hc_data,
                        color: "#03a645"
                    }
                ]
            });
            $('#chart').highcharts().hideLoading();
        }
    });

    //load Total and Top 5 Senders Per 12 Hours chart
    $.ajax({
        url: site_url + 'api/chart/total_and_top_senders',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var hc_data = [];
            var hc_names = [];
            var alert_data = [];
            var hc_total = [];
            var host_colors = ["#800080", "#DA70D6", "#00B2CA", "#191308", "#FFA500"];

            $.each(data_array['data'], function(key, value) {
                hc_data[key] = [];
                $.each(value, function(key2, value2) {
                    hc_data[key].push([ value2.key, value2.doc_count ]);
                });
            });

            $.each(data_array['names'], function(key, value) {
                hc_names.push([ value ]);
            });
            var num_hosts = hc_names.length;

            $.each(data_array['total'], function(key, value) {
                hc_total.push([ value.key, value.doc_count ]);
            });

            document.getElementById('days-chart').highchart = Highcharts.chart('days-chart', {
                chart: {
                    type: "spline"
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: "<?php echo _('Total and Top 5 Senders Per 12 Hours'); ?>"
                },
                lang: {
                    noData: "<?php echo _('No data to display'); ?>"
                },
                xAxis: {
                    type: "datetime"
                },
                yAxis: {
                    title: {
                        text: ""
                    }
                },
            });

            $('#days-chart').highcharts().addSeries(
                {
                    name: "<?php echo _('Total'); ?>",
                    data: hc_total,
                    color: "#03a645"
                }
            );

            for (var i = 0; i < num_hosts; i++){
                var hc_data_host = [];
                $.each(hc_data[i], function(key, value) {
                    hc_data_host.push([ value.key, value.doc_count ]);
                });
                $('#days-chart').highcharts().addSeries(
                    {
                        name: hc_names[i],
                        data: hc_data[i],
                        color: host_colors[i % host_colors.length]
                    }
                );
            }

            $('#days-chart').highcharts().hideLoading();
        }
    });

    //load Total Log Entries Within the Last Two Weeks chart
    $.ajax({
        url: site_url + 'api/chart/total_logs_last_two_weeks',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var tw_data = [];
            var pw_data = [];
            var weekString = data_array['weekString'];
            $.each(data_array['twData'], function(key, value) {
                tw_data.push([ value ]);
            });
            $.each(data_array['pwData'], function(key, value) {
                pw_data.push([ value ]);
            });

            document.getElementById('column2WKs').highchart = Highcharts.chart('column2WKs', {
                credits: {
                    enabled: false
                },
                chart: {
                    type: 'column'
                },
                title: {
                    text: "<?php echo _('Total Log Entries Within The Last Two Weeks'); ?>"
                },
                lang: {
                    noData: "<?php echo _('No data to display'); ?>"
                },
                subtitle: {
                    text: "<?php echo _('Logs Per Index - Sorted by Week Day'); ?>"
                },
                xAxis: {
                    type: 'category',
                    categories: weekString
                },
                yAxis: [{
                    min: 0,
                    title: {
                        text: "<?php echo _('Log Entries'); ?>"
                    }
                }],
                legend: {
                    shadow: false
                },
                tooltip: {
                    shared: false
                },
                plotOptions: {
                    column: {
                        grouping: false,
                        shadow: false,
                        borderWidth: 0
                    },
                    series: {
                        cursor: 'pointer',
                        point: {
                            events: {
                                click: function () {
                                    location.href = '<?php $_SERVER['HTTP_REFERER'] ?>'+'admin/index_status';
                                }
                            }
                        }
                    }
                },
            });

            $('#column2WKs').highcharts().addSeries(
                {
                    name: "<?php echo _('Previous Week'); ?>",
                    data: pw_data,
                    color: '#434348',
                    tooltip:
                    {
                        valueSuffix: "<?php echo _(' Logs'); ?>",
                    },
                    pointPadding: 0.225,
                    pointPlacement: -0.2
                }
            );

            $('#column2WKs').highcharts().addSeries(
                {
                    name: "<?php echo _('This Week'); ?>",
                    color: '#03a645',
                    data: tw_data,
                    tooltip: {
                        valueSuffix: "<?php echo _(' Logs'); ?>",
                    },
                    pointPadding: 0.225,
                    pointPlacement: 0.2
                },
            );

            $('#column2WKs').highcharts().hideLoading();
        }
    });

    //load Disk Usage chart
    $.ajax({
        url: site_url + 'api/chart/disk_usage',
        type: 'POST',
        success: function(data) {
            var data_array = $.parseJSON(data);
            var data_points = JSON.parse(data_array[0]);
            var unit_of_measure = data_array[1];
            var hc_data = [];
            var alert_data = [];
            $.each(data_points, function(key, value) {
                hc_data.push([ value[0], value[1] ]);
            });
            document.getElementById('usage-chart').highchart = Highcharts.chart('usage-chart', {
                chart: {
                    type: "spline"
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: "<?php echo _('Disk Usage - Current Index');?>"
                },
                subtitle: {
                    text: "<?php echo sprintf(_('Includes primary and replica shards across entire cluster - see %1$sIndex Status%2$s for primary shard only'), '<a href=\"'.site_url('admin/index_status').'\">', '</a>'); ?>",
                    useHTML: true
                },
                lang: {
                    noData: "<?php echo _('No data to display'); ?>"
                },
                tooltip: {
                    dateTimeLabelFormats: {
                        millisecond:"%A, %b %e, %H:%M",
                        second:"%A, %b %e, %H:%M",
                        minute:"%A, %b %e, %H:%M",
                        hour:"%A, %b %e, %H:%M",
                        day:"%A, %b %e, %H:%M",
                        week:"%A, %b %e, %H:%M",
                        month:"%A, %b %e, %H:%M",
                        year:"%A, %b %e, %H:%M"
                    },
                    valueSuffix: unit_of_measure
                },
                xAxis: {
                    type: "datetime",
                },
                yAxis: {
                    title: {
                        text: ""
                    }
                },
                series: [
                    {
                        name: "<?php echo _('Total Size'); ?>" + " (" + unit_of_measure + ")",
                        data: hc_data,
                        color: "#03a645"
                    },

                ]
            });
            $('#usage-chart').highcharts().hideLoading();
        }
    });

    //load Total Elasticsearch Disk Usage chart
    $.ajax({
        url: site_url + 'api/chart/total_elasticsearch_disk_usage',
        type: 'POST',
        success: function(data) {
            var es_drive_status = $.parseJSON(data);
            var es_drive_node_names = Object.getOwnPropertyNames(es_drive_status);
            var es_drive_series = [{name: 'Free', data:[], color: '#03a645'}, {name: 'Used', data:[], color: '#434348'}];

            /* Marshal data-in-bytes to a Highcharts series using GiB */
            for (var i = 0; i < es_drive_node_names.length; i += 1) {
                var current_node = es_drive_status[es_drive_node_names[i]].total;

                var available_in_bytes = current_node.available_in_bytes;
                var available_in_GiB = Math.round(available_in_bytes / 10737418.24) / 100.0; // Rounded to two digits
                es_drive_series[0].data[i] = available_in_GiB;

                var used_in_bytes = current_node.total_in_bytes - current_node.available_in_bytes
                var used_in_GiB = Math.round(used_in_bytes / 10737418.24) / 100.0; // Rounded to two digits
                es_drive_series[1].data[i] = used_in_GiB;
            }

            document.getElementById('disk-chart').highchart = Highcharts.chart('disk-chart', {
                chart: {
                    type: 'bar'
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: '<?php echo _('Total Elasticsearch Disk Usage'); ?>'
                },
                xAxis: {
                    categories: es_drive_node_names
                },
                yAxis: {
                    min: 0,
                    title: {
                        text: '<?php echo _("Disk Usage (GiB)"); ?>'
                    }
                },
                tooltip: {
                    valueSuffix: "GiB"
                },
                legend: {
                    reversed: true
                },
                plotOptions: {
                    series: {
                        stacking: 'normal'
                    }
                },
                series: es_drive_series
            });
        }
    });
});

</script>

<div class="container-fluid home-dashboard">

    <div class="row">

        <div class="col-sm-6">
            <?php if (!is_admin()) { ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="chart"></div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="usage-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="days-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="<?php if (is_admin()) { echo 'col-sm-4 col-xl-4'; } else { echo 'col-sm-6'; } ?>">
                        <div class="well" style="text-align: center;">
                            <div class="dash-num"><?php echo $unique_hosts; ?></div>
                            <div><b><?php if ($unique_hosts == 1) { echo _('Unique Host'); } else { echo _('Unique Hosts'); } ?></b> <i class="fa fa-question-circle fa-help tt-bind" title="<?php echo _("Number of unique hosts sending logs to this cluster"); ?>"></i> &nbsp; <a href="<?php echo site_url('admin/unique_hosts'); ?>"><?php echo _("View"); ?></a></div>
                        </div>
                    </div>
                    <?php if (user_has_permission('alerts', array('view'))) { ?>
                    <div class="<?php if (is_admin()) { echo 'col-sm-4 col-xl-4'; } else if (user_has_permission('alerts', array('view'))) { echo 'col-sm-6 col-xl-6'; } ?>">
                        <div class="well" style="text-align: center;">
                            <div class="dash-num"><?php echo $alerts; ?></div>
                            <div><b><?php if ($alerts == 1) { echo _('Active Alert'); } else { echo _('Active Alerts'); } ?></b> <i class="fa fa-question-circle fa-help tt-bind" title="<?php echo _("Number of active alerts running"); ?>"></i> &nbsp; <a href="<?php echo site_url('alerts'); ?>"><?php if (user_has_permission('alerts', array('all'))) { echo _('Manage'); } else { echo _('View'); } ?></a></div>
                        </div>
                    </div>
                    <?php } if (is_admin()) { ?>
                    <div class="col-sm-4 col-xl-4">
                        <div class="well" style="text-align: center;">
                            <div class="dash-num"><?php echo $nodes; ?></div>
                            <div><b><?php echo _('Instances'); ?></b> <i class="fa fa-question-circle fa-help tt-bind" title="<?php echo _("Number of Log Server instances connected to the cluster"); ?>"></i></div>
                        </div>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php if (is_admin()) { ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="usage-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <div id="days-chart"></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>

            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well" style="margin: 0;">
                            <h3><?php echo _("Reach Out to Us"); ?></h3>
                            <?php if (is_trial()) { ?>
                            <p>
                                <strong><?php echo _("Want to learn more about how to use Nagios Log Server?"); ?></strong><br>
                                <a href="https://go.nagios.com/nagios-log-server-demo-request" target="_blank"><?php echo _("Request a live demo"); ?> <i class="fa fa-chevron-circle-right"></i></a>
                            </p>
                            <?php } ?>
                            <p>
                                <strong><?php echo _("We want your feedback."); ?></strong> <?php echo _("We want to hear about what we can do to make Nagios Log Server even better."); ?><br>
                                <a href="https://go.nagios.com/nagios-log-server-feedback" target="_blank"><?php echo _("Give us feedback"); ?> <i class="fa fa-chevron-circle-right"></i></a>
                            </p>
                            <p style="padding-bottom: 0;">
                                <strong><?php echo _("Need help?"); ?></strong> <?php echo _("If you're stuck and need assistance you can contact us directly with a request for assistance. We will redirect your request to the correct team internally for the fastest resolution."); ?><br>
                                <a href="https://go.nagios.com/nagios-log-server-request-for-assistance" target="_blank"><?php echo _("Request assistance"); ?> <i class="fa fa-chevron-circle-right"></i></a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-sm-6">


            <?php if (user_has_permission('configure', array('view'))) { ?>
            <div class="container-fluid fix-height">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="well">
                            <h2 style="margin: 0; padding: 0; text-align: center;"><?php echo _('Add a log source to start collecting logs'); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container-fluid fix-height">
                <div class="row">
                    <div class="col-sm-6 col-xl-3">
                        <a class="click-box" href="<?php echo site_url('configure/source/windows'); ?>">
                            <div><i class="fa fa-xl fa-windows"></i></div>
                            <div class="box-text"><i class="fa fa-plus fa-l"></i> <?php echo _('Windows'); ?></div>
                        </a>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <a class="click-box" href="<?php echo site_url('configure/source/linux'); ?>">
                            <div><i class="fa fa-xl fa-linux"></i></div>
                            <div class="box-text"><i class="fa fa-plus fa-l"></i> <?php echo _('Linux'); ?></div>
                        </a>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <a class="click-box" href="<?php echo site_url('configure/source/network'); ?>">
                            <div><i class="fa fa-xl fa-exchange"></i></div>
                            <div class="box-text"><i class="fa fa-plus fa-l"></i> <?php echo _('Network Device'); ?></div>
                        </a>
                    </div>
                    <div class="col-sm-6 col-xl-3">
                        <a class="click-box" href="<?php echo site_url('configure/add-log-source'); ?>">
                            <div><i class="fa fa-xl fa-ellipsis-h"></i></div>
                            <div class="box-text"><i class="fa fa-plus fa-l"></i> <?php echo _('Other'); ?></div>
                        </a>
                    </div>
                </div>
            </div>
            <?php } ?>

            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-13">
                        <div class="well">
                            <div id="column2WKs"></div>
                        </div>
                    </div>
                </div>
            </div>
            

            <div class="container-fluid">
                <div class="row">
                    <div class="well" style="height: 438px;">
                        <div id="disk-chart"></div>
                    </div>
                </div>
            </div>

            <div class="container-fluid" style="padding: 0 5px 0 0; margin-right: -5px">
                <div class="row fix-height">
                    <div class="col-sm-12 col-lg-6">
                        <div class="well">
                            <div class="tab-content">
                                <ul class="nav nav-tabs" style="border-bottom: none;">
                                    <li class="active" style="width: 50%;"><a style="margin-right: 0;" href="#global-dash" data-toggle="tab"><i class="fa fa-globe fa-14"></i> <?php echo _("Global Dashboards"); ?></a></li>
                                    <li style="width: 50%;"><a style="margin-right: 0;" href="#my-dash" data-toggle="tab"><?php echo _("My Dashboards"); ?></a></li>
                                </ul>
                                <div class="tab-pane active" id="global-dash">
                                    <table id="globaldash" class="table table-hover table-bordered" style="margin: 0;">
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <div class="tab-pane" id="my-dash">
                                    <table id="mydash" class="table table-hover table-bordered" style="margin: 0;">
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <?php if (is_admin()) { ?>
                        <div class="well" style="margin: 0;">
                            <h3><?php echo _("Update Check"); ?></h3>
                            <div id="updates"><span class="span1 offset2"><img style="width:16px;height:16px;" src="<?php echo base_url('media/images/ajax-loader.gif') ?>" alt="loading..." /></span></div>
                        </div>
                        <?php } ?>
                    </div>
                    <div class="col-sm-12 col-lg-6">
                        <div class="well">
                            <div class="tab-content">
                                <ul class="nav nav-tabs" style="border-bottom: none;">
                                    <li class="active" style="width: 50%;"><a style="margin-right: 0;" href="#global-queries" data-toggle="tab"><i class="fa fa-globe fa-14"></i> <?php echo _("Global Queries"); ?></a></li>
                                    <li style="width: 50%;"><a style="margin-right: 0;" href="#my-queries" data-toggle="tab"><?php echo _("My Queries"); ?></a></li>
                                </ul>
                                <div class="tab-pane active" id="global-queries">
                                    <table id="globalqueries" class="table table-hover table-bordered" style="margin: 0;">
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <div class="tab-pane" id="my-queries">
                                    <table id="queries" class="table table-hover table-bordered" style="margin: 0;">
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php echo $footer; ?>
