<?php echo $header; ?>

<script type="text/javascript">
$(document).ready(function() {

    $('#apikey').click(function() { this.select(); });

    $('#update_password_btn').click(function() {
        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This action is not available in Demo Mode.'); ?>");
        <?php } else { ?>
        $('#change_password').modal('show');
        <?php } ?>
    });

    $('#update_pass_btn').click(function() {
        var vars = { old_pass: $('input[name="old_pass"]').val(),
                     new_pass: $('input[name="new_pass"]').val(), 
                     new_pass2: $('input[name="new_pass2"]').val(),
                     '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }

        $('#update_pass_error').hide();
        $('#update_pass_msg').hide();

        $.post(site_url + 'auth/change_password', vars, function(data) {
            if (data.success == 1) { 
                $('#update_pass_msg').removeClass('alert-danger').addClass('alert-success').html('<?php echo _('Your password was successfully changed'); ?>').show();
                $('input[type="password"]').val(''); // Clear fields
                $('#update_pass_msg').delay(2000).fadeOut(800);
            } else {
                $('#update_pass_msg').removeClass('alert-success').addClass('alert-danger').html(data.errormsg).show();
            }
        }, 'json');
    });

    $('#update_profile_btn').click(function() {
        var vars = { name: $('input[name="name"]').val(),
                     email: $('input[name="email"]').val(),
                     '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }

        <?php if (is_demo_mode()) { ?>
        alert("<?php echo _('This action is not available in Demo Mode.'); ?>");
        <?php } else { ?>
        $.post(site_url + 'auth/update_profile', vars, function(data) {
            if (data.success == 1) {
                $('#update_profile_msg').removeClass('alert-danger').addClass('alert-success').html('<?php echo _('Your profile information has been updated.'); ?>').show();
                $('#update_profile_msg').delay(1000).fadeOut(800);
            } else {
                $('#update_profile_msg').removeClass('alert-success').addClass('alert-danger').html(data.errormsg).show();
            }
        }, 'json');
        <?php } ?>
    });

    // Change language
    $('#language').change(function() {
        var language = $(this).val();
        $.post(site_url + 'dashboard/setlanguage', { language: language, '<?php echo $csrf['name']; ?>': '<?php echo $csrf['hash']; ?>' }, function(data) {
            window.location.reload();
        });
    });

});
</script>

<div style="padding: 10px;">

    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <h1><?php echo _("My Profile"); ?></h1>
                <p style="margin-bottom: 40px;"><?php echo _("Edit your profile, contact information, account information, and manage your API key if you have API access."); ?></p>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-md-4 col-xl-3 col-xl-offset-1">
                <h3><?php echo _("Personal Information"); ?></h3>
                <p><?php echo _("Your personal information and account name."); ?></p>
                <div id="update_profile_msg" class="alert hide"></div>

                <table class="table table-condensed table-va-middle table-no-border">
                    <tr>
                        <td class="form-left"><?php echo _("Username"); ?>:</td>
                        <td><input type="text" class="form-control" value="<?php echo html_escape($user['username']); ?>" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="form-left"><?php echo _("Full Name"); ?>:</td>
                        <td><input type="text" class="form-control" name="name" value="<?php echo html_escape($user['name']); ?>"></td>
                    </tr>
                    <tr>
                        <td class="form-left"><?php echo _("Email"); ?>:</td>
                        <td><input type="text" class="form-control" style="width: 250px;" name="email" value="<?php echo html_escape($user['email']); ?>"></td>
                    </tr>
                    <tr>
                        <td class="form-left"></td>
                        <td><button id="update_profile_btn" class="btn btn-sm btn-primary"><?php echo _('Update'); ?></button></td>
                    </tr>
                </table>

            </div>
            <div class="col-sm-6 col-md-4 col-xl-3">
                <h3><?php echo _('Account Actions'); ?></h3>
                <p><?php echo _('Make changes to your account-specific settings.'); ?></p>

                <div class="input-group" style="width: 300px;">
                    <span class="input-group-addon"><i class="fa fa-flag fa-l"></i> <?php echo _('Language'); ?></span>
                    <select id="language" name="language" class="form-control">
                        <option value="default" <?php if ($user_language == 'default') { echo 'selected'; } ?>><?php echo _('Default'); ?></option>
                        <?php foreach ($languages as $l) { ?>
                        <option value="<?php echo $l; ?>" <?php if ($user_language == $language && $language == $l) { echo 'selected'; } ?>>
                            <?php echo get_language_name($l); ?>
                        </option>
                        <?php } ?>
                    </select>
                </div>
                <div style="margin-top: 10px;"><a role="button" class="btn btn-sm btn-default" id="update_password_btn"><i class="fa fa-lock fa-l"></i> <?php echo _('Change Password'); ?></a></div>
            </div>
            <div class="col-sm-6 col-md-4 col-xl-4">
                <h3><?php echo _('API Access / Key'); ?></h3>
                <div class="well">
                    <p><?php echo _('Your unique API key used for external API access. You can read more about what you can do with the API in the API documents in the help section.'); ?></p>
                    <?php if ($user['apiaccess']) { ?>
                    <p><strong><?php echo _('Access Level'); ?>:</strong> <?php if ($is_admin) { echo _('Full'); } else { echo _('Read-Only'); } ?></p>
                    <div><input type="text" value="<?php echo $user['apikey']; ?>" class="no-highlight form-control" style="cursor: pointer; box-shadow: none; width: 100%;" id="apikey" maxlength="32" readonly></div>
                    <div style="margin-top: 10px;">
                        <?php echo form_open('profile/newkey'); ?>
                        <input type="hidden" value="<?php echo $user['id']; ?>" name="user_id_verify" />
                        <button <?php if (is_demo_mode()) { echo 'disabled'; } ?> type="submit" class="btn btn-sm btn-primary"><i class="fa fa-refresh fa-l"></i> <?php echo _('Generate New Key'); ?></button>
                        <?php echo form_close(); ?>
                    </div>
                    <?php } else { ?>
                    <p><strong><?php echo _('No API Access'); ?></strong></p>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- Change Password Modal -->
<div id="change_password" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="change_password_header" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="change_password_header"><?php echo _('Change Password'); ?></h4>
            </div>
            <div class="modal-body">
                <p><?php echo _('Your new password must be 8 or more characters long for security.'); ?></p>
                <div id="update_pass_msg" class="alert hide"></div>
                <table class="table table-condensed table-no-border table-va-middle" style="margin: 10px;">
                    <tr>
                        <td class="form-left" style="width: 40%;"><?php echo _('Old Password'); ?>:</td>
                        <td><input type="password" name="old_pass" class="form-control" /></td>
                    </tr>
                    <tr>
                        <td class="form-left"><?php echo _('New Password'); ?>:</td>
                        <td><input type="password" name="new_pass" class="form-control" /></td>
                    </tr>
                    <tr>
                        <td class="form-left"><?php echo _('Confirm New Password'); ?>:</td>
                        <td><input type="password" name="new_pass2" class="form-control" /></td>
                    </tr>
                </table>
            </div>
            <div class="modal-footer">
                <button id="update_pass_btn" class="btn btn-sm btn-primary"><?php echo _('Update'); ?></button>
                <button class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _('Cancel'); ?></button>
            </div>
        </div>
    </div>
</div>


<?php echo $footer; ?>