<?php echo $header; ?>
<script>
    $(document).ready(function () {
        $('.delete').click(function(e) {
            e.preventDefault();
            $('#remove-confirm-modal').modal('show');
            let continue_function = function(href) {
                $.post(href, {}, function(data) {
                    if (data.hasOwnProperty('errmsg')) {
                        alert(data.errmsg);
                        return;
                    }
                    window.location.reload();
                }, 'json');
            } 
            $('#remove-continue').unbind();
            $('#remove-continue').click(() => continue_function(this.href));
        });
    })
</script>
<div class="configure-layout">
    <?php echo $leftbar; ?>
    <div class="rside">
        <h1 style="margin-bottom: 10px;"><?php echo _("Report Management"); ?></h1>
        <p><?php echo _('To add a report, interact with the save icon on the dashboard page.'); ?></p>
        <?php if (!empty($msg)) { ?>
        <div class="alert alert-<?php echo $msg_type; ?>" style="margin-bottom: 15px;"><div style='float: right;'><a href='#' class='close' data-dismiss='alert'>&times;</a></div><?php echo $msg; ?></div>
        <?php } ?>

        <table class="table table-striped table-condensed table-bordered">
            <thead>
                <tr>
                    <th><?php echo _("Report Name"); ?></th>
                    <th><?php echo _("Created By"); ?></th>
                    <th style="width: 140px; text-align: center;"><?php echo _("Actions"); ?></th>
                </tr>
            </thead>
            <tbody id="real-time-alert-list">
                <?php
                    if (count($reports) > 0) {
                        foreach ($reports as $report) {
                ?>
                <tr>
                    <td>
                        <?php echo html_escape($report['_source']['title']); ?>
                        <div class="clear"></div>
                    </td>
                    <td><?php echo array_key_exists('user', $report['_source']) ? $report['_source']['user'] : _('&lt;Creator not found&gt;'); ?></td>
                    <td class="actions">
                        <a class="view ls-tooltip" href="<?php echo site_url('reports/view/' . $report["_id"]); ?>" title="<?php echo _('View'); ?>"><i class="fa fa-chevron-right"></i></a>
                        <a class="delete ls-tooltip" href="<?php echo site_url('api/report/delete/' . $report['_id']); ?>" title="<?php echo _('Delete'); ?>">
                        <i class="fa fa-trash"></i></a>
                    </td>
                </tr>
                <?php 
                        } /* end foreach dashboard_reports */
                    } else {
                ?>
                <tr>
                    <td colspan="6"><?php echo _("You have no reports saved."); ?></td>
                </tr>
                <?php 
                    } 
                ?>
            </tbody>
        </table>
    </div>
</div>

<div id="remove-confirm-modal" class="modal hide fade" data-backdrop="static" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h2><?php echo _("Apply Configuration?"); ?></h2>
            </div>
            <div class="modal-body delete-modal-on-close">
                <?php echo _("This action will delete the report as well as any scheduled reports associated with it. Do you wish to continue?");?>
                <?php if (is_demo_mode()) { ?>
                <div class="alert alert-danger" style="margin: 0 0 15px 0;">
                    <?php echo _("This function is not available in demo mode."); ?>
                </div>
                <?php } ?>
            </div>
            <div class="modal-footer">
                <button type="button" id="remove-continue" class="btn btn-sm btn-success" <?php if (is_demo_mode()) { echo 'disabled'; } ?>><?php echo _("Continue"); ?></button>
                <button type="button" id="remove-cancel" class="btn btn-sm btn-default" data-dismiss="modal" aria-hidden="true"><?php echo _("Cancel"); ?></button>
            </div>
        </div>
    </div>
</div>


<?php echo $footer; ?>